/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.PathNotExist;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipRODirectory
extends Directory {
    public final ZipFile mZipFile;
    public final String mPath;

    public ZipRODirectory(File file) {
        ZipFile zipFile;
        String string = "";
        ZipFile zipFile2 = zipFile;
        try {
            zipFile = new ZipFile(file);
            this.mZipFile = zipFile2;
            this.mPath = string;
            return;
        }
        catch (IOException iOException) {
            throw new DirectoryException(iOException);
        }
    }

    public ZipRODirectory(ZipFile zipFile, String string) {
        this.mZipFile = zipFile;
        this.mPath = string;
    }

    @Override
    public final void load() {
        ZipRODirectory zipRODirectory = this;
        zipRODirectory.mFiles = new LinkedHashSet();
        zipRODirectory.mDirs = new LinkedHashMap();
        int n = zipRODirectory.mPath.length();
        Enumeration<? extends ZipEntry> enumeration = zipRODirectory.mZipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            if (string.equals(this.mPath) || !string.startsWith(this.mPath) || string.contains("../")) continue;
            int n2 = (string = string.substring(n)).indexOf(47);
            if (n2 == -1) {
                if (!zipEntry.isDirectory()) {
                    this.mFiles.add(string);
                    continue;
                }
            } else {
                string = string.substring(0, n2);
            }
            if (this.mDirs.containsKey(string)) continue;
            this.mDirs.put(string, new ZipRODirectory(this.mZipFile, this.mPath + string + "/"));
        }
    }

    @Override
    public final InputStream getFileInputImpl(String string) {
        ZipEntry zipEntry;
        ZipEntry zipEntry2;
        ZipFile zipFile;
        try {
            ZipEntry zipEntry3;
            zipFile = this.mZipFile;
            zipEntry2 = zipEntry3;
            zipEntry = zipEntry3;
        }
        catch (IOException iOException) {
            throw new PathNotExist(string, iOException);
        }
        zipEntry2(this.mPath + string);
        return zipFile.getInputStream(zipEntry);
    }

    @Override
    public final long getSize(String string) {
        ZipEntry zipEntry = ((ZipRODirectory)((Object)zipEntry)).mZipFile.getEntry(string);
        if (zipEntry != null) {
            return zipEntry.getSize();
        }
        throw new PathNotExist("Entry not found: " + string);
    }

    @Override
    public final int getCompressionLevel(String string) {
        ZipEntry zipEntry = ((ZipRODirectory)((Object)zipEntry)).mZipFile.getEntry(string);
        if (zipEntry != null) {
            return zipEntry.getMethod();
        }
        throw new PathNotExist("Entry not found: " + string);
    }

    @Override
    public final void close() {
        try {
            this.mZipFile.close();
            return;
        }
        catch (IOException iOException) {
            throw new DirectoryException(iOException);
        }
    }
}

