/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali.Adaptors.Format;

import com.android.tools.smali.baksmali.Adaptors.Format.InstructionMethodItem;
import com.android.tools.smali.baksmali.Adaptors.Format.SparseSwitchMethodItem$SparseSwitchLabelTarget;
import com.android.tools.smali.baksmali.Adaptors.Format.SparseSwitchMethodItem$SparseSwitchOffsetTarget;
import com.android.tools.smali.baksmali.Adaptors.Format.SparseSwitchMethodItem$SparseSwitchTarget;
import com.android.tools.smali.baksmali.Adaptors.LabelMethodItem;
import com.android.tools.smali.baksmali.Adaptors.MethodDefinition;
import com.android.tools.smali.baksmali.formatter.BaksmaliWriter;
import com.android.tools.smali.dexlib2.iface.instruction.Instruction;
import com.android.tools.smali.dexlib2.iface.instruction.SwitchElement;
import com.android.tools.smali.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import com.android.tools.smali.dexlib2.immutable.value.ImmutableIntEncodedValue;
import java.util.ArrayList;

public final class SparseSwitchMethodItem
extends InstructionMethodItem {
    public final ArrayList targets;
    public final boolean commentedOut;

    public SparseSwitchMethodItem(MethodDefinition object, int n, SparseSwitchPayload object2) {
        super((MethodDefinition)object, n, (Instruction)object2);
        n = ((MethodDefinition)object).sparseSwitchMap.get(n);
        this.targets = new ArrayList();
        if (n >= 0) {
            for (SwitchElement switchElement : object2.getSwitchElements()) {
                LabelMethodItem labelMethodItem = ((MethodDefinition)object).labelCache.internLabel(new LabelMethodItem(((MethodDefinition)object).classDef.options, switchElement.getOffset() + n, "sswitch_"));
                this.targets.add(new SparseSwitchMethodItem$SparseSwitchLabelTarget(switchElement.getKey(), labelMethodItem));
            }
        } else {
            this.commentedOut = true;
            object = object2.getSwitchElements().iterator();
            while (object.hasNext()) {
                SwitchElement switchElement;
                SwitchElement switchElement2 = switchElement = (SwitchElement)object.next();
                n = switchElement2.getKey();
                this.targets.add(new SparseSwitchMethodItem$SparseSwitchOffsetTarget(n, switchElement2.getOffset()));
            }
        }
    }

    @Override
    public final boolean writeTo(BaksmaliWriter baksmaliWriter) {
        if (this.commentedOut) {
            baksmaliWriter = this.methodDef.classDef.getCommentingWriter(baksmaliWriter);
        }
        BaksmaliWriter baksmaliWriter2 = baksmaliWriter;
        baksmaliWriter2.writer.write(".sparse-switch\n");
        baksmaliWriter2.indent();
        for (SparseSwitchMethodItem$SparseSwitchTarget sparseSwitchMethodItem$SparseSwitchTarget : this.targets) {
            BaksmaliWriter baksmaliWriter3 = baksmaliWriter;
            baksmaliWriter3.writeEncodedValue(new ImmutableIntEncodedValue(sparseSwitchMethodItem$SparseSwitchTarget.key));
            baksmaliWriter3.writer.write(" -> ");
            sparseSwitchMethodItem$SparseSwitchTarget.writeTargetTo(baksmaliWriter3);
            this.writeCommentIfResourceId(baksmaliWriter, sparseSwitchMethodItem$SparseSwitchTarget.key);
            baksmaliWriter.writer.write(10);
        }
        BaksmaliWriter baksmaliWriter4 = baksmaliWriter;
        baksmaliWriter4.deindent();
        baksmaliWriter4.writer.write(".end sparse-switch");
        return true;
    }
}

