/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.builder;

import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.builder.BuilderInstruction;
import com.android.tools.smali.dexlib2.builder.Label;
import com.android.tools.smali.dexlib2.builder.MethodLocation;
import com.android.tools.smali.dexlib2.iface.instruction.OffsetInstruction;
import com.android.tools.smali.util.ExceptionWithContext;

public abstract class BuilderOffsetInstruction
extends BuilderInstruction
implements OffsetInstruction {
    public final Label target;

    public BuilderOffsetInstruction(Opcode opcode, Label label) {
        super(opcode);
        this.target = label;
    }

    @Override
    public final int getCodeOffset() {
        BuilderOffsetInstruction builderOffsetInstruction = object;
        int n = builderOffsetInstruction.target.getLocation().codeAddress;
        MethodLocation methodLocation = builderOffsetInstruction.location;
        if (methodLocation != null) {
            Object object;
            n -= methodLocation.codeAddress;
            if (((BuilderInstruction)object).getFormat().size / 2 == 1) {
                if (n < -128 || n > 127) {
                    object = n;
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = object;
                    throw new ExceptionWithContext(null, "Invalid instruction offset: %d. Offset must be in [-128, 127]", objectArray2);
                }
            } else if (((BuilderInstruction)object).getFormat().size / 2 == 2 && (n < Short.MIN_VALUE || n > Short.MAX_VALUE)) {
                object = n;
                Object[] objectArray = new Object[1];
                Object[] objectArray3 = objectArray;
                objectArray[0] = object;
                throw new ExceptionWithContext(null, "Invalid instruction offset: %d. Offset must be in [-32768, 32767]", objectArray3);
            }
            return n;
        }
        throw new IllegalStateException("Cannot get the location of an instruction that hasn't been added to a method.");
    }
}

