/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList$1;
import com.google.common.collect.ImmutableList$Builder;
import com.google.common.collect.ImmutableList$ReverseImmutableList;
import com.google.common.collect.ImmutableList$SubList;
import com.google.common.collect.Lists;
import com.google.common.collect.RegularImmutableList;
import com.google.common.collect.SingletonImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public abstract class ImmutableList
extends ImmutableCollection
implements List,
RandomAccess {
    @Override
    public UnmodifiableIterator iterator() {
        return this.listIterator(0);
    }

    public AbstractIndexedListIterator listIterator(int n) {
        return new ImmutableList$1(this, this.size(), n);
    }

    @Override
    public void forEach(Consumer consumer) {
        consumer.getClass();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            consumer.accept(this.get(i));
        }
    }

    @Override
    public int indexOf(Object object) {
        int n;
        block3: {
            if (object == null) {
                return -1;
            }
            int n2 = this.size();
            for (n = 0; n < n2; ++n) {
                if (!object.equals(this.get(n))) {
                    continue;
                }
                break block3;
            }
            n = -1;
        }
        return n;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n;
        block3: {
            if (object == null) {
                return -1;
            }
            for (n = this.size() - 1; n >= 0; --n) {
                if (!object.equals(this.get(n))) {
                    continue;
                }
                break block3;
            }
            n = -1;
        }
        return n;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public ImmutableList subList(int n, int n2) {
        int n3 = n;
        Preconditions.checkPositionIndexes(n3, n2, immutableList.size());
        if ((n2 -= n3) == immutableList.size()) {
            return immutableList;
        }
        if (n2 == 0) {
            return RegularImmutableList.EMPTY;
        }
        if (n2 == 1) {
            ImmutableList immutableList = immutableList.get(n);
            return new SingletonImmutableList(immutableList);
        }
        return new ImmutableList$SubList(immutableList, n, n2);
    }

    public final boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }

    public final Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public final void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public final Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    public final void replaceAll(UnaryOperator unaryOperator) {
        throw new UnsupportedOperationException();
    }

    public final void sort(Comparator comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ImmutableList asList() {
        return this;
    }

    @Override
    public Spliterator spliterator() {
        return CollectSpliterators.indexed(this.size(), 1296, this::get);
    }

    public ImmutableList reverse() {
        if (this.size() <= 1) {
            return this;
        }
        return new ImmutableList$ReverseImmutableList(this);
    }

    @Override
    public final boolean equals(Object object) {
        return Lists.equalsImpl(this, object);
    }

    @Override
    public final int hashCode() {
        int n = 1;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            n *= 31;
            n = ~(~(this.get(i).hashCode() + n));
        }
        return n;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public int copyIntoArray(Object[] objectArray) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.get(i);
        }
        return n;
    }

    public static ImmutableList copyOf(Iterable object) {
        Iterable iterable = object;
        iterable.getClass();
        if (iterable instanceof Collection) {
            return ImmutableList.copyOf((Collection)object);
        }
        if (!(object = object.iterator()).hasNext()) {
            return RegularImmutableList.EMPTY;
        }
        Object object2 = object;
        Object object3 = object2.next();
        if (!object2.hasNext()) {
            return new SingletonImmutableList(object3);
        }
        object3 = new ImmutableList$Builder().add(object3);
        while (object.hasNext()) {
            ((ImmutableList$Builder)object3).add(object.next());
        }
        ((ImmutableList$Builder)object3).copyOnWrite = true;
        return ImmutableList.asImmutableList(((ImmutableList$Builder)object3).contents, ((ImmutableList$Builder)object3).size);
    }

    public static ImmutableList copyOf(Collection object) {
        if (object instanceof ImmutableCollection) {
            if (((ImmutableCollection)(object = ((ImmutableCollection)object).asList())).isPartialView()) {
                Object[] objectArray = ((ImmutableCollection)object).toArray(ImmutableCollection.EMPTY_ARRAY);
                return ImmutableList.asImmutableList(objectArray, objectArray.length);
            }
            return object;
        }
        object = object.toArray();
        int n = ((Object[])object).length;
        for (int i = 0; i < n; ++i) {
            if (object[i] != null) {
                continue;
            }
            throw new NullPointerException("at index " + i);
        }
        Object object2 = object;
        return ImmutableList.asImmutableList((Object[])object2, ((Object)object2).length);
    }

    public static ImmutableList asImmutableList(Object[] objectArray, int n) {
        if (n != 0) {
            if (n != 1) {
                if (n < objectArray.length) {
                    objectArray = Arrays.copyOf(objectArray, n);
                }
                return new RegularImmutableList(objectArray);
            }
            objectArray = Objects.requireNonNull(objectArray[0]);
            return new SingletonImmutableList(objectArray);
        }
        return RegularImmutableList.EMPTY;
    }
}

