/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators$SingletonIterator;
import com.google.common.collect.RegularImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.Spliterator;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class SingletonImmutableList
extends ImmutableList {
    public final transient Object element;

    public SingletonImmutableList(Object object) {
        object.getClass();
        this.element = object;
    }

    public final Object get(int n) {
        Preconditions.checkElementIndex(n, 1);
        return this.element;
    }

    @Override
    public final UnmodifiableIterator iterator() {
        Object object = ((SingletonImmutableList)object).element;
        return new Iterators$SingletonIterator(object);
    }

    @Override
    public final Spliterator spliterator() {
        return Collections.singleton(this.element).spliterator();
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final ImmutableList subList(int n, int n2) {
        int n3 = n;
        Preconditions.checkPositionIndexes(n3, n2, 1);
        if (n3 == n2) {
            return RegularImmutableList.EMPTY;
        }
        return this;
    }

    @Override
    public final String toString() {
        return "[" + this.element.toString() + ']';
    }

    @Override
    public final boolean isPartialView() {
        return false;
    }

    @Override
    public final Iterator iterator() {
        Object object = ((SingletonImmutableList)object).element;
        return new Iterators$SingletonIterator(object);
    }
}

