/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Strings;
import com.google.common.math.IntMath;
import java.util.Arrays;

public final class BaseEncoding$Alphabet {
    public final String name;
    public final char[] chars;
    public final int bitsPerChar;
    public final int charsPerChunk;
    public final int bytesPerChunk;
    public final byte[] decodabet;

    public BaseEncoding$Alphabet(String object, char[] cArray) {
        int n = 128;
        byte[] byArray = new byte[128];
        Arrays.fill(byArray, (byte)-1);
        for (int i = 0; i < cArray.length; ++i) {
            String string = "Non-ASCII character: %s";
            int n2 = cArray[i];
            if (n2 < n) {
                string = "Duplicate character: %s";
                if (byArray[n2] == -1) {
                    byArray[n2] = (byte)i;
                    continue;
                }
                object = Character.valueOf((char)n2);
                throw new IllegalArgumentException(Strings.lenientFormat(string, object));
            }
            object = Character.valueOf((char)n2);
            throw new IllegalArgumentException(Strings.lenientFormat(string, object));
        }
        this.name = object;
        this.chars = cArray;
        int n3 = cArray.length;
        int n4 = IntMath.log2(n3);
        try {
            this.bitsPerChar = n4;
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException("Illegal alphabet length " + cArray.length, arithmeticException);
        }
        int n5 = Integer.numberOfTrailingZeros(n4);
        this.charsPerChunk = n = 1 << 3 - n5;
        this.bytesPerChunk = n4 >> n5;
        this.decodabet = byArray;
        boolean[] blArray = new boolean[n];
        for (n5 = 0; n5 < this.bytesPerChunk; ++n5) {
            blArray[IntMath.divide((int)(n5 * 8), (int)this.bitsPerChar)] = true;
        }
        return;
    }

    public final String toString() {
        return this.name;
    }

    public final boolean equals(Object object) {
        if (object instanceof BaseEncoding$Alphabet) {
            BaseEncoding$Alphabet baseEncoding$Alphabet = baseEncoding$Alphabet2;
            BaseEncoding$Alphabet baseEncoding$Alphabet2 = (BaseEncoding$Alphabet)object;
            return Arrays.equals(baseEncoding$Alphabet.chars, baseEncoding$Alphabet2.chars);
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.chars) + 1237;
    }
}

