/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.cli.Option$Builder;

public final class Option
implements Cloneable,
Serializable {
    public final int argCount;
    public final String argName;
    public final String description;
    public final String longOption;
    public final String option;
    public final Class type = String.class;
    public ArrayList values;

    public final boolean acceptsArg() {
        int n = this.argCount;
        return !(n <= 0 && n != -2 && n <= 1 && n != -2 || n > 0 && this.values.size() >= this.argCount);
        {
        }
    }

    public final Object clone() {
        try {
            ((Option)super.clone()).values = new ArrayList(this.values);
            return (Option)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new UnsupportedOperationException(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Option)) {
            return false;
        }
        object = (Option)object;
        return Objects.equals(this.longOption, ((Option)object).longOption) && Objects.equals(this.option, ((Option)object).option);
    }

    public final int hashCode() {
        Option option = string;
        String string = option.longOption;
        String string2 = option.option;
        return Objects.hash(string, string2);
    }

    public final void processValue(String string) {
        if (this.argCount != -1) {
            string = Objects.requireNonNull(string, "value");
            if (this.acceptsArg()) {
                this.values.add(string);
                return;
            }
            throw new IllegalArgumentException("Cannot add value, list full.");
        }
        throw new IllegalStateException("NO_ARGS_ALLOWED");
    }

    public final String toString() {
        int n;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2("[ Option ");
        stringBuilder.append(this.option);
        if (this.longOption != null) {
            stringBuilder2.append(' ').append(this.longOption);
        }
        if ((n = this.argCount) <= 1 && n != -2) {
            if (n > 0 || n == -2) {
                stringBuilder2.append(" [ARG]");
            }
        } else {
            stringBuilder2.append("[ARG...]");
        }
        return stringBuilder2.append(" :: ").append(this.description).append(" :: ").append(this.type).append(" ]").toString();
    }

    public Option(Option$Builder option$Builder) {
        ArrayList arrayList;
        this.argCount = -1;
        Object object = arrayList;
        arrayList = new ArrayList();
        this.values = object;
        object = option$Builder.option;
        if (object == null && option$Builder.longOption == null) {
            throw new IllegalStateException("Either opt or longOpt must be specified");
        }
        this.argName = option$Builder.argName;
        this.description = option$Builder.description;
        this.longOption = option$Builder.longOption;
        this.argCount = option$Builder.argCount;
        this.option = object;
        this.type = option$Builder.type;
    }
}

