/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.build.AbstractOrigin$InputStreamOrigin;
import org.apache.commons.io.function.IOBiConsumer;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOIntConsumer;
import org.apache.commons.io.input.BoundedInputStream$Builder;

public final class BoundedInputStream
extends FilterInputStream {
    public static final /* synthetic */ int $r8$clinit;
    public volatile boolean closed;
    public final IOIntConsumer afterRead;
    public long count;
    public long mark;
    public final long maxCount;
    public final IOBiConsumer onMaxCount;
    public final boolean propagateClose;

    public BoundedInputStream(BoundedInputStream$Builder boundedInputStream$Builder) {
        AbstractOrigin$InputStreamOrigin abstractOrigin$InputStreamOrigin = boundedInputStream$Builder.origin;
        if (abstractOrigin$InputStreamOrigin != null) {
            boundedInputStream$Builder.getOpenOptions();
            super((InputStream)abstractOrigin$InputStreamOrigin.origin);
            this.afterRead = IOIntConsumer.NOOP;
            this.count = 0L;
            this.maxCount = boundedInputStream$Builder.maxCount;
            this.propagateClose = boundedInputStream$Builder.propagateClose;
            this.onMaxCount = boundedInputStream$Builder.onMaxCount;
            return;
        }
        throw new IllegalStateException("origin == null");
    }

    public final synchronized void afterRead(int n) {
        if (n != -1) {
            this.count += (long)n;
        }
        this.afterRead.accept(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int available() {
        long l;
        long l2 = this.maxCount;
        if (l2 == -1L) {
            l = Long.MAX_VALUE;
            return Math.min(this.available$org$apache$commons$io$input$ProxyInputStream(), (int)Math.min(l, Integer.MAX_VALUE));
        }
        long l3 = l2;
        BoundedInputStream boundedInputStream = this;
        synchronized (boundedInputStream) {
            l2 = boundedInputStream.count;
        }
        l = Math.max(0L, l3 - l2);
        return Math.min(this.available$org$apache$commons$io$input$ProxyInputStream(), (int)Math.min(l, Integer.MAX_VALUE));
    }

    @Override
    public final void close() {
        if (this.propagateClose) {
            this.close$org$apache$commons$io$input$ProxyInputStream();
            return;
        }
    }

    @Override
    public final synchronized void mark(int n) {
        BoundedInputStream boundedInputStream = this;
        boundedInputStream.in.mark(n);
        boundedInputStream.mark = boundedInputStream.count;
    }

    @Override
    public final boolean markSupported() {
        return this.in.markSupported();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int read() {
        long l;
        if (!((BoundedInputStream)((Object)l3)).isMaxCount()) {
            return ((BoundedInputStream)((Object)l3)).read$org$apache$commons$io$input$ProxyInputStream();
        }
        BoundedInputStream boundedInputStream = l3;
        long l2 = boundedInputStream.maxCount;
        synchronized (boundedInputStream) {
            l = boundedInputStream.count;
        }
        Long l3 = l2;
        boundedInputStream.onMaxCount.accept(l3, l);
        return -1;
    }

    @Override
    public final int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int read(byte[] byArray, int n, int n2) {
        long l;
        if (!((BoundedInputStream)((Object)l3)).isMaxCount()) {
            BoundedInputStream boundedInputStream = l3;
            n2 = (int)boundedInputStream.toReadLen(n2);
            int n3 = boundedInputStream.in.read(byArray, n, n2);
            ((BoundedInputStream)((Object)l3)).afterRead(n3);
            return n3;
        }
        BoundedInputStream boundedInputStream = l3;
        long l2 = boundedInputStream.maxCount;
        synchronized (boundedInputStream) {
            l = boundedInputStream.count;
        }
        Long l3 = l2;
        boundedInputStream.onMaxCount.accept(l3, l);
        return -1;
    }

    @Override
    public final synchronized void reset() {
        BoundedInputStream boundedInputStream = this;
        boundedInputStream.in.reset();
        boundedInputStream.count = boundedInputStream.mark;
    }

    @Override
    public final synchronized long skip(long l) {
        BoundedInputStream boundedInputStream = this;
        l = boundedInputStream.toReadLen(l);
        l = boundedInputStream.in.skip(l);
        this.count += l;
        return l;
    }

    public final String toString() {
        return this.in.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMaxCount() {
        if (this.maxCount < 0L) return false;
        BoundedInputStream boundedInputStream = this;
        synchronized (boundedInputStream) {
            BoundedInputStream boundedInputStream2 = this;
            // ** MonitorExit[v1] (shouldn't be in output)
            if (boundedInputStream.count < boundedInputStream2.maxCount) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long toReadLen(long l) {
        long l2 = this.maxCount;
        if (l2 < 0L) {
            return l;
        }
        long l3 = l;
        BoundedInputStream boundedInputStream = this;
        synchronized (boundedInputStream) {
            l = boundedInputStream.count;
            return Math.min(l3, l2 - l);
        }
    }

    public final void handleIOException(IOException iOException) {
        throw iOException;
    }

    public final int read$org$apache$commons$io$input$ProxyInputStream() {
        int n = this.in.read();
        int n2 = n != -1 ? 1 : -1;
        this.afterRead(n2);
        return n;
    }

    public final void close$org$apache$commons$io$input$ProxyInputStream() {
        block5: {
            InputStream inputStream = this.in;
            Object object = this::handleIOException;
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    if (object != null) {
                        IOException iOException;
                        IOConsumer iOConsumer = object;
                        object = iOException;
                        iOException = new IOException(exception);
                        iOConsumer.accept(object);
                    }
                }
                catch (IOException iOException) {
                    if (object == null) break block5;
                    object.accept(iOException);
                }
            }
        }
        this.closed = true;
    }

    public final int available$org$apache$commons$io$input$ProxyInputStream() {
        if (this.in != null && !this.closed) {
            return this.in.available();
        }
        return 0;
    }
}

