/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.downloaders;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import nicelee.bilibili.PackageScanLoader;
import nicelee.bilibili.downloaders.IDownloader;
import nicelee.bilibili.enums.StatusEnum;
import nicelee.bilibili.util.HttpRequestUtil;
import nicelee.bilibili.util.Logger;

public class Downloader
implements IDownloader {
    private static List<IDownloader> downloaders = null;
    private IDownloader downloader = null;
    private HttpRequestUtil util;
    private StatusEnum status;

    @Override
    public boolean matches(String string) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(HttpRequestUtil httpRequestUtil) {
        this.status = StatusEnum.NONE;
        this.util = httpRequestUtil;
        if (downloaders != null) return;
        Class<Downloader> clazz = Downloader.class;
        synchronized (Downloader.class) {
            if (downloaders != null) return;
            downloaders = new ArrayList<IDownloader>();
            try {
                for (Class<?> clazz2 : PackageScanLoader.validDownloaderClasses) {
                    IDownloader iDownloader = (IDownloader)clazz2.newInstance();
                    downloaders.add(iDownloader);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
    }

    @Override
    public boolean download(String string, String string2, int n, int n2) {
        if (this.downloader == null) {
            for (IDownloader iDownloader : downloaders) {
                if (!iDownloader.matches(string)) continue;
                try {
                    this.downloader = (IDownloader)iDownloader.getClass().newInstance();
                    this.downloader.matches(string);
                    break;
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                }
            }
        }
        if (this.downloader != null) {
            this.status = StatusEnum.DOWNLOADING;
            this.downloader.init(this.util);
            return this.downloader.download(string, string2, n, n2);
        }
        System.out.print("\u672a\u627e\u5230\u5339\u914d\u5f53\u524durl\u7684\u4e0b\u8f7d\u5668:");
        System.out.println(string);
        this.status = StatusEnum.FAIL;
        return false;
    }

    @Override
    public void startTask() {
        if (this.downloader != null) {
            this.status = StatusEnum.DOWNLOADING;
            this.downloader.startTask();
        } else {
            Logger.println(StatusEnum.NONE.toString());
            this.status = StatusEnum.NONE;
        }
    }

    @Override
    public void stopTask() {
        if (this.downloader != null) {
            this.downloader.stopTask();
        }
        this.status = StatusEnum.STOP;
    }

    @Override
    public File file() {
        if (this.downloader != null) {
            return this.downloader.file();
        }
        return null;
    }

    @Override
    public StatusEnum currentStatus() {
        if (this.downloader != null) {
            return this.downloader.currentStatus();
        }
        return this.status;
    }

    @Override
    public int totalTaskCount() {
        if (this.downloader != null) {
            return this.downloader.totalTaskCount();
        }
        return 0;
    }

    @Override
    public int currentTask() {
        if (this.downloader != null) {
            return this.downloader.currentTask();
        }
        return 0;
    }

    @Override
    public long sumTotalFileSize() {
        if (this.downloader != null) {
            return this.downloader.sumTotalFileSize();
        }
        return 0L;
    }

    @Override
    public long sumDownloadedFileSize() {
        if (this.downloader != null) {
            return this.downloader.sumDownloadedFileSize();
        }
        return 0L;
    }

    @Override
    public long currentFileDownloadedSize() {
        if (this.downloader != null) {
            return this.downloader.currentFileDownloadedSize();
        }
        return 0L;
    }

    @Override
    public long currentFileTotalSize() {
        if (this.downloader != null) {
            return this.downloader.currentFileTotalSize();
        }
        return 0L;
    }
}

