/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.downloaders;

import java.io.File;
import nicelee.bilibili.enums.StatusEnum;
import nicelee.bilibili.util.HttpRequestUtil;

public interface IDownloader {
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;

    public boolean matches(String var1);

    public void init(HttpRequestUtil var1);

    public boolean download(String var1, String var2, int var3, int var4);

    public void startTask();

    public void stopTask();

    public File file();

    public StatusEnum currentStatus();

    public int totalTaskCount();

    public int currentTask();

    public long sumTotalFileSize();

    public long sumDownloadedFileSize();

    public long currentFileDownloadedSize();

    public long currentFileTotalSize();

    public static String transToSizeStr(long l) {
        if (l == 0L) {
            return "\u672a\u77e5";
        }
        if (l >= 0x40000000L) {
            double d = (double)l * 1.0 / 1.073741824E9;
            return String.format("%.2f GB", d);
        }
        if (l >= 0x100000L) {
            double d = (double)l * 1.0 / 1048576.0;
            return String.format("%.2f MB", d);
        }
        if (l >= 1024L) {
            double d = (double)l * 1.0 / 1024.0;
            return String.format("%.2f KB", d);
        }
        return l + " Byte";
    }
}

