/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractBaseParser;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SSParser
extends AbstractBaseParser {
    private static final Pattern pattern = Pattern.compile("(?!/cheese/play/ss[0-9]+)ss[0-9]+");
    private String ssId;

    public SSParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        boolean bl = this.matcher.find();
        if (bl) {
            this.ssId = this.matcher.group();
            System.out.println("\u5339\u914dSSParser: " + this.ssId);
        }
        return bl;
    }

    @Override
    public String validStr(String string) {
        return this.ssId;
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        System.out.println("SSParser\u6b63\u5728\u83b7\u53d6\u7ed3\u679c" + this.ssId);
        return this.getSSDetail(this.ssId, n, bl);
    }

    protected VideoInfo getSSDetail(String string, int n, boolean bl) {
        VideoInfo videoInfo = new VideoInfo();
        videoInfo.setVideoId(string);
        String string2 = string.replace("ss", "");
        HttpHeaders httpHeaders = new HttpHeaders();
        String string3 = "https://api.bilibili.com/pgc/view/web/season?season_id=" + string2;
        String string4 = this.util.getContent(string3, httpHeaders.getCommonHeaders("www.bilibili.com"));
        Logger.println(string3);
        Logger.println(string4);
        JSONObject jSONObject = new JSONObject(string4).getJSONObject("result");
        videoInfo.setVideoName(jSONObject.getString("title"));
        videoInfo.setBrief(jSONObject.getString("evaluate"));
        videoInfo.setAuthor("\u756a\u5267");
        videoInfo.setAuthorId("\u756a\u5267");
        videoInfo.setVideoPreview(jSONObject.getString("cover"));
        JSONArray jSONArray = jSONObject.getJSONArray("episodes");
        LinkedHashMap<Long, ClipInfo> linkedHashMap = new LinkedHashMap<Long, ClipInfo>();
        ClipInfo clipInfo = null;
        int[] nArray = null;
        if (jSONArray.length() > 20) {
            nArray = new int[]{120, 116, 112, 80, 74, 64, 32, 16};
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            ClipInfo clipInfo2 = new ClipInfo();
            clipInfo2.setAvTitle(videoInfo.getVideoName());
            clipInfo2.setAvId(jSONObject2.getString("bvid"));
            clipInfo2.setcId(jSONObject2.getLong("cid"));
            clipInfo2.setRemark(i + 1);
            clipInfo2.setPicPreview(jSONObject2.getString("cover"));
            if (i > 0 && jSONArray.getJSONObject(i - 1).getString("bvid").equals(jSONObject2.getString("bvid"))) {
                clipInfo2.setPage(clipInfo.getPage() + 1);
            } else {
                clipInfo2.setPage(1);
            }
            clipInfo2.setTitle(jSONObject2.getString("long_title"));
            clipInfo2.setUpName(videoInfo.getVideoName());
            clipInfo2.setUpId(string);
            LinkedHashMap<Integer, String> linkedHashMap2 = new LinkedHashMap<Integer, String>();
            try {
                int[] nArray2;
                for (int n2 : nArray2 = nArray != null ? nArray : this.getVideoQNList(clipInfo2.getAvId(), String.valueOf(clipInfo2.getcId()))) {
                    if (bl) {
                        String string5 = this.getVideoLink(clipInfo2.getAvId(), String.valueOf(clipInfo2.getcId()), n2, n);
                        linkedHashMap2.put(n2, string5);
                        continue;
                    }
                    linkedHashMap2.put(n2, "");
                }
                clipInfo2.setLinks(linkedHashMap2);
            }
            catch (Exception exception) {
                clipInfo2.setLinks(linkedHashMap2);
            }
            clipInfo = clipInfo2;
            linkedHashMap.put(clipInfo2.getcId(), clipInfo2);
        }
        videoInfo.setClips(linkedHashMap);
        videoInfo.print();
        return videoInfo;
    }
}

