/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractPageQueryParser;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class URL4ChannelCollectionParser
extends AbstractPageQueryParser<VideoInfo> {
    private static final Pattern pattern = Pattern.compile("space\\.bilibili\\.com/([0-9]+)/channel/collectiondetail\\?sid=([0-9]+)");
    private String spaceID;
    private String sid;

    public URL4ChannelCollectionParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        if (this.matcher.find()) {
            System.out.println("UP \u67d0\u5408\u96c6\u7684\u89c6\u9891\u89e3\u6790 ...");
            this.spaceID = this.matcher.group(1);
            this.sid = this.matcher.group(2);
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return this.matcher.group().trim() + "p=" + this.paramSetter.getPage();
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        return (VideoInfo)this.result(this.pageSize, this.paramSetter.getPage(), n, bl);
    }

    @Override
    public void initPageQueryParam() {
        this.API_PMAX = 20;
        this.pageQueryResult = new VideoInfo();
        ((VideoInfo)this.pageQueryResult).setClips(new LinkedHashMap<Long, ClipInfo>());
    }

    @Override
    protected boolean query(int n, int n2, int n3, Object ... objectArray) {
        int n4 = (Integer)objectArray[0];
        boolean bl = (Boolean)objectArray[1];
        try {
            String string = "https://api.bilibili.com/x/polymer/space/seasons_archives_list?mid=%s&season_id=%s&sort_reverse=false&page_num=%d&page_size=%d";
            String string2 = String.format(string, this.spaceID, this.sid, n, this.API_PMAX);
            String string3 = this.util.getContent(string2, new HttpHeaders().getCommonHeaders("api.bilibili.com"));
            Logger.println(string2);
            JSONObject jSONObject = new JSONObject(string3).getJSONObject("data");
            JSONObject jSONObject2 = jSONObject.getJSONObject("meta");
            JSONArray jSONArray = jSONObject.getJSONArray("archives");
            if (((VideoInfo)this.pageQueryResult).getVideoName() == null) {
                ((VideoInfo)this.pageQueryResult).setVideoId(this.spaceID + " - " + this.sid);
                ((VideoInfo)this.pageQueryResult).setVideoName(jSONObject2.getString("name") + n);
                ((VideoInfo)this.pageQueryResult).setBrief(jSONObject2.getString("description"));
                ((VideoInfo)this.pageQueryResult).setAuthorId(this.spaceID);
                ((VideoInfo)this.pageQueryResult).setVideoPreview(jSONObject2.getString("cover"));
            }
            LinkedHashMap<Long, ClipInfo> linkedHashMap = ((VideoInfo)this.pageQueryResult).getClips();
            for (int i = n2 - 1; i < jSONArray.length() && i < n3; ++i) {
                JSONObject jSONObject3 = jSONArray.getJSONObject(i);
                try {
                    LinkedHashMap<Long, ClipInfo> linkedHashMap2 = this.convertVideoToClipMap(jSONObject3.getString("bvid"), (n - 1) * this.API_PMAX + i + 1, n4, bl);
                    for (ClipInfo clipInfo : linkedHashMap2.values()) {
                        clipInfo.setListName(jSONObject2.getString("name").replaceAll("[/\\\\]", "_"));
                        clipInfo.setListOwnerName(((VideoInfo)this.pageQueryResult).getAuthor().replaceAll("[/\\\\]", "_"));
                        clipInfo.setListOwnerId(((VideoInfo)this.pageQueryResult).getAuthorId());
                    }
                    linkedHashMap.putAll(linkedHashMap2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private LinkedHashMap<Long, ClipInfo> convertVideoToClipMap(String string, int n, int n2, boolean bl) {
        LinkedHashMap<Long, ClipInfo> linkedHashMap = new LinkedHashMap<Long, ClipInfo>();
        VideoInfo videoInfo = this.getAVDetail(string, n2, bl);
        if (((VideoInfo)this.pageQueryResult).getAuthor() == null) {
            ((VideoInfo)this.pageQueryResult).setAuthor(videoInfo.getAuthor());
        }
        for (ClipInfo clipInfo : videoInfo.getClips().values()) {
            clipInfo.setRemark(n);
            linkedHashMap.put(clipInfo.getcId(), clipInfo);
        }
        return linkedHashMap;
    }
}

