/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.enums.VideoQualityEnum;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractPageQueryParser;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="URL4ChannelCollectionParserEx", weight=77, ifLoad="listAll", note="UP \u67d0\u5408\u96c6\u7684\u89c6\u9891\u89e3\u6790")
public class URL4ChannelCollectionParserEx
extends AbstractPageQueryParser<VideoInfo> {
    private static final Pattern pattern = Pattern.compile("space\\.bilibili\\.com/[0-9]+/channel/collectiondetail\\?sid=([0-9]+)");
    private static final Pattern pattern2 = Pattern.compile("space\\.bilibili\\.com/[0-9]+/favlist\\?.*fid=([0-9]+).*ftype=collect");
    private static final Pattern pattern3 = Pattern.compile("space\\.bilibili\\.com/[0-9]+/lists/([0-9]+)\\?type=season");
    private String sid;

    public URL4ChannelCollectionParserEx(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        if (this.matcher.find()) {
            System.out.println("UP \u67d0\u5408\u96c6\u7684\u89c6\u9891\u89e3\u6790(\u722chtml\u7248) ...pattern");
            this.sid = this.matcher.group(1);
            return true;
        }
        this.matcher = pattern2.matcher(string);
        if (this.matcher.find()) {
            System.out.println("UP \u67d0\u5408\u96c6\u7684\u89c6\u9891\u89e3\u6790(\u722chtml\u7248) ...pattern2");
            this.sid = this.matcher.group(1);
            return true;
        }
        this.matcher = pattern3.matcher(string);
        if (this.matcher.find()) {
            System.out.println("UP \u67d0\u5408\u96c6\u7684\u89c6\u9891\u89e3\u6790(\u722chtml\u7248) ...pattern3");
            this.sid = this.matcher.group(1);
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return this.matcher.group().trim() + "p=" + this.paramSetter.getPage();
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        return (VideoInfo)this.result(this.pageSize, this.paramSetter.getPage(), n, bl);
    }

    @Override
    public void initPageQueryParam() {
        this.API_PMAX = 9999;
        this.pageQueryResult = new VideoInfo();
        ((VideoInfo)this.pageQueryResult).setClips(new LinkedHashMap<Long, ClipInfo>());
    }

    @Override
    protected boolean query(int n, int n2, int n3, Object ... objectArray) {
        int n4 = (Integer)objectArray[0];
        boolean bl = (Boolean)objectArray[1];
        try {
            String string = "https://api.bilibili.com/x/polymer/web-space/seasons_archives_list?mid=%s&season_id=%s&sort_reverse=false&page_num=%d&page_size=%d";
            String string2 = String.format(string, "1234567", this.sid, 1, 1);
            String string3 = this.util.getContent(string2, new HttpHeaders().getCommonHeaders("api.bilibili.com"), HttpCookies.globalCookiesWithFingerprint());
            Logger.println(string2);
            Logger.println(string3);
            JSONObject jSONObject = new JSONObject(string3).getJSONObject("data");
            JSONObject jSONObject2 = jSONObject.getJSONObject("meta");
            String string4 = jSONObject.getJSONArray("archives").getJSONObject(0).getString("bvid");
            String string5 = "https://www.bilibili.com/video/" + string4;
            String string6 = this.util.getContent(string5, new HttpHeaders().getCommonHeaders("www.bilibili.com"), HttpCookies.globalCookiesWithFingerprint());
            int n5 = string6.indexOf("window.__INITIAL_STATE__=");
            int n6 = string6.indexOf(";(function()", n5);
            String string7 = string6.substring(n5 + 25, n6);
            JSONObject jSONObject3 = new JSONObject(string7);
            JSONObject jSONObject4 = jSONObject3.getJSONObject("upData");
            if (((VideoInfo)this.pageQueryResult).getVideoName() == null) {
                ((VideoInfo)this.pageQueryResult).setVideoId("sid - " + this.sid);
                ((VideoInfo)this.pageQueryResult).setVideoName(jSONObject2.getString("name") + n);
                ((VideoInfo)this.pageQueryResult).setBrief(jSONObject2.getString("description"));
                ((VideoInfo)this.pageQueryResult).setAuthorId(jSONObject4.optString("mid"));
                ((VideoInfo)this.pageQueryResult).setAuthor(jSONObject4.optString("name"));
                ((VideoInfo)this.pageQueryResult).setVideoPreview(jSONObject2.getString("cover"));
            }
            LinkedHashMap<Long, ClipInfo> linkedHashMap = ((VideoInfo)this.pageQueryResult).getClips();
            JSONArray jSONArray = jSONObject3.optJSONArray("sections");
            if (jSONArray == null) {
                jSONArray = jSONObject3.getJSONObject("sectionsInfo").getJSONArray("sections");
            }
            boolean bl2 = false;
            int n7 = 0;
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONArray jSONArray2 = jSONArray.getJSONObject(i).getJSONArray("episodes");
                for (int j = 0; j < jSONArray2.length(); ++j) {
                    if (n7 + 1 < n2) {
                        ++n7;
                        continue;
                    }
                    if (n7 + 1 > n3) {
                        bl2 = true;
                        break;
                    }
                    JSONObject jSONObject5 = jSONArray2.getJSONObject(j);
                    JSONObject jSONObject6 = jSONObject5.getJSONObject("page");
                    JSONObject jSONObject7 = jSONObject5.getJSONObject("arc");
                    ClipInfo clipInfo = new ClipInfo();
                    clipInfo.setAvId(jSONObject5.getString("bvid"));
                    clipInfo.setcId(jSONObject5.optLong("cid"));
                    clipInfo.setPage(jSONObject6.getInt("page"));
                    clipInfo.setRemark(n7 + 1);
                    clipInfo.setPicPreview(jSONObject7.getString("pic"));
                    clipInfo.setListName(jSONObject2.getString("name").replaceAll("[/\\\\]", "_"));
                    clipInfo.setListOwnerName(((VideoInfo)this.pageQueryResult).getAuthor().replaceAll("[/\\\\]", "_"));
                    clipInfo.setListOwnerId(((VideoInfo)this.pageQueryResult).getAuthorId());
                    clipInfo.setUpName(((VideoInfo)this.pageQueryResult).getAuthor());
                    clipInfo.setUpId(((VideoInfo)this.pageQueryResult).getAuthorId());
                    clipInfo.setAvTitle(jSONObject5.getString("title"));
                    clipInfo.setTitle(jSONObject6.getString("part"));
                    clipInfo.setcTime(jSONObject7.optLong("ctime") * 1000L);
                    LinkedHashMap<Integer, String> linkedHashMap2 = new LinkedHashMap<Integer, String>();
                    try {
                        for (VideoQualityEnum videoQualityEnum : VideoQualityEnum.values()) {
                            if (bl) {
                                String string8 = this.getVideoLink(clipInfo.getAvId(), String.valueOf(clipInfo.getcId()), videoQualityEnum.getQn(), n4);
                                linkedHashMap2.put(videoQualityEnum.getQn(), string8);
                                continue;
                            }
                            linkedHashMap2.put(videoQualityEnum.getQn(), "");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    clipInfo.setLinks(linkedHashMap2);
                    linkedHashMap.put(clipInfo.getcId(), clipInfo);
                    ++n7;
                }
                if (bl2) break;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }
}

