/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.enums.VideoQualityEnum;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractPageQueryParser;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="URL4ChannelSeriesMedialistParser", weight=78, ifLoad="listAll", note="UP \u67d0\u89c6\u9891\u5217\u8868\u7684\u89c6\u9891\u89e3\u6790")
public class URL4ChannelSeriesMedialistParser
extends AbstractPageQueryParser<VideoInfo> {
    private static final Pattern[] patterns = new Pattern[]{Pattern.compile("www\\.bilibili\\.com/medialist/play/([0-9]+)\\?.*&business_id=([0-9]+)"), Pattern.compile("space\\.bilibili\\.com/([0-9]+)/channel/seriesdetail\\?sid=([0-9]+)"), Pattern.compile("space\\.bilibili\\.com/([0-9]+)/lists/([0-9]+)\\?type=series"), Pattern.compile("www\\.bilibili\\.com/list/([0-9]+)/\\?sid=([0-9]+)")};
    private String spaceID;
    private String sid;
    private String seriesName;

    public URL4ChannelSeriesMedialistParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        for (Pattern pattern : patterns) {
            this.matcher = pattern.matcher(string);
            if (!this.matcher.find()) continue;
            System.out.println("\u5339\u914dUP\u4e3b\u5408\u96c6\u548c\u89c6\u9891\u5217\u8868 ...");
            this.spaceID = this.matcher.group(1);
            this.sid = this.matcher.group(2);
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return this.matcher.group().trim() + "&p=" + this.paramSetter.getPage();
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        return (VideoInfo)this.result(this.pageSize, this.paramSetter.getPage(), n, bl);
    }

    @Override
    public void initPageQueryParam() {
        this.API_PMAX = 20;
        this.pageQueryResult = new VideoInfo();
        ((VideoInfo)this.pageQueryResult).setClips(new LinkedHashMap<Long, ClipInfo>());
    }

    @Override
    protected boolean query(int n, int n2, int n3, Object ... objectArray) {
        int n4 = (Integer)objectArray[0];
        boolean bl = (Boolean)objectArray[1];
        try {
            Object object;
            String string;
            Object object2;
            String string2;
            String string3;
            HashMap<String, String> hashMap = new HttpHeaders().getCommonHeaders("api.bilibili.com");
            if (((VideoInfo)this.pageQueryResult).getVideoName() == null) {
                string3 = "https://api.bilibili.com/x/v1/medialist/info?type=5&tid=0&biz_id=" + this.sid;
                Logger.println(string3);
                string2 = this.util.getContent(string3, hashMap);
                object2 = new JSONObject(string2).getJSONObject("data");
                this.seriesName = ((JSONObject)object2).getString("title");
                ((VideoInfo)this.pageQueryResult).setVideoId(this.spaceID + " - " + this.sid);
                ((VideoInfo)this.pageQueryResult).setVideoName(this.seriesName + this.paramSetter.getPage());
                ((VideoInfo)this.pageQueryResult).setBrief(((JSONObject)object2).getString("intro"));
                ((VideoInfo)this.pageQueryResult).setAuthorId(this.spaceID);
                ((VideoInfo)this.pageQueryResult).setAuthor(((JSONObject)object2).getJSONObject("upper").getString("name"));
            }
            string3 = "";
            if (n > 1) {
                int n5 = (n - 1) * this.API_PMAX + 1;
                object2 = "https://api.bilibili.com/x/series/archives?mid=%s&series_id=%s&only_normal=true&sort=desc&pn=%d&ps=%d";
                string = String.format((String)object2, this.spaceID, this.sid, n, this.API_PMAX);
                Logger.println(string);
                object = this.util.getContent(string, hashMap);
                string3 = new JSONObject((String)object).getJSONObject("data").getJSONArray("archives").getJSONObject(0).optString("aid");
                Logger.printf("page: %d, lastPageNumber: %d, oid: %s\n", n, n5, string3);
            }
            string2 = "https://api.bilibili.com/x/v2/medialist/resource/list?type=5&oid=%s&otype=2&biz_id=%s&with_current=true&mobi_app=web&ps=%s&direction=false&sort_field=1&tid=0&desc=true";
            object2 = String.format(string2, string3, this.sid, this.API_PMAX);
            Logger.println((String)object2);
            string = this.util.getContent((String)object2, hashMap);
            object = new JSONObject(string);
            JSONArray jSONArray = ((JSONObject)object).getJSONObject("data").getJSONArray("media_list");
            if (((VideoInfo)this.pageQueryResult).getVideoPreview() == null) {
                ((VideoInfo)this.pageQueryResult).setVideoPreview(jSONArray.getJSONObject(0).getString("cover"));
            }
            LinkedHashMap<Long, ClipInfo> linkedHashMap = ((VideoInfo)this.pageQueryResult).getClips();
            for (int i = n2 - 1; i < jSONArray.length() && i < n3; ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                String string4 = jSONObject.getString("bv_id");
                String string5 = jSONObject.getString("title");
                String string6 = jSONObject.getJSONObject("upper").getString("name");
                String string7 = jSONObject.getJSONObject("upper").optString("mid");
                long l = jSONObject.optLong("pubtime") * 1000L;
                JSONArray jSONArray2 = jSONObject.optJSONArray("pages");
                if (jSONArray2 == null) continue;
                for (int j = 0; j < jSONArray2.length(); ++j) {
                    JSONObject jSONObject2 = jSONArray2.getJSONObject(j);
                    ClipInfo clipInfo = new ClipInfo();
                    clipInfo.setAvId(string4);
                    clipInfo.setcId(jSONObject2.getLong("id"));
                    clipInfo.setPage(jSONObject2.getInt("page"));
                    clipInfo.setRemark((n - 1) * this.API_PMAX + i + 1);
                    clipInfo.setPicPreview(jSONObject.getString("cover"));
                    clipInfo.setListName(this.seriesName.replaceAll("[/\\\\]", "_"));
                    clipInfo.setListOwnerName(((VideoInfo)this.pageQueryResult).getAuthor().replaceAll("[/\\\\]", "_"));
                    clipInfo.setListOwnerId(((VideoInfo)this.pageQueryResult).getAuthorId());
                    clipInfo.setUpName(string6);
                    clipInfo.setUpId(string7);
                    clipInfo.setAvTitle(string5);
                    clipInfo.setTitle(jSONObject2.getString("title"));
                    clipInfo.setcTime(l);
                    LinkedHashMap<Integer, String> linkedHashMap2 = new LinkedHashMap<Integer, String>();
                    try {
                        for (VideoQualityEnum videoQualityEnum : VideoQualityEnum.values()) {
                            if (bl) {
                                String string8 = this.getVideoLink(string4, String.valueOf(clipInfo.getcId()), videoQualityEnum.getQn(), n4);
                                linkedHashMap2.put(videoQualityEnum.getQn(), string8);
                                continue;
                            }
                            linkedHashMap2.put(videoQualityEnum.getQn(), "");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    clipInfo.setLinks(linkedHashMap2);
                    linkedHashMap.put(clipInfo.getcId(), clipInfo);
                }
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }
}

