/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractPageQueryParser;
import nicelee.bilibili.parsers.impl.URL4PictureOpusParser;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="URL4PictureFavParser", note="\u4e2a\u4eba\u6536\u85cf\u7684\u56fe\u6587")
public class URL4PictureFavParser
extends AbstractPageQueryParser<VideoInfo> {
    private static final Pattern pattern = Pattern.compile("space\\.bilibili\\.com/([0-9]+)/favlist\\?fid=(albumfav|opus)");
    private String spaceID;
    private final Object[] obj;
    private static SimpleDateFormat sdf = null;

    public URL4PictureFavParser(Object ... objectArray) {
        super(objectArray);
        this.obj = objectArray;
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        if (this.matcher.find()) {
            Logger.println("\u5339\u914d\u4e2a\u4eba\u6536\u85cf\u7684\u56fe\u6587");
            this.spaceID = this.matcher.group(1);
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return this.matcher.group().trim() + "p=" + this.paramSetter.getPage();
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        return (VideoInfo)this.result(this.pageSize, this.paramSetter.getPage(), n, bl);
    }

    @Override
    public void initPageQueryParam() {
        this.API_PMAX = 10;
        this.pageQueryResult = new VideoInfo();
        ((VideoInfo)this.pageQueryResult).setClips(new LinkedHashMap<Long, ClipInfo>());
    }

    @Override
    protected boolean query(int n, int n2, int n3, Object ... objectArray) {
        try {
            String string = "https://api.bilibili.com/x/polymer/web-dynamic/v1/opus/favlist?page=%d&page_size=%d&timezone_offset=-480";
            String string2 = String.format(string, n, this.API_PMAX);
            HashMap<String, String> hashMap = new HttpHeaders().getCommonHeaders();
            String string3 = this.util.getContent(string2, hashMap, HttpCookies.globalCookiesWithFingerprint());
            Logger.println(string2);
            Logger.println(string3);
            JSONObject jSONObject = new JSONObject(string3);
            JSONArray jSONArray = jSONObject.getJSONObject("data").getJSONArray("items");
            if (((VideoInfo)this.pageQueryResult).getVideoName() == null) {
                ((VideoInfo)this.pageQueryResult).setVideoId(this.spaceID);
                ((VideoInfo)this.pageQueryResult).setAuthor("\u6211");
                ((VideoInfo)this.pageQueryResult).setVideoName("\u6211\u7684\u6536\u85cf\u56fe\u6587" + this.paramSetter.getPage());
                ((VideoInfo)this.pageQueryResult).setAuthorId(this.spaceID);
                ((VideoInfo)this.pageQueryResult).setBrief("\u6536\u85cf\u56fe\u6587\u5217\u8868 - " + this.paramSetter.getPage());
            }
            if (jSONArray.length() == 0) {
                return false;
            }
            if (sdf == null) {
                sdf = new SimpleDateFormat("\u6536\u85cf\u4e8eyyyy\u5e74MM\u6708dd\u65e5");
            }
            LinkedHashMap<Long, ClipInfo> linkedHashMap = ((VideoInfo)this.pageQueryResult).getClips();
            URL4PictureOpusParser uRL4PictureOpusParser = new URL4PictureOpusParser(this.obj);
            for (int i = n2 - 1; i < jSONArray.length() && i < n3; ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                if (jSONObject2.optBoolean("is_expired")) continue;
                String string4 = jSONObject2.getString("opus_id");
                String string5 = jSONObject2.getString("time_text");
                long l = sdf.parse(string5).getTime();
                VideoInfo videoInfo = uRL4PictureOpusParser.getOpusDetail(string4);
                for (ClipInfo clipInfo : videoInfo.getClips().values()) {
                    if (((VideoInfo)this.pageQueryResult).getVideoPreview() == null) {
                        ((VideoInfo)this.pageQueryResult).setVideoPreview(clipInfo.getPicPreview());
                    }
                    if (clipInfo.getListName() == null) {
                        clipInfo.setListName("\u6211\u7684\u6536\u85cf\u56fe\u6587");
                        clipInfo.setListOwnerName("\u6211");
                        clipInfo.setListOwnerId(((VideoInfo)this.pageQueryResult).getAuthorId());
                    }
                    clipInfo.setFavTime(l);
                    clipInfo.setRemark(i);
                    String string6 = string4 + clipInfo.getPage();
                    string6 = string6.substring(2);
                    linkedHashMap.put(Long.parseLong(string6), clipInfo);
                }
                Thread.sleep(100L);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }
}

