/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.URL4PictureCVParser;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="URL4PictureOpusParser", note="\u56fe\u7247\u89e3\u6790 - \u56fe\u6587\u52a8\u6001")
public class URL4PictureOpusParser
extends URL4PictureCVParser {
    private static final Pattern opPattern = Pattern.compile("\\.bilibili\\.com/opus/([0-9]+)");
    private static final Pattern tPattern = Pattern.compile("t\\.bilibili\\.com/([0-9]+)");
    private String opusIdNumber;

    public URL4PictureOpusParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = opPattern.matcher(string);
        if (this.matcher.find()) {
            this.opusIdNumber = this.matcher.group(1);
            Logger.println("\u5339\u914dURL4PictureOpusParser: opus" + this.opusIdNumber);
            return true;
        }
        this.matcher = tPattern.matcher(string);
        if (this.matcher.find()) {
            this.opusIdNumber = this.matcher.group(1);
            Logger.println("\u5339\u914dURL4PictureOpusParser: opus" + this.opusIdNumber);
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return string;
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        return this.getOpusDetail(this.opusIdNumber);
    }

    protected VideoInfo getOpusDetail(String string) {
        String string2;
        Object object;
        Object object2;
        int n;
        Object object3;
        Logger.println("URL4PictureOpusParser\u6b63\u5728\u83b7\u53d6\u7ed3\u679c: opus" + string);
        String string3 = "opus" + string;
        String string4 = "https://www.bilibili.com/opus/" + string;
        String string5 = this.util.getContent(string4, headers, HttpCookies.globalCookiesWithFingerprint());
        int n2 = string5.indexOf("window.__INITIAL_STATE__=");
        int n3 = string5.indexOf(";(function()", n2);
        String string6 = string5.substring(n2 + 25, n3);
        Logger.println(string6);
        JSONObject jSONObject = new JSONObject(string6);
        String string7 = jSONObject.optString("cvid");
        if (string7 != null && !string7.isEmpty()) {
            return this.getCVDetail(string7);
        }
        JSONObject jSONObject2 = (jSONObject = jSONObject.getJSONObject("detail")).getJSONObject("basic");
        int n4 = jSONObject2.optInt("comment_type");
        if (n4 == 12) {
            string7 = jSONObject2.optString("comment_id_str");
            return this.getCVDetail(string7);
        }
        VideoInfo videoInfo = new VideoInfo();
        JSONArray jSONArray = null;
        JSONArray jSONArray2 = null;
        JSONArray jSONArray3 = jSONObject.getJSONArray("modules");
        JSONObject jSONObject3 = null;
        for (int i = 0; i < jSONArray3.length(); ++i) {
            object3 = jSONArray3.getJSONObject(i);
            String string8 = ((JSONObject)object3).getString("module_type");
            if (string8.equals("MODULE_TYPE_AUTHOR")) {
                jSONObject3 = ((JSONObject)object3).getJSONObject("module_author");
            } else if (string8.equals("MODULE_TYPE_CONTENT")) {
                jSONArray = ((JSONObject)object3).getJSONObject("module_content").getJSONArray("paragraphs");
            } else if (string8.equals("MODULE_TYPE_TOP")) {
                jSONArray2 = ((JSONObject)object3).getJSONObject("module_top").getJSONObject("display").getJSONObject("album").getJSONArray("pics");
            } else if (string8.equals("MODULE_TYPE_TITLE")) {
                videoInfo.setVideoName(((JSONObject)object3).getJSONObject("module_title").getString("text"));
            }
            if (jSONObject3 != null && jSONArray != null && jSONArray2 != null && videoInfo.getVideoName() != null) break;
        }
        String string9 = jSONObject3.getString("name");
        object3 = jSONObject3.optString("mid");
        long l = jSONObject3.optLong("pub_ts") * 1000L;
        videoInfo.setVideoId(string3);
        videoInfo.setAuthor(string9);
        videoInfo.setAuthorId((String)object3);
        block1: for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject4 = jSONArray.getJSONObject(i);
            n = jSONObject4.optInt("para_type");
            if (n != 1) continue;
            object2 = jSONObject4.getJSONObject("text").getJSONArray("nodes");
            for (int j = 0; j < ((JSONArray)object2).length(); ++j) {
                object = ((JSONArray)object2).getJSONObject(j);
                if (!"TEXT_NODE_TYPE_WORD".equals(((JSONObject)object).getString("type"))) continue;
                String string10 = ((JSONObject)object).getJSONObject("word").getString("words");
                videoInfo.setBrief(string10);
                if (videoInfo.getVideoName() != null) continue block1;
                string2 = string10;
                if (string2.length() > 15) {
                    string2 = string2.substring(0, 15);
                }
                videoInfo.setVideoName(string2);
                continue block1;
            }
        }
        if (videoInfo.getVideoName() == null) {
            videoInfo.setVideoName("\u7a7a");
        }
        LinkedHashMap<Long, ClipInfo> linkedHashMap = new LinkedHashMap<Long, ClipInfo>();
        int n5 = 0;
        if (jSONArray2 != null) {
            for (n = 0; n < jSONArray2.length(); ++n) {
                object2 = jSONArray2.getJSONObject(n).getString("url");
                ClipInfo clipInfo = this.newCommonClip(string3, videoInfo, string9, (String)object3, l, null, null);
                this.setPicOfClip(clipInfo, linkedHashMap, n5, (String)object2);
                if (videoInfo.getVideoPreview() == null) {
                    videoInfo.setVideoPreview((String)object2);
                }
                ++n5;
            }
        }
        for (n = 0; n < jSONArray.length(); ++n) {
            object2 = jSONArray.getJSONObject(n);
            int n6 = ((JSONObject)object2).optInt("para_type");
            if (n6 != 2) continue;
            object = ((JSONObject)object2).getJSONObject("pic").getJSONArray("pics");
            for (int i = 0; i < ((JSONArray)object).length(); ++i) {
                string2 = ((JSONArray)object).getJSONObject(i).getString("url");
                ClipInfo clipInfo = this.newCommonClip(string3, videoInfo, string9, (String)object3, l, null, null);
                this.setPicOfClip(clipInfo, linkedHashMap, n5, string2);
                if (videoInfo.getVideoPreview() == null) {
                    videoInfo.setVideoPreview(string2);
                }
                ++n5;
            }
        }
        videoInfo.setClips(linkedHashMap);
        return videoInfo;
    }
}

