/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JWindow;

public class FrameWaiting
extends JWindow
implements Runnable,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -5501092942908580975L;
    int maxWidth = 50;
    int width = 0;
    boolean beBigger = true;
    Thread thDisplay;
    Point pressedPoint = null;
    long lastTimeClicked = 0L;

    public FrameWaiting() {
        this.init();
        this.setVisible(true);
        this.thDisplay = new Thread((Runnable)this, "Thread-Waiting-for-Main");
    }

    public void init() {
        this.setSize(this.maxWidth, this.maxWidth);
        this.setLocationRelativeTo(null);
        this.getContentPane().setBackground(Color.BLACK);
        this.setAlwaysOnTop(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.WHITE);
        graphics.fillRect((this.maxWidth - this.width) / 2, (this.maxWidth - this.width) / 2, this.width, this.width);
    }

    public void start() {
        this.thDisplay.start();
    }

    public void stop() {
        try {
            this.thDisplay.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void animate() {
        try {
            while (true) {
                if (this.beBigger) {
                    if (this.width > this.maxWidth) {
                        this.beBigger = false;
                        continue;
                    }
                    this.repaint();
                    this.width += 4;
                } else {
                    if (this.width < 0) {
                        this.beBigger = true;
                        continue;
                    }
                    this.repaint();
                    this.width -= 4;
                }
                Thread.sleep(150L);
            }
        }
        catch (InterruptedException interruptedException) {
            this.dispose();
            return;
        }
    }

    public static void main(String[] stringArray) {
        FrameWaiting frameWaiting = new FrameWaiting();
        frameWaiting.start();
    }

    @Override
    public void run() {
        this.animate();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.pressedPoint != null) {
            Point point = this.getLocation();
            Point point2 = mouseEvent.getPoint();
            int n = point.x + point2.x - this.pressedPoint.x;
            int n2 = point.y + point2.y - this.pressedPoint.y;
            this.setLocation(n, n2);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        long l = System.currentTimeMillis();
        if (l - this.lastTimeClicked < 500L) {
            this.dispose();
        }
        this.lastTimeClicked = l;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.pressedPoint = mouseEvent.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.pressedPoint = null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

