/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import nicelee.bilibili.util.Logger;
import nicelee.ui.FrameMain;
import nicelee.ui.Global;
import nicelee.ui.item.JOptionPane;

public class SysTray {
    private Image systemTrayImg;
    private final JFrame frame;
    private SystemTray systemTray;
    private TrayIcon trayIcon;
    private static SysTray mSysTray;

    private SysTray(JFrame jFrame, Image image) {
        this.frame = jFrame;
        this.systemTrayImg = image;
    }

    public static boolean shoudSysTrayEnabled() {
        return Global.isSysTrayEnabled && SystemTray.isSupported();
    }

    public static boolean isSysTrayInitiated() {
        return mSysTray != null;
    }

    public static void buildSysTray(JFrame jFrame, Image image) {
        if (mSysTray == null) {
            mSysTray = new SysTray(jFrame, image).build();
        }
    }

    private SysTray build() {
        if (!SysTray.shoudSysTrayEnabled()) {
            Logger.println("\u6258\u76d8\u529f\u80fd\u672a\u542f\u7528");
            return null;
        }
        Logger.println("\u6258\u76d8\u529f\u80fd\u5f00\u59cb\u542f\u7528");
        this.systemTray = SystemTray.getSystemTray();
        Dimension dimension = this.systemTray.getTrayIconSize();
        double d = System.getProperty("os.name").startsWith("Windows") ? 1.0 : 0.8;
        int n = (int)((double)dimension.width * d);
        Logger.println("Systray width: " + n);
        this.systemTrayImg = this.systemTrayImg.getScaledInstance(n, -1, 4);
        PopupMenu popupMenu = this.createPopupMenu();
        this.trayIcon = new TrayIcon(this.systemTrayImg, "BilibiliDown", popupMenu);
        this.trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    Logger.println("\u53cc\u51fb\u5de6\u952e\uff01");
                    SysTray.this.frame.setVisible(true);
                    SysTray.this.frame.setExtendedState(0);
                }
            }
        });
        try {
            this.systemTray.add(this.trayIcon);
            this.frame.setExtendedState(1);
            return this;
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
            return null;
        }
    }

    private PopupMenu createPopupMenu() {
        PopupMenu popupMenu = new PopupMenu();
        MenuItem menuItem = this.createMainMenuItem();
        MenuItem menuItem2 = this.createExitMenuItem();
        popupMenu.add(menuItem);
        popupMenu.addSeparator();
        popupMenu.add(menuItem2);
        return popupMenu;
    }

    private MenuItem createMainMenuItem() {
        MenuItem menuItem = new MenuItem("BilibiliDown~");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SysTray.this.frame.setVisible(true);
                SysTray.this.frame.setExtendedState(0);
            }
        });
        return menuItem;
    }

    private MenuItem createExitMenuItem() {
        MenuItem menuItem = new MenuItem("Exit");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray;
                if (SysTray.this.frame instanceof FrameMain && Global.downloadTab.activeTask > 0) {
                    objectArray = new Object[]{"\u6211\u8981\u9000\u51fa", "\u6211\u518d\u60f3\u60f3"};
                    String string = String.format("\u5f53\u524d\u4ecd\u6709 %d \u4e2a\u4efb\u52a1\u5728\u4e0b\u8f7d/\u8f6c\u7801\uff0c\u6b63\u5728\u8f6c\u7801\u7684\u6587\u4ef6\u9000\u51fa\u540e\u53ef\u80fd\u4e22\u5931\u6216\u5f02\u5e38\uff0c\u786e\u5b9a\u8981\u9000\u51fa\u5417\uff1f", Global.downloadTab.activeTask);
                    int n = JOptionPane.showOptionDialog(null, string, "\u8b66\u544a", 0, -1, null, objectArray, objectArray[0]);
                    Logger.println(n);
                    if (n != 0) {
                        return;
                    }
                }
                Logger.println("closing...");
                objectArray = new WindowEvent(SysTray.this.frame, 201);
                SysTray.this.frame.dispatchEvent((AWTEvent)objectArray);
            }
        });
        return menuItem;
    }
}

