/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui.thread;

import java.awt.Dimension;
import javax.swing.JPanel;
import nicelee.bilibili.INeedAV;
import nicelee.bilibili.exceptions.BilibiliError;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.util.CmdUtil;
import nicelee.bilibili.util.RepoUtil;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.bilibili.util.custom.System;
import nicelee.ui.Global;
import nicelee.ui.TabDownload;
import nicelee.ui.item.DownloadInfoPanel;
import nicelee.ui.item.JOptionPaneManager;
import nicelee.ui.thread.BatchDownloadRbyRThread;
import nicelee.ui.thread.DownloadRunnableInternal;

public class DownloadRunnable
implements Runnable {
    VideoInfo avInfo;
    ClipInfo clip;
    String displayName;
    String avid;
    String cid;
    int page;
    int remark;
    String record;
    int qn;
    static final String MSG_VIDEO_DOWNLOADED = "\u60a8\u5df2\u7ecf\u4e0b\u8f7d\u8fc7\u89c6\u9891 %s\n\u5982\u679c\u60f3\u7ee7\u7eed\u4e0b\u8f7d:\n\u4e34\u65f6\u65b9\u6848: \u53f3\u4e0a\u89d2[\u914d\u7f6e] -> [\u4e0b\u8f7d\u524d\u5148\u67e5\u8be2\u8bb0\u5f55?] -> [\u4e0d\u67e5\u8be2]\n\u6301\u4e45\u5316\u65b9\u6848: \u5728\u914d\u7f6e\u9875\u641c\u7d22\u5e76\u4fee\u6539\u914d\u7f6e bilibili.repo";

    public DownloadRunnable(VideoInfo videoInfo, ClipInfo clipInfo, int n) {
        this.avInfo = videoInfo;
        this.displayName = clipInfo.getAvTitle() + "p" + clipInfo.getRemark() + "-" + clipInfo.getTitle();
        this.clip = clipInfo;
        this.avid = clipInfo.getAvId();
        this.cid = String.valueOf(clipInfo.getcId());
        this.page = clipInfo.getPage();
        this.remark = clipInfo.getRemark();
        this.qn = n;
        this.record = this.avid + "-" + n + "-p" + this.page;
    }

    @Override
    public void run() {
        try {
            this.download();
        }
        catch (BilibiliError bilibiliError) {
            JOptionPaneManager.alertErrMsgWithNewThread("\u53d1\u751f\u4e86\u9884\u6599\u4e4b\u5916\u7684\u9519\u8bef", ResourcesUtil.detailsOfException(bilibiliError));
            BatchDownloadRbyRThread.taskFail(this.clip, ResourcesUtil.detailsOfException(bilibiliError));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BatchDownloadRbyRThread.taskFail(this.clip, ResourcesUtil.detailsOfException(exception));
        }
    }

    public void download() {
        int n;
        String string;
        System.out.println("\u4f60\u70b9\u51fb\u4e86\u4e00\u6b21\u4e0b\u8f7d\u6309\u94ae...");
        if (TabDownload.isStopAll()) {
            System.out.println("\u4f60\u70b9\u51fb\u4e86\u4e00\u6b21\u6682\u505c\u6309\u94ae...");
            BatchDownloadRbyRThread.taskFail(this.clip, "stop manualy");
            return;
        }
        if (Global.useRepo && RepoUtil.isInRepo(this.record)) {
            JOptionPaneManager.showMsgWithNewThread("\u63d0\u793a", String.format(MSG_VIDEO_DOWNLOADED, this.record));
            System.out.println("\u5df2\u7ecf\u4e0b\u8f7d\u8fc7 " + this.record);
            BatchDownloadRbyRThread.taskFail(this.clip, "already downloaded");
            return;
        }
        DownloadInfoPanel downloadInfoPanel = new DownloadInfoPanel(this.clip, this.qn);
        if (Global.downloadTaskList.get(downloadInfoPanel) != null) {
            System.out.println("\u5df2\u7ecf\u5b58\u5728\u76f8\u5173\u4e0b\u8f7d");
            BatchDownloadRbyRThread.taskFail(this.clip, "already in download panel");
            return;
        }
        INeedAV iNeedAV = new INeedAV();
        if (!ResourcesUtil.isPicture(this.avid)) {
            string = iNeedAV.getInputParser(this.avid).getVideoLink(this.avid, this.cid, this.qn, Global.downloadFormat);
            n = iNeedAV.getInputParser(this.avid).getVideoLinkQN();
        } else {
            string = this.clip.getLinks().get(0);
            n = 0;
        }
        String string2 = CmdUtil.genFormatedName(this.avInfo, this.clip, n);
        String string3 = this.avid + "-" + n;
        this.record = string3 + "-p" + this.page;
        if (this.qn != n && Global.useRepo && RepoUtil.isInRepo(this.record)) {
            JOptionPaneManager.showMsgWithNewThread("\u63d0\u793a", String.format(MSG_VIDEO_DOWNLOADED, this.record));
            System.out.println("\u5df2\u7ecf\u4e0b\u8f7d\u8fc7 " + this.record);
            BatchDownloadRbyRThread.taskFail(this.clip, "already downloaded2");
            return;
        }
        downloadInfoPanel.initDownloadParams(iNeedAV, string, string3, string2, n);
        if (Global.downloadTaskList.get(downloadInfoPanel) != null) {
            System.out.println("\u5df2\u7ecf\u5b58\u5728\u76f8\u5173\u4e0b\u8f7d");
            BatchDownloadRbyRThread.taskFail(this.clip, "already in download panel2");
            return;
        }
        Global.downloadTaskList.put(downloadInfoPanel, iNeedAV.getDownloader());
        BatchDownloadRbyRThread.taskFail(this.clip, "just put in download panel");
        JPanel jPanel = Global.downloadTab.getJpContent();
        jPanel.add(downloadInfoPanel);
        jPanel.setPreferredSize(new Dimension(1100, 128 * Global.downloadTaskList.size()));
        if (!Global.downLoadThreadPool.isShutdown()) {
            Global.downLoadThreadPool.execute(new DownloadRunnableInternal(downloadInfoPanel, System.currentTimeMillis(), false, 0));
        }
        if (Global.sleepAfterDownloadQuery > 0L) {
            try {
                Thread.sleep(Global.sleepAfterDownloadQuery);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

