/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili;

import java.net.HttpCookie;
import java.util.List;
import nicelee.bilibili.INeedLogin;
import nicelee.bilibili.downloaders.Downloader;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.InputParser;
import nicelee.bilibili.util.ConfigUtil;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpRequestUtil;
import nicelee.bilibili.util.HttpRequestUtilEx;
import nicelee.bilibili.util.Logger;
import nicelee.ui.Global;

public class INeedAV {
    private HttpRequestUtil util = new HttpRequestUtilEx();
    private InputParser inputParser = null;
    private Downloader downloader = new Downloader();

    public INeedAV() {
        this.downloader.init(this.util);
        this.inputParser = new InputParser(this.util, Global.pageSize, Global.pageDisplay);
    }

    public static void main(String[] stringArray) {
        System.out.println("-------------------------------");
        System.out.println("\u8f93\u5165av\u53f7, \u4e0b\u8f7d\u5f53\u524dcookie\u6240\u80fd\u4e0b\u8f7d\u7684\u6700\u6e05\u6670\u94fe\u63a5");
        System.out.println("-------------------------------");
        ConfigUtil.initConfigs();
        INeedAV iNeedAV = new INeedAV();
        INeedLogin iNeedLogin = new INeedLogin();
        List<HttpCookie> list = null;
        String string = iNeedLogin.readCookies();
        if (string != null) {
            list = HttpCookies.convertCookies(string);
        }
        HttpCookies.setGlobalCookies(list);
        try {
            VideoInfo videoInfo = iNeedAV.getVideoDetail(stringArray[0], Global.downloadFormat, false);
            for (ClipInfo clipInfo : videoInfo.getClips().values()) {
                Logger.println(clipInfo.getAvTitle());
                iNeedAV.downloadClip(clipInfo);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean downloadClip(ClipInfo clipInfo) {
        return this.downloadClip(this.inputParser.getVideoLink(clipInfo.getAvId(), "" + clipInfo.getcId(), 120, 1), clipInfo.getAvId(), this.inputParser.getRealQN(), clipInfo.getPage());
    }

    public boolean downloadClip(String string, String string2, int n, int n2) {
        return this.downloader.download(string, string2, n, n2);
    }

    public VideoInfo getVideoDetail(String string, int n, boolean bl) {
        return this.inputParser.result(string, n, bl);
    }

    public String getValidID(String string) {
        return this.inputParser.validStr(string);
    }

    public InputParser getInputParser(String string) {
        return this.inputParser;
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    public HttpRequestUtil getUtil() {
        return this.util;
    }
}

