/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.enums.VideoQualityEnum;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractPageQueryParser;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="ml-parser", note="\u6536\u85cf\u5939\u89e3\u6790\u5668")
public class MLParser
extends AbstractPageQueryParser<VideoInfo> {
    private static final Pattern pattern = Pattern.compile("ml([0-9]+)");
    protected String mlIdNumber;

    public MLParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        if (this.matcher.find()) {
            this.mlIdNumber = this.matcher.group(1);
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return "ml" + this.mlIdNumber + "p=" + this.paramSetter.getPage();
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        System.out.println("MLParser\u6b63\u5728\u83b7\u53d6\u7ed3\u679c" + this.mlIdNumber);
        this.result(this.pageSize, this.paramSetter.getPage(), this.mlIdNumber, n, bl);
        return (VideoInfo)this.pageQueryResult;
    }

    @Override
    public void initPageQueryParam() {
        this.API_PMAX = 20;
        this.pageQueryResult = new VideoInfo();
        ((VideoInfo)this.pageQueryResult).setClips(new LinkedHashMap<Long, ClipInfo>());
    }

    @Override
    protected boolean query(int n, int n2, int n3, Object ... objectArray) {
        String string = (String)objectArray[0];
        int n4 = (Integer)objectArray[1];
        boolean bl = (Boolean)objectArray[2];
        try {
            System.out.printf("--\u83b7\u53d6\u6536\u85cf\u5939\u89c6\u9891\uff1a \u7b2c%d\u9875 \u7b2c%d \u5230 \u7b2c%d\n", n, n2, n3);
            String string2 = "https://api.bilibili.com/medialist/gateway/base/detail?media_id=%s&pn=%d&ps=%d";
            String string3 = String.format(string2, string, n, this.API_PMAX);
            String string4 = this.util.getContent(string3, new HttpHeaders().getFavListHeaders(string), HttpCookies.getGlobalCookies());
            Logger.println(string3);
            Logger.println(string4);
            JSONObject jSONObject = new JSONObject(string4);
            JSONObject jSONObject2 = jSONObject.getJSONObject("data");
            JSONObject jSONObject3 = jSONObject.getJSONObject("data").getJSONObject("info");
            if (((VideoInfo)this.pageQueryResult).getVideoName() == null) {
                ((VideoInfo)this.pageQueryResult).setVideoId("ml" + string);
                ((VideoInfo)this.pageQueryResult).setVideoName(jSONObject3.getString("title") + this.paramSetter.getPage());
                ((VideoInfo)this.pageQueryResult).setBrief(jSONObject3.getJSONObject("upper").getString("name") + " \u7684\u6536\u85cf\u5939");
                ((VideoInfo)this.pageQueryResult).setAuthor(jSONObject3.getJSONObject("upper").getString("name"));
                ((VideoInfo)this.pageQueryResult).setAuthorId("" + jSONObject3.getJSONObject("upper").getLong("mid"));
                ((VideoInfo)this.pageQueryResult).setVideoPreview(jSONObject3.getString("cover"));
            }
            LinkedHashMap<Long, ClipInfo> linkedHashMap = ((VideoInfo)this.pageQueryResult).getClips();
            JSONArray jSONArray = jSONObject2.getJSONArray("medias");
            for (int i = n2 - 1; i < jSONArray.length() && i < n3; ++i) {
                Object object;
                JSONObject jSONObject4 = jSONArray.getJSONObject(i);
                String string5 = jSONObject4.getString("bvid");
                String string6 = jSONObject4.getString("title");
                String string7 = jSONObject4.getJSONObject("upper").getString("name");
                String string8 = "" + jSONObject4.getJSONObject("upper").getLong("mid");
                long l = jSONObject4.optLong("fav_time") * 1000L;
                long l2 = jSONObject4.optLong("ctime") * 1000L;
                JSONArray jSONArray2 = jSONObject4.optJSONArray("pages");
                if (jSONArray2 == null) {
                    int[] nArray;
                    String string9 = jSONObject4.optString("link", "");
                    if (!string9.startsWith("bilibili://music")) continue;
                    long l3 = jSONObject4.optLong("id");
                    object = new ClipInfo();
                    ((ClipInfo)object).setAvTitle(string6);
                    ((ClipInfo)object).setAvId("au" + l3);
                    ((ClipInfo)object).setcId(l3);
                    ((ClipInfo)object).setPage(1);
                    ((ClipInfo)object).setTitle(string6);
                    ((ClipInfo)object).setPicPreview(jSONObject4.getString("cover"));
                    ((ClipInfo)object).setRemark((n - 1) * this.API_PMAX + i + 1);
                    ((ClipInfo)object).setListName(jSONObject3.getString("title").replaceAll("[/\\\\]", "_"));
                    ((ClipInfo)object).setListOwnerName(((VideoInfo)this.pageQueryResult).getAuthor().replaceAll("[/\\\\]", "_"));
                    ((ClipInfo)object).setListOwnerId(((VideoInfo)this.pageQueryResult).getAuthorId());
                    ((ClipInfo)object).setUpName(string7);
                    ((ClipInfo)object).setUpId(string8);
                    ((ClipInfo)object).setFavTime(l);
                    ((ClipInfo)object).setcTime(l2);
                    LinkedHashMap linkedHashMap2 = new LinkedHashMap();
                    for (int n5 : nArray = new int[]{3, 2, 1, 0}) {
                        linkedHashMap2.put(n5, "");
                    }
                    ((ClipInfo)object).setLinks(linkedHashMap2);
                    linkedHashMap.put(((ClipInfo)object).getcId(), (ClipInfo)object);
                    continue;
                }
                for (int j = 0; j < jSONArray2.length(); ++j) {
                    JSONObject jSONObject5 = jSONArray2.getJSONObject(j);
                    ClipInfo clipInfo = new ClipInfo();
                    clipInfo.setAvId(string5);
                    clipInfo.setcId(jSONObject5.getLong("id"));
                    clipInfo.setPage(jSONObject5.getInt("page"));
                    clipInfo.setRemark((n - 1) * this.API_PMAX + i + 1);
                    clipInfo.setPicPreview(jSONObject4.getString("cover"));
                    clipInfo.setListName(jSONObject3.getString("title").replaceAll("[/\\\\]", "_"));
                    clipInfo.setListOwnerName(((VideoInfo)this.pageQueryResult).getAuthor().replaceAll("[/\\\\]", "_"));
                    clipInfo.setListOwnerId(((VideoInfo)this.pageQueryResult).getAuthorId());
                    clipInfo.setUpName(string7);
                    clipInfo.setUpId(string8);
                    clipInfo.setAvTitle(string6);
                    clipInfo.setTitle(jSONObject5.getString("title"));
                    clipInfo.setFavTime(l);
                    clipInfo.setcTime(l2);
                    object = new LinkedHashMap();
                    try {
                        for (VideoQualityEnum videoQualityEnum : VideoQualityEnum.values()) {
                            if (bl) {
                                String string10 = this.getVideoLink(string5, String.valueOf(clipInfo.getcId()), videoQualityEnum.getQn(), n4);
                                ((HashMap)object).put(videoQualityEnum.getQn(), string10);
                                continue;
                            }
                            ((HashMap)object).put(videoQualityEnum.getQn(), "");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    clipInfo.setLinks((HashMap<Integer, String>)object);
                    linkedHashMap.put(clipInfo.getcId(), clipInfo);
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

