/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util.check;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RafRBuffered {
    byte[] buffer;
    int pointer;
    int validBound;
    RandomAccessFile raf;

    public RafRBuffered(File file, String string) throws FileNotFoundException {
        this(file, string, 0x400000);
    }

    public RafRBuffered(File file, String string, int n) throws FileNotFoundException {
        this.buffer = new byte[n];
        this.raf = new RandomAccessFile(file, string);
        this.pointer = 0;
        this.validBound = 0;
    }

    public int read() throws IOException {
        if (this.pointer < this.validBound) {
            byte by = this.buffer[this.pointer];
            ++this.pointer;
            return by;
        }
        this.validBound = this.raf.read(this.buffer);
        this.pointer = 1;
        return this.buffer[0];
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.validBound - this.pointer;
        if (n3 >= n2) {
            System.arraycopy(this.buffer, this.pointer, byArray, n, n2);
            this.pointer += n2;
            return n2;
        }
        try {
            System.arraycopy(this.buffer, this.pointer, byArray, n, n3);
        }
        catch (Exception exception) {
            return -1;
        }
        int n4 = n2 - n3;
        if (n4 >= this.buffer.length) {
            int n5 = this.raf.read(byArray, n + n3, n4);
            this.pointer = 0;
            this.validBound = 0;
            return n3 + n5;
        }
        int n6 = this.raf.read(this.buffer);
        if (n6 == -1) {
            this.pointer = 0;
            this.validBound = 0;
            if (n3 == 0) {
                return -1;
            }
            return n3;
        }
        if (n6 >= n4) {
            System.arraycopy(this.buffer, 0, byArray, n + n3, n4);
            this.validBound = n6;
            this.pointer = n4;
            return n3 + n4;
        }
        System.arraycopy(this.buffer, 0, byArray, n + n3, n6);
        this.pointer = 0;
        this.validBound = 0;
        return n3 + n6;
    }

    public int skipBytes(int n) throws IOException {
        int n2 = this.validBound - this.pointer;
        if (n2 >= n) {
            this.pointer += n;
            return n;
        }
        int n3 = n - n2;
        if (n3 >= this.buffer.length) {
            int n4 = this.raf.skipBytes(n3);
            this.pointer = 0;
            this.validBound = 0;
            return n2 + n4;
        }
        int n5 = this.raf.read(this.buffer);
        if (n5 >= n3) {
            this.validBound = n5;
            this.pointer = n3;
            return n2 + n3;
        }
        this.pointer = 0;
        this.validBound = 0;
        return n2 + n5;
    }

    public void seek(long l) throws IOException {
        long l2 = this.raf.getFilePointer() - (long)this.validBound;
        long l3 = this.raf.getFilePointer();
        if (l >= l2 && l < l3) {
            this.pointer = (int)(l - l2);
        } else {
            this.raf.seek(l);
            this.pointer = 0;
            this.validBound = 0;
        }
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer() - (long)this.validBound + (long)this.pointer;
    }
}

