# 贡献指南

感谢您对本资源库的关注！我们欢迎任何形式的贡献。

## 🤝 如何贡献

### 提交资源

1. **Fork 本仓库**
2. **创建新分支**：`git checkout -b feature/课程名称-资源类型`
3. **添加资源**：将资源文件添加到对应的课程文件夹中
4. **提交更改**：`git commit -m "添加: 课程名称-资源描述"`
5. **推送分支**：`git push origin feature/课程名称-资源类型`
6. **创建 Pull Request**

### 资源组织规范

- 按照课程名称创建文件夹（如果不存在）
- 文件命名规范：`课程名称-资源类型-其他信息.扩展名`
  - 例如：`数据结构-2023年期末试卷-A卷.pdf`
- 在提交时，请在PR中说明：
  - 资源类型（教材/试卷/题库/笔记等）
  - 适用课程和学期
  - 资源来源（如适用）

### 资源类型

- 📘 **电子版教材**：课程使用的教材电子版
- 📝 **习题解析**：课后习题的详细解答
- 📄 **历年真题试卷**：往年的期末考试试卷及参考答案
- 📋 **整理的题库**：根据课程内容整理的题目集合
- 📚 **复习资料**：课程笔记、复习提纲等学习辅助材料

## ⚠️ 注意事项

1. **版权问题**：请确保您有权限分享所提交的资源
2. **文件大小**：大型文件（>50MB）建议使用Git LFS或外部链接
3. **文件格式**：优先使用PDF、Markdown等通用格式
4. **内容质量**：请确保资源清晰、完整、准确

## 📝 提交信息规范

提交信息应清晰描述更改内容：

- `添加: 课程名称-资源描述`
- `更新: 课程名称-资源描述`
- `修复: 问题描述`
- `文档: 更新说明`

## 🐛 报告问题

如果发现资源有问题或需要补充，请创建 Issue 并说明：
- 问题描述
- 涉及的课程/资源
- 建议的解决方案（如适用）

再次感谢您的贡献！🎉

