#!/usr/bin/env python3

from struct import pack
from binascii import hexlify

dat = [
    0x200640,
    0x100,
    0x2009BC,
    0x20060C,
    0x1,
    0x956FC3F1,
    0xFC44ED52,
    0x110,
    0x30,
    0xB88D2DE6,
    0x420AFD30,
    0x981673DC,
    0xCEF139F6,
    0x7D7EBEBF,
    0x453663E9,
    0x80C24808,
    0x31D907A3,
    0x1A00116C,
    0xDA35675B,
    0xA5A7407A,
    0x93AB1070,
    0xA6C10A71,
    0xF7DCA502,
    0x507F584D,
    0xAF6FF845,
    0xA987DDCC,
    0x59A4A85B,
    0xBF79EDB5,
    0xAFEE683A,
    0x7FB92904,
    0xC8AECBF5,
    0x417111DF,
    0xC9674933,
    0xB5584779,
    0xCE870108,
    0x1EB5ED61,
    0x680DA351,
    0x11F4C09F,
    0x9E657A29,
    0x9EC0896,
    0xBA8AA025,
    0x5DB75909,
    0xC9C04648,
    0x7CFBF2DE,
    0x97401150,
    0x9B607559,
    0xCDDBB1B4,
    0x79F3ABE2,
    0x589E0744,
    0x783473D3,
    0x9E944CF2,
    0x105C1944,
    0xE2E94E57,
    0x2752C848,
    0x9F46B50,
    0xF9FC82B5,
    0x4F27A5C,
    0xEE2D404,
    0xE4227778,
    0xB469652D,
    0xB97E773E,
    0x5AF74F66,
    0x2774802F,
    0xD8D46FD,
    0x53D02BE9,
    0xC981FADC,
    0x97448D08,
    0x1DE7B5A3,
    0x61116241,
    0xC2CA39C4,
    0x305022B9,
    0xB6B88748,
    0x2EE14D00,
    0xE62F5BB0,
    0xA552FFD7,
    0x321F0BBE,
    0xA637A977,
    0x8A7E95D0,
    0x93C0EC5F,
    0x5E42AA13,
    0x10FAB161,
    0x4E20BFE3,
    0x1208EAAC,
    0xDCBC80E8,
    0xC6CC5571,
    0x4C0C7A75,
    0xA5B5AE44,
    0x2E9285DE,
    0xC9585FC2,
    0x8DE3F166,
    0xEAD706BC,
    0x8362E701,
    0x4B3CA8C9,
    0xDE2DE227,
    0x50D72910,
    0x47DDAE24,
    0x251A1AE8,
    0x6EEA11F3,
    0x77213D30,
    0xEBF0C572,
    0xCB8674AE,
    0x1B0C0665,
    0xDAC240F6,
    0xE13686F6,
    0xE1A57AA9,
    0x4C95FD31,
    0xB4DFE80B,
    0x822A2B20,
    0x65B82AA1,
    0x55933F7B,
    0xE9859433,
    0x822B1C12,
    0xCC62A517,
    0x8024C43F,
    0xBBBB8397,
    0x14E1AA71,
    0x5E4B2739,
    0x290643A3,
    0x5B319383,
    0xAFF63229,
    0xD533632E,
    0x2574FB7D,
    0x36584B13,
    0x7E3A89A0,
    0xA3055297,
    0xE1FDC3BB,
    0xAC2BCF8B,
    0xE2B3D63,
    0xB8621010,
    0x226C7FC3,
    0x16B7325D,
    0x1E8D7217,
    0x6429282D,
    0x857A06BE,
    0x93DC2A42,
    0xFFEE5953,
    0x97E14DC,
    0x970A0109,
    0xF8569B9E,
    0x42D481C4,
    0x48463BA2,
    0x80439D11,
    0x46A26CC8,
    0xF9286FFF,
    0xAC75485,
    0xF041347A,
    0xAAF4877A,
    0xA62E4D5A,
    0x93BD8D8E,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x0,
    0x0,
    0x0,
    0x0,
    0xF82D9879,
    0xDA1900FB,
    0x58EBFFF2,
    0x4EB2DFB4,
    0x1C33F5A4,
    0x370C5164,
    0x9221FC94,
    0x5004E2C3,
    0x7FD052F6,
    0x7595B765,
    0x18DF431D,
    0xE9923FD0,
    0xA092A13,
    0x5FD2884C,
    0xC7E313BA,
    0xE61A166,
    0xC2B78486,
    0x7E514A14,
    0x19E03A5C,
    0xD34147FA,
    0xD458DDEC,
    0xC944D376,
    0x7BBDBA4,
    0x13C87753,
    0x55524FFD,
    0xCCAC8772,
    0x542AD157,
    0xA0CB045A,
    0xB950F97A,
    0x2245DF6B,
    0x418D3050,
    0x26DF2DF2,
    0x8A5BC3CE,
    0xE142848,
    0xE3D8C454,
    0xC1DA9D2D,
    0x3511D990,
    0xD42A0CD0,
    0x9132E073,
    0x33A1702,
    0xEAB064F2,
    0x6CF228D0,
    0x840D744D,
    0xC87F2596,
    0xB5166023,
    0xCA00D29C,
    0x6A5B6AA2,
    0x68E72E20,
    0x226F2776,
    0x8395A840,
    0xF7553CAB,
    0x21FE7AA6,
    0x6CADDABD,
    0xDBCA4AD9,
    0x43142719,
    0x3F8F15DE,
    0x22AE6502,
    0xFAE8C0C9,
    0xD32715EF,
    0x53544A23,
    0x603C72C2,
    0xD0B37957,
    0x14D0BCB0,
    0x8AF20686,
    0x246300,
    0x70000000,
    0x70000000
]

strm = ""
for val in dat:
    strm += hexlify(pack("<I", val)).decode('utf-8')

print(strm)
""" iv
DE 8A 8E D1 16 A3 52 DF 2D 5B 35 04 4B CD D5 19
"""

""" provkey
E6 2D 8D B8 30 FD 0A 42 DC 73 16 98 F6 39 F1 CE
"""
""" provkey hash sha256 = aes key
BF BE 7E 7D E9 63 36 45 08 48 C2 80 A3 07 D9 31
6C 11 00 1A 5B 67 35 DA 7A 40 A7 A5 70 10 AB 93
"""
""" n
71 0A C1 A6 02 A5 DC F7 4D 58 7F 50 45 F8 6F AF
CC DD 87 A9 5B A8 A4 59 B5 ED 79 BF 3A 68 EE AF
04 29 B9 7F F5 CB AE C8 DF 11 71 41 33 49 67 C9
79 47 58 B5 08 01 87 CE 61 ED B5 1E 51 A3 0D 68
9F C0 F4 11 29 7A 65 9E 96 08 EC 09 25 A0 8A BA
09 59 B7 5D 48 46 C0 C9 DE F2 FB 7C 50 11 40 97
59 75 60 9B B4 B1 DB CD E2 AB F3 79 44 07 9E 58
D3 73 34 78 F2 4C 94 9E 44 19 5C 10 57 4E E9 E2
48 C8 52 27 50 6B F4 09 B5 82 FC F9 5C 7A F2 04
04 D4 E2 0E 78 77 22 E4 2D 65 69 B4 3E 77 7E B9
66 4F F7 5A 2F 80 74 27 FD 46 8D 0D E9 2B D0 53
DC FA 81 C9 08 8D 44 97 A3 B5 E7 1D 41 62 11 61
C4 39 CA C2 B9 22 50 30 48 87 B8 B6 00 4D E1 2E
B0 5B 2F E6 D7 FF 52 A5 BE 0B 1F 32 77 A9 37 A6
D0 95 7E 8A 5F EC C0 93 13 AA 42 5E 61 B1 FA 10
E3 BF 20 4E AC EA 08 12 E8 80 BC DC 71 55 CC C6
"""
""" e
75 7A 0C 4C 44 AE B5 A5 DE 85 92 2E C2 5F 58 C9
66 F1 E3 8D BC 06 D7 EA 01 E7 62 83 C9 A8 3C 4B
27 E2 2D DE 10 29 D7 50 24 AE DD 47 E8 1A 1A 25
F3 11 EA 6E 30 3D 21 77 72 C5 F0 EB AE 74 86 CB
65 06 0C 1B F6 40 C2 DA F6 86 36 E1 A9 7A A5 E1
31 FD 95 4C 0B E8 DF B4 20 2B 2A 82 A1 2A B8 65
7B 3F 93 55 33 94 85 E9 12 1C 2B 82 17 A5 62 CC
3F C4 24 80 97 83 BB BB 71 AA E1 14 39 27 4B 5E
A3 43 06 29 83 93 31 5B 29 32 F6 AF 2E 63 33 D5
7D FB 74 25 13 4B 58 36 A0 89 3A 7E 97 52 05 A3
BB C3 FD E1 8B CF 2B AC 63 3D 2B 0E 10 10 62 B8
C3 7F 6C 22 5D 32 B7 16 17 72 8D 1E 2D 28 29 64
BE 06 7A 85 42 2A DC 93 53 59 EE FF DC 14 7E 09
09 01 0A 97 9E 9B 56 F8 C4 81 D4 42 A2 3B 46 48
11 9D 43 80 C8 6C A2 46 FF 6F 28 F9 85 54 C7 0A
7A 34 41 F0 7A 87 F4 AA 5A 4D 2E A6 8E 8D BD 93
"""
""" tee_key_pos
10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10
00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
79 98 2D F8 FB 00 19 DA F2 FF EB 58 B4 DF B2 4E
A4 F5 33 1C 64 51 0C 37 94 FC 21 92 C3 E2 04 50
F6 52 D0 7F 65 B7 95 75 1D 43 DF 18 D0 3F 92 E9
13 2A 09 0A 4C 88 D2 5F BA 13 E3 C7 66 A1 61 0E
86 84 B7 C2 14 4A 51 7E 5C 3A E0 19 FA 47 41 D3
EC DD 58 D4 76 D3 44 C9 A4 DB BB 07 53 77 C8 13
FD 4F 52 55 72 87 AC CC 57 D1 2A 54 5A 04 CB A0
7A F9 50 B9 6B DF 45 22 50 30 8D 41 F2 2D DF 26
CE C3 5B 8A 48 28 14 0E 54 C4 D8 E3 2D 9D DA C1
90 D9 11 35 D0 0C 2A D4 73 E0 32 91 02 17 3A 03
F2 64 B0 EA D0 28 F2 6C 4D 74 0D 84 96 25 7F C8
23 60 16 B5 9C D2 00 CA A2 6A 5B 6A 20 2E E7 68
76 27 6F 22 40 A8 95 83 AB 3C 55 F7 A6 7A FE 21
BD DA AD 6C D9 4A CA DB 19 27 14 43 DE 15 8F 3F
02 65 AE 22 C9 C0 E8 FA EF 15 27 D3 23 4A 54 53
C2 72 3C 60 57 79 B3 D0 B0 BC D0 14 86 06 F2 8A
00 63 24 00
"""

""" true n
C6CC5571DCBC80E81208EAAC4E20BFE310FAB1615E42AA1393C0EC5F8A7E95D0A637A977321F0BBEA552FFD7E62F5BB02EE14D00B6B88748305022B9
C2CA39C4611162411DE7B5A397448D08C981FADC53D02BE90D8D46FD2774802F5AF74F66B97E773EB469652DE42277780EE2D40404F27A5CF9FC82B5
09F46B502752C848E2E94E57105C19449E944CF2783473D3589E074479F3ABE2CDDBB1B49B607559974011507CFBF2DEC9C046485DB75909BA8AA025
09EC08969E657A2911F4C09F680DA3511EB5ED61CE870108B5584779C9674933417111DFC8AECBF57FB92904AFEE683ABF79EDB559A4A85BA987DDCC
AF6FF845507F584DF7DCA502A6C10A7110101010101010101010101010101010
"""
""" true e
93BD8D8EA62E4D5AAAF4877AF041347A0AC75485F9286FFF46A26CC880439D1148463BA242D481C4F8569B9E970A0109097E14DCFFEE595393DC2A42
857A06BE6429282D1E8D721716B7325D226C7FC3B86210100E2B3D63AC2BCF8BE1FDC3BBA30552977E3A89A036584B132574FB7DD533632EAFF63229
5B319383290643A35E4B273914E1AA71BBBB83978024C43FCC62A517822B1C12E985943355933F7B65B82AA1822A2B20B4DFE80B4C95FD31E1A57AA9
E13686F6DAC240F61B0C0665CB8674AEEBF0C57277213D306EEA11F3251A1AE847DDAE2450D72910DE2DE2274B3CA8C98362E701EAD706BC8DE3F166
C9585FC22E9285DEA5B5AE444C0C7A7510101010101010101010101010101010
"""

""" Trace
[IDACode] Executing /home/bjk/Projects/idaemu/idaemu.py
print : "get prov key..."
print : "sbc_en = 0"
tzcc_sha256: 03000000000100000000000001000100000000000000000000000000000000000000000000000000000000000000000000000000000
             00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
             00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
             00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
             00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
             0c1a9d3e65c7eaeb31932e9dd224c07c070d879fb4fe518c64e92c24b79dc1ee1535d91d38dd34d7e32a22deed60f0727ff8f8747e2
             598acb5ddc73c61d2434a91d568fe3e773bd0d17aa46b0364e0dcf3b41e0034605d572b6cd7dd8a816e7d684181b1646628576d1e22
             f55071687b9e5b2f9c9536167b7edcf10f1f85be57b6ee873bfe952bb33f0001140e0e46af2d64d39c568d8e372bce3609bcaca5316
             e4ebdde5721b33611e064df41a4bcf0a3a395791d3203bf220dc71f4267093ceb78e30a844d4631de8ce6d0514202bb58ad2024b165
             58c2ad9b30ce05043ff67c4d265a3d5f3275d93afdc1a39625c2c5bd6fdcdbd75e76e6d9e74e9672b5897
tzcc_clk : 1
SBROM_KeyDerivation: (0x10210000,0x2,label,0x8,salt,0x20,0x202fa0,0x0,0x10,)
label: 4b455920504c4154
salt: 1d92b707f1ba695b8328ad2c5194705b517693c105edc81bbd488df08161f21e
SBROM_AesCmac: (0x10210000,0x2,0x0,0x0,buffer,0x0,0x2b,0x33bb52e9,target_buffer,0x0)
buffer: 014b455920504c4154001d92b707f1ba695b8328ad2c5194705b517693c105edc81bbd488df08161f21e800000000000
target_buffer: 1a4bcf0a3a395791d3203bf220dc71f4014b455920504c4154001d92b707f1ba695b8328ad2c5194705b517693c105ed
user_to_sec: (buffer,0x0,sec_buffer,)
buffer: 014b455920504c4154001d92b707f1ba695b8328ad2c5194705b517693c105edc81bbd488df08161f21e8000000000000000000000000000
0000000000000000000000970000000000001000602f2000502f2000402f2000382f2000802f2000f9e92200602f200020000000a02f200000000000
10000000ff7209a9a02f2000
sec_buffer: 0000000000000000000000000000000000000000a42e2000010000002b000000b42e200002000000010000009dec2200b42e20000000
00002b000000e952bb33a42e200000000000d64d39c500002110a42e200000000000a02f2000721b33611e064df41a4bcf0a3a395791d3203bf220dc
71f4014b455920504c4154001d92
user_to_sec: (target_buffer,0x0,sec_target_buffer,)
target_buffer: 1a4bcf0a3a395791d3203bf220dc71f4014b455920504c4154001d92b707f1ba695b8328ad2c5194705b517693c105edc81bbd488
df08161f21e80000000000000000000000000000000000000000000000000970000000000001000602f2000502f2000402f2000382f2000802f2000f
9e92200602f200020000000a02f2000
sec_target_buffer: 000000000000000000000000a42e2000010000002b000000b42e200002000000010000009dec2200b42e2000000000002b000
000e952bb33a42e200000000000d64d39c500002110a42e200000000000a02f2000721b33611e064df41a4bcf0a3a395791d3203bf220dc71f4014b4
55920504c4154001d92b707f1ba695b8328
0x10210a08[W] : 0x4
0x10210e9c[R] : 0x0
0x10210e80[W] : 0x0
0x10210e84[W] : 0x8000041
0x10210e88[W] : 0x0
0x10210e8c[W] : 0x0
0x10210e90[W] : 0x1001c20
0x10210e94[W] : 0x0
0x10210e9c[R] : 0x0
0x10210e80[W] : 0x0
0x10210e84[W] : 0x0
0x10210e88[W] : 0x0
0x10210e8c[W] : 0x0
0x10210e90[W] : 0x4011c20
0x10210e94[W] : 0x0
0x10210e9c[R] : 0x0
0x10210e80[W] : buffer
0x10210e84[W] : 0xae
0x10210e88[W] : 0x0
0x10210e8c[W] : 0x0
0x10210e90[W] : 0x1
0x10210e94[W] : 0x0
0x10210a08[W] : 0x4
user_to_sec: (0x202d9c,0x0,0x202da0,)
0x202d9c: 00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000211002000000e82d20
00d1ed2200b42e2000a42e20000000000000000000b42e2000ae0000000000000000000000010000000000000000000000000000002b000000020000
0000002110b42e200000000000
0x202da0: 000000000000000000000000000000000000000000000000000000000000000000000000000000000000211002000000e82d2000d1ed22
00b42e2000a42e20000000000000000000b42e2000ae0000000000000000000000010000000000000000000000000000002b00000002000000000021
10b42e2000000000005beb2200
0x10210e9c[R] : 0x0
0x10210e80[W] : 0x0
0x10210e84[W] : 0x8000011
0x10210e88[W] : 0x202d9c
0x10210e8c[W] : 0x8000012
0x10210e90[W] : 0x100
0x10210e94[W] : 0x0
0x10210a00[R] : 0x0
0x10210ba0[R] : 0x0
0x10210e00[R] : 0x0
0x10210a08[W] : 0x4
0x10210af4[R] : 0x0
SBROM_KeyDerivation: (0x10210000,0x5,0x202f40,0xd,salt,0x20,0x202f50,0x0,0x10,)
0x202f40: 50524f564953494f4e204b4559
salt: 1d92b707f1ba695b8328ad2c5194705b517693c105edc81bbd488df08161f21e
SBROM_AesCmac: (0x10210000,0x5,0x0,0x0,buffer,0x0,0x30,0x33bb52e9,target_buffer,0x0)
buffer: 0150524f564953494f4e204b4559001d92b707f1ba695b8328ad2c5194705b517693c105edc81bbd488df08161f21e80
target_buffer: 1a4bcf0a3a395791d3203bf220dc71f40150524f564953494f4e204b4559001d92b707f1ba695b8328ad2c5194705b51
user_to_sec: (buffer,0x0,sec_buffer,)
buffer: 0150524f564953494f4e204b4559001d92b707f1ba695b8328ad2c5194705b517693c105edc81bbd488df08161f21e800000000000000000
000000000000000000000097000000000000100010000000502f2000402f2000382f2000802f200025ea2200602f200020000000502f200000000000
10000000ff7209a9a02f2000
sec_buffer: 0000000000000000000000000000000000000000a42e20000100000030000000b42e200005000000010000009dec2200b42e20000000
000030000000e952bb33a42e200000000000d64d39c500002110a42e200000000000502f2000000000001e064df41a4bcf0a3a395791d3203bf220dc
71f40150524f564953494f4e204b
user_to_sec: (target_buffer,0x0,sec_target_buffer,)
target_buffer: 1a4bcf0a3a395791d3203bf220dc71f40150524f564953494f4e204b4559001d92b707f1ba695b8328ad2c5194705b517693c105e
dc81bbd488df08161f21e800000000000000000000000000000000000000097000000000000100010000000502f2000402f2000382f2000802f20002
5ea2200602f200020000000502f2000
sec_target_buffer: 000000000000000000000000a42e20000100000030000000b42e200005000000010000009dec2200b42e20000000000030000
000e952bb33a42e200000000000d64d39c500002110a42e200000000000502f2000000000001e064df41a4bcf0a3a395791d3203bf220dc71f401505
24f564953494f4e204b4559001d92b707f1
0x10210a08[W] : 0x4
0x10210e9c[R] : 0x0
0x10210e80[W] : 0x0
0x10210e84[W] : 0x8000041
0x10210e88[W] : 0x0
0x10210e8c[W] : 0x0
0x10210e90[W] : 0x1001c20
0x10210e94[W] : 0x0
0x10210e9c[R] : 0x0
0x10210e80[W] : 0x0
0x10210e84[W] : 0x0
0x10210e88[W] : 0x0
0x10210e8c[W] : 0x0
0x10210e90[W] : 0x4109c20
0x10210e94[W] : 0x0
0x10210e9c[R] : 0x0
0x10210e80[W] : buffer
0x10210e84[W] : 0xc2
0x10210e88[W] : 0x0
0x10210e8c[W] : 0x0
0x10210e90[W] : 0x1
0x10210e94[W] : 0x0
0x10210e9c[R] : 0x0
0x10210e80[W] : 0x0
0x10210e84[W] : 0x0
0x10210e88[W] : target_buffer
0x10210e8c[W] : 0x42
0x10210e90[W] : 0x8001c26
0x10210e94[W] : 0x0
0x10210a08[W] : 0x4
user_to_sec: (0x202d9c,0x0,0x202da0,)
0x202d9c: 00000000000000000000000000000000110000089c2d200012000008000100000000000000000000000000000000211005000000e82d20
00d1ed2200b42e2000a42e200000000000000000000000000000000000a42e200042000000261c000800000000000000000000000030000000050000
0000002110b42e200000000000
0x202da0: 000000000000000000000000110000089c2d200012000008000100000000000000000000000000000000211005000000e82d2000d1ed22
00b42e2000a42e200000000000000000000000000000000000a42e200042000000261c00080000000000000000000000003000000005000000000021
10b42e2000000000005beb2200
0x10210e9c[R] : 0x0
0x10210e80[W] : 0x0
0x10210e84[W] : 0x8000011
0x10210e88[W] : 0x202d9c
0x10210e8c[W] : 0x8000012
0x10210e90[W] : 0x100
0x10210e94[W] : 0x0
0x10210a00[R] : 0x0
0x10210ba0[R] : 0x0
0x10210e00[R] : 0x0
0x10210a08[W] : 0x4
0x10210ac0[W] : 0x0
0x10210ac4[W] : 0x0
0x10210ac8[W] : 0x0
0x10210acc[W] : 0x0
0x10210e9c[R] : 0x0
0x10210e80[W] : 0x0
0x10210e84[W] : 0x8000081
0x10210e88[W] : 0x0
0x10210e8c[W] : 0x0
0x10210e90[W] : 0x4801c20
0x10210e94[W] : 0x0
0x10210a08[W] : 0x4
user_to_sec: (0x202ebc,0x0,0x202ec0,)
0x202ebc: 000000000000000000000000ba695b8328ad2c5194705b517693c105edc81bbd488df08161f21e80000021100000100010000000502f20
0005ee220000000000810000080000000000000000201c8004000000000000000039ea2200602f200020000000502f20000000000010000000ff7209
a9a02f2000080000004b455920
0x202ec0: 0000000000000000ba695b8328ad2c5194705b517693c105edc81bbd488df08161f21e80000021100000100010000000502f200005ee22
0000000000810000080000000000000000201c8004000000000000000039ea2200602f200020000000502f20000000000010000000ff7209a9a02f20
00080000004b455920504c4154
0x10210e9c[R] : 0x0
0x10210e80[W] : 0x0
0x10210e84[W] : 0x8000011
0x10210e88[W] : 0x202ebc
0x10210e8c[W] : 0x8000012
0x10210e90[W] : 0x100
0x10210e94[W] : 0x0
0x10210a00[R] : 0x0
0x10210ba0[R] : 0x0
0x10210e00[R] : 0x0
0x10210a08[W] : 0x4
tzcc_clk : 0
---- below is the trace ----
0x0
0x10


"""

"""
[00f0a3c036c60a52d40eaffa692073eb94dfcaedeba3cff268965796f551620cec5a113d7b6c372de4faf378b61a0711ace22df6a4803afb8eea20afa84a8f3bcde0bd39947167cf7c2182df032c10bfff332d5d5416e66088bf6d8934c57aa3066ab6af4b4bf7e74b170b15826c24292698b7b2ea9a761255fa208a39890cb04500000000c983c3af37cf42ddf54966]
[00c983c3af37cf42ddf549660c7ce91034c9bcb0b3ba76208616b37a6a52d63c04456e94acfca1ce29e44c88985804cd1b95b96416248fa7c2b3b5abc47c991623c34b5296ba3745aa58083dcf9bcb5402127f69b1744e3f9782cb6f2af90c66e44244281ff0df7865371d3433b078cdf601765e86e428230a83968b02698304c5000000008c1ea4f8b733d4e9055fee]
[00bc45b1de68e5acd642c3866cf7ba1a48392be127eadb887231a647f29980d851974a43cb2be8a41cb207099b98138dcdb08c7b9b4ac45b0afebd2211ce7bf0336cb13fba975bbc270765082cc82e36b96906062e0358ad90700d383b348275c85077ac0082686beb011567f7c9ba2504109a30fe8268fc818e18256d4c7fc3ed000000009fc9c3f9a5680fedc548ef]
[008c1ea4f8b733d4e9055fee278ccb7a4b5a636bf2ed1aaa6ed266261ebc4edf189136dd0693fbe6a0d6702922d541316596ec7c1db17a7a4a362f82aa7380f71612fbd3079fa0433eb94bb1bf243373cca51417681ed931faa625d2bcecc3a4dfdefc09727c48c72c89f03296268539a16f4ee157a65a0a538b4028949acd518900000000bc45b1de68e5acd642c386]
"""
