/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.drag;

import com.alee.utils.ImageUtils;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class ImageDragHandler
extends TransferHandler {
    private static final DataFlavor[] imageFlavor = new DataFlavor[]{DataFlavor.imageFlavor};
    private BufferedImage image;
    private boolean defaultBehavior = true;

    public ImageDragHandler(JComponent component, ImageIcon icon) {
        this(component, ImageUtils.getBufferedImage(icon));
    }

    public ImageDragHandler(JComponent component, Image image) {
        this(component, ImageUtils.getBufferedImage(image));
    }

    public ImageDragHandler(final JComponent component, BufferedImage image) {
        this.setImage(image);
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ImageDragHandler.this.isDefaultBehavior() && SwingUtilities.isLeftMouseButton(e) && component.isEnabled()) {
                    ImageDragHandler.this.exportAsDrag(component, e, ImageDragHandler.this.getSourceActions(component));
                }
            }
        });
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public boolean isDefaultBehavior() {
        return this.defaultBehavior;
    }

    public void setDefaultBehavior(boolean defaultBehavior) {
        this.defaultBehavior = defaultBehavior;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return imageFlavor;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.equals(DataFlavor.imageFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (this.isDataFlavorSupported(flavor)) {
                    return ImageDragHandler.this.image;
                }
                return null;
            }
        };
    }
}

