/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.extended.label.AdaptiveStyledLabelPainter;
import com.alee.extended.label.StyledLabelPainter;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.label.WebStyledLabelStyle;
import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.managers.style.StyleManager;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.Styleable;
import com.alee.utils.swing.BorderMethods;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class WebStyledLabelUI
extends BasicLabelUI
implements Styleable,
BorderMethods,
SwingConstants {
    protected Insets margin = WebStyledLabelStyle.margin;
    protected int preferredRowCount = WebStyledLabelStyle.preferredRowCount;
    protected boolean ignoreColorSettings = WebStyledLabelStyle.ignoreColorSettings;
    protected float scriptFontRatio = WebStyledLabelStyle.scriptFontRatio;
    protected String truncatedTextSuffix = WebStyledLabelStyle.truncatedTextSuffix;
    protected StyledLabelPainter painter;
    protected PropertyChangeListener propertyChangeListener;
    protected String styleId = null;
    protected WebStyledLabel label;

    public static ComponentUI createUI(JComponent c) {
        return new WebStyledLabelUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.label = (WebStyledLabel)c;
        SwingUtils.setOrientation(this.label);
        this.label.setMaximumSize(null);
        StyleManager.applySkin(this.label);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebStyledLabelUI.this.updateBorder();
            }
        };
        this.label.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.label.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        StyleManager.removeSkin(this.label);
        this.label = null;
        super.uninstallUI(c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if ("styleRange".equals(e.getPropertyName()) && this.painter != null) {
            this.painter.updateTextRanges();
        }
    }

    @Override
    public String getStyleId() {
        return this.styleId;
    }

    @Override
    public void setStyleId(String id) {
        this.styleId = id;
        StyleManager.applySkin(this.label);
    }

    @Override
    public void updateBorder() {
        LafUtils.updateBorder(this.label, this.margin, null);
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public int getPreferredRowCount() {
        return this.preferredRowCount;
    }

    public void setPreferredRowCount(int rows) {
        this.preferredRowCount = rows;
        if (this.painter != null) {
            this.painter.setPreferredRowCount(rows);
        }
    }

    public boolean isIgnoreColorSettings() {
        return this.ignoreColorSettings;
    }

    public void setIgnoreColorSettings(boolean ignore) {
        this.ignoreColorSettings = ignore;
        if (this.painter != null) {
            this.painter.setIgnoreColorSettings(ignore);
        }
    }

    public float getScriptFontRatio() {
        return this.scriptFontRatio;
    }

    public void setScriptFontRatio(float ratio) {
        this.scriptFontRatio = ratio;
        if (this.painter != null) {
            this.painter.setScriptFontRatio(ratio);
        }
    }

    public String getTruncatedTextSuffix() {
        return this.truncatedTextSuffix;
    }

    public void setTruncatedTextSuffix(String suffix) {
        this.truncatedTextSuffix = suffix;
        if (this.painter != null) {
            this.painter.setTruncatedTextSuffix(suffix);
        }
    }

    public Painter getPainter() {
        return LafUtils.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        StyledLabelPainter properPainter = (StyledLabelPainter)LafUtils.getProperPainter(painter, StyledLabelPainter.class, AdaptiveStyledLabelPainter.class);
        PainterSupport.uninstallPainter(this.label, this.painter);
        StyledLabelPainter oldPainter = this.painter;
        this.painter = properPainter;
        this.applyPainterSettings(properPainter);
        PainterSupport.installPainter(this.label, properPainter);
        LafUtils.firePainterChanged(this.label, oldPainter, properPainter);
    }

    protected void applyPainterSettings(StyledLabelPainter painter) {
        if (painter != null) {
            painter.setPreferredRowCount(this.preferredRowCount);
            painter.setIgnoreColorSettings(this.ignoreColorSettings);
            painter.setScriptFontRatio(this.scriptFontRatio);
            painter.setTruncatedTextSuffix(this.truncatedTextSuffix);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, SwingUtils.size(c), c);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return LafUtils.getPreferredSize(c, this.painter);
    }
}

