/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.language;

import com.alee.laf.tree.WebTreeCellRenderer;
import com.alee.laf.tree.WebTreeElement;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.Value;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class DictionariesTreeRenderer
extends WebTreeCellRenderer {
    private static ImageIcon multidicIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/multidic.png"));
    private static ImageIcon dicIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/dic.png"));
    private static ImageIcon recordIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/record.png"));
    private static ImageIcon textIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/text.png"));
    private static ImageIcon tooltipIcon = new ImageIcon(DictionariesTreeRenderer.class.getResource("icons/tooltip.png"));

    @Override
    public WebTreeElement getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        Object val = ((DefaultMutableTreeNode)value).getUserObject();
        if (val == null) {
            this.setIcon(multidicIcon);
            this.setText("Dictionaries");
        } else if (val instanceof Dictionary) {
            Dictionary d = (Dictionary)val;
            this.setIcon(dicIcon);
            this.setText("<html><b>" + d.getPrefix() + "</b> - " + d.getName() + "</html>");
        } else if (val instanceof Record) {
            Record r = (Record)val;
            this.setIcon(recordIcon);
            this.setText(expanded ? "<html><b>" + r.getKey() + "</b>" + (r.getHotkey() != null ? " (" + r.getHotkey() + ")" : "") + "</html>" : r.toString(true));
        } else if (val instanceof Value) {
            Value v = (Value)val;
            this.setIcon(LanguageManager.getLanguageIcon(v.getLang()));
            this.setText(v.getLang() + (v.getMnemonic() != null ? " (" + v.getMnemonic() + ")" : "") + (v.getHotkey() != null ? " (" + v.getHotkey() + ")" : ""));
        } else if (val instanceof Text) {
            Text text = (Text)val;
            this.setIcon(textIcon);
            this.setText(text.getState() == null ? text.toString() : "<html><b>" + text.getState() + "</b> -> " + text.toString() + "</html>");
        } else if (val instanceof Tooltip) {
            this.setIcon(tooltipIcon);
            this.setText(val.toString());
        }
        return this;
    }
}

