/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingConstants;

public class AlignLayout
extends AbstractLayoutManager
implements SwingConstants {
    public static final String SEPARATOR = ",";
    public static final List<Integer> horizontals = Arrays.asList(2, 0, 4);
    public static final List<Integer> verticals = Arrays.asList(1, 0, 3);
    protected final Map<Component, String> constraints = new HashMap<Component, String>();
    protected int hgap = 0;
    protected int vgap = 0;
    protected boolean hfill = false;
    protected boolean vfill = false;

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public boolean isHfill() {
        return this.hfill;
    }

    public void setHfill(boolean hfill) {
        this.hfill = hfill;
    }

    public boolean isVfill() {
        return this.vfill;
    }

    public void setVfill(boolean vfill) {
        this.vfill = vfill;
    }

    @Override
    public void addComponent(Component component, Object constraints) {
        String name = (String)constraints;
        if (name != null && !name.trim().equals("")) {
            try {
                int valign;
                int halign = this.getHalign(name);
                if (!horizontals.contains(halign)) {
                    this.illegalArgument();
                }
                if (!verticals.contains(valign = this.getValign(name))) {
                    this.illegalArgument();
                }
            }
            catch (Throwable ex) {
                this.illegalArgument();
            }
        } else {
            name = "0,0";
        }
        this.constraints.put(component, name);
    }

    protected void illegalArgument() {
        throw new IllegalArgumentException("Cannot add to layout: please specify proper alignment constraints");
    }

    protected int getHalign(String name) {
        return name == null ? 0 : Integer.parseInt(name.substring(0, name.indexOf(SEPARATOR)));
    }

    protected int getValign(String name) {
        return name == null ? 0 : Integer.parseInt(name.substring(name.indexOf(SEPARATOR) + SEPARATOR.length()));
    }

    @Override
    public void removeComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension ps;
        if (parent.getComponentCount() > 1) {
            HashMap<Integer, Integer> widths = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> heights = new HashMap<Integer, Integer>();
            for (int halign : horizontals) {
                for (int valign : verticals) {
                    Dimension size = this.getSideSize(parent, halign, valign);
                    if (size == null) continue;
                    if (!this.hfill) {
                        int width = widths.containsKey(halign) ? (Integer)widths.get(halign) : 0;
                        widths.put(halign, Math.max(width, size.width));
                    }
                    if (this.vfill) continue;
                    int height = widths.containsKey(valign) ? (Integer)widths.get(valign) : 0;
                    heights.put(valign, Math.max(height, size.height));
                }
            }
            ps = new Dimension(0, 0);
            if (this.hfill) {
                ps.width = SwingUtils.maxWidth(parent.getComponents());
            } else {
                for (Integer width : widths.values()) {
                    ps.width = ps.width + (ps.width > 0 ? this.hgap + width : width);
                }
            }
            if (this.vfill) {
                ps.height = SwingUtils.maxHeight(parent.getComponents());
            } else {
                for (Integer height : heights.values()) {
                    ps.height = ps.height + (ps.height > 0 ? this.vgap + height : height);
                }
            }
        } else {
            ps = parent.getComponentCount() == 1 ? parent.getComponent(0).getPreferredSize() : new Dimension(0, 0);
        }
        Insets insets = parent.getInsets();
        ps.width += insets.left + insets.right;
        ps.height += insets.top + insets.bottom;
        return ps;
    }

    protected Dimension getSideSize(Container parent, int halign, int valign) {
        Dimension size = new Dimension(0, 0);
        for (Component component : parent.getComponents()) {
            String align = this.constraints.get(component);
            if (this.getHalign(align) != halign || this.getValign(align) != valign) continue;
            size = SwingUtils.max(size, component.getPreferredSize());
        }
        return size.width > 0 || size.height > 0 ? size : null;
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int cw = parent.getWidth() - insets.left - insets.right;
        int ch = parent.getHeight() - insets.top - insets.bottom;
        for (Component component : parent.getComponents()) {
            String align = this.constraints.get(component);
            int halign = this.getHalign(align);
            int valign = this.getValign(align);
            Dimension ps = component.getPreferredSize();
            int x = 0;
            if (this.hfill) {
                x = insets.left;
            } else {
                switch (halign) {
                    case 2: {
                        x = insets.left;
                        break;
                    }
                    case 0: {
                        x = parent.getWidth() / 2 - ps.width / 2;
                        break;
                    }
                    case 4: {
                        x = parent.getWidth() - ps.width - insets.right;
                    }
                }
            }
            int y = 0;
            if (this.vfill) {
                y = insets.top;
            } else {
                switch (valign) {
                    case 1: {
                        y = insets.top;
                        break;
                    }
                    case 0: {
                        y = parent.getHeight() / 2 - ps.height / 2;
                        break;
                    }
                    case 3: {
                        y = parent.getHeight() - ps.height - insets.bottom;
                    }
                }
            }
            component.setBounds(x, y, this.hfill ? cw : ps.width, this.vfill ? ch : ps.height);
        }
    }
}

