/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.ninepatch;

import com.alee.extended.ninepatch.NinePatchEditorPanel;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.rootpane.WebFrame;
import com.alee.managers.language.LanguageKeyListener;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.data.Value;
import com.alee.managers.settings.SettingsManager;
import com.alee.utils.ImageUtils;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NinePatchEditorDialog
extends WebFrame {
    private static final String DIALOG_TITLE_KEY = "weblaf.ex.npeditor.title";
    private NinePatchEditorPanel ninePatchEditorPanel = null;

    public NinePatchEditorDialog() {
        this(SettingsManager.get("NinePatchEditorDialog", "lastFile", (String)null));
    }

    public NinePatchEditorDialog(String path) {
        this.setIconImages(WebLookAndFeel.getImages());
        this.updateTitle();
        LanguageManager.addLanguageKeyListener(DIALOG_TITLE_KEY, new LanguageKeyListener(){

            @Override
            public void languageKeyUpdated(String key, Value value) {
                NinePatchEditorDialog.this.updateTitle();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.ninePatchEditorPanel = new NinePatchEditorPanel();
        this.ninePatchEditorPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NinePatchEditorDialog.this.updateTitle();
            }
        });
        this.getContentPane().add(this.ninePatchEditorPanel);
        if (path != null) {
            File file = new File(path);
            if (file.exists()) {
                if (file.isFile()) {
                    this.ninePatchEditorPanel.openImage(file);
                } else {
                    this.ninePatchEditorPanel.setSelectedDirectory(file);
                }
            } else {
                this.openDefault();
            }
        } else {
            this.openDefault();
        }
        Rectangle bounds = SettingsManager.get("NinePatchEditorDialog", "bounds", (Rectangle)null);
        if (bounds == null) {
            this.pack();
            this.setLocationRelativeTo(null);
        } else {
            this.setBounds(bounds);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (NinePatchEditorDialog.this.ninePatchEditorPanel.continueAfterSave()) {
                    SettingsManager.set("NinePatchEditorDialog", "lastFile", NinePatchEditorDialog.this.ninePatchEditorPanel.getImageSrc());
                    SettingsManager.set("NinePatchEditorDialog", "bounds", NinePatchEditorDialog.this.getBounds());
                    System.exit(0);
                }
            }
        });
    }

    private void openDefault() {
        this.ninePatchEditorPanel.setNinePatchImage(ImageUtils.getBufferedImage(NinePatchEditorDialog.class.getResource("icons/example.png")));
    }

    private void updateTitle() {
        String imageSrc = this.ninePatchEditorPanel != null ? this.ninePatchEditorPanel.getImageSrc() : null;
        this.setTitle(LanguageManager.get(DIALOG_TITLE_KEY) + (imageSrc != null ? " - [" + imageSrc + "]" : ""));
    }

    public NinePatchEditorPanel getNinePatchEditorPanel() {
        return this.ninePatchEditorPanel;
    }

    public BufferedImage getNinePatchImage() {
        return this.ninePatchEditorPanel.getNinePatchImage();
    }

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebLookAndFeel.install();
                NinePatchEditorDialog npe = args != null && args.length > 0 ? new NinePatchEditorDialog(args[0]) : new NinePatchEditorDialog();
                npe.setVisible(true);
            }
        });
    }
}

