/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.laf.tree.TreeUtils;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeModel;
import com.alee.managers.log.Log;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeTransferHandler<N extends UniqueNode, T extends WebTree<N>, M extends WebTreeModel<N>>
extends TransferHandler {
    protected DataFlavor nodesFlavor;
    protected DataFlavor[] flavors = new DataFlavor[1];
    protected boolean optimizeDraggedNodes = true;
    protected boolean expandSingleNode = true;
    protected boolean expandMultiplyNodes = false;
    protected List<N> draggedNodes;
    protected Map<String, List<Integer>> draggedNodeIndices;

    public AbstractTreeTransferHandler() {
        this.flavors[0] = this.nodesFlavor = this.createNodesFlavor();
    }

    protected DataFlavor createNodesFlavor() {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref;class=\"" + List.class.getName() + "\"");
        }
        catch (ClassNotFoundException e) {
            Log.error((Object)this, (Throwable)e);
            return null;
        }
    }

    public boolean isOptimizeDraggedNodes() {
        return this.optimizeDraggedNodes;
    }

    public void setOptimizeDraggedNodes(boolean optimize) {
        this.optimizeDraggedNodes = optimize;
    }

    public boolean isExpandSingleNode() {
        return this.expandSingleNode;
    }

    public void setExpandSingleNode(boolean expand) {
        this.expandSingleNode = expand;
    }

    public boolean isExpandMultiplyNodes() {
        return this.expandMultiplyNodes;
    }

    public void setExpandMultiplyNodes(boolean expand) {
        this.expandMultiplyNodes = expand;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        WebTree tree = (WebTree)c;
        List nodes = tree.getSelectedNodes();
        if (!nodes.isEmpty()) {
            if (nodes.contains(tree.getRootNode())) {
                return null;
            }
            if (this.optimizeDraggedNodes) {
                TreeUtils.optimizeNodes(nodes);
            }
            if (!this.canBeDragged(nodes)) {
                return null;
            }
            ArrayList<UniqueNode> copies = new ArrayList<UniqueNode>();
            for (UniqueNode node : nodes) {
                copies.add(this.copy(node));
            }
            this.draggedNodes = nodes;
            this.draggedNodeIndices = new HashMap<String, List<Integer>>(1);
            for (UniqueNode node : this.draggedNodes) {
                UniqueNode parent = node.getParent();
                List<Integer> indices = this.draggedNodeIndices.get(parent.getId());
                if (indices == null) {
                    indices = new ArrayList<Integer>(1);
                    this.draggedNodeIndices.put(parent.getId(), indices);
                }
                indices.add(parent.getIndex(node));
            }
            return new NodesTransferable(copies);
        }
        return null;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        if (!support.isDataFlavorSupported(this.nodesFlavor)) {
            return false;
        }
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        TreePath path = dl.getPath();
        if (path == null) {
            return false;
        }
        try {
            UniqueNode target = (UniqueNode)path.getLastPathComponent();
            if (!this.canDropTo(target)) {
                return false;
            }
            if (this.isMoveAction(support.getDropAction()) && this.draggedNodes != null) {
                for (UniqueNode node : this.draggedNodes) {
                    if (node != target && !node.isNodeDescendant(target)) continue;
                    return false;
                }
            }
            List nodes = (List)support.getTransferable().getTransferData(this.nodesFlavor);
            int index = dl.getChildIndex();
            boolean canBeDropped = this.canBeDropped(nodes, target, index);
            support.setShowDropLocation(canBeDropped);
            return canBeDropped;
        }
        catch (UnsupportedFlavorException ufe) {
            Log.warn(this, "UnsupportedFlavor: " + ufe.getMessage());
            return false;
        }
        catch (IOException ioe) {
            Log.error((Object)this, "I/O exception: " + ioe.getMessage());
            return false;
        }
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        List nodes;
        try {
            nodes = (List)support.getTransferable().getTransferData(this.nodesFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
            Log.warn(this, "UnsupportedFlavor: " + ufe.getMessage());
            return false;
        }
        catch (IOException ioe) {
            Log.error((Object)this, "I/O exception: " + ioe.getMessage());
            return false;
        }
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        int dropIndex = dl.getChildIndex();
        TreePath dest = dl.getPath();
        UniqueNode parent = (UniqueNode)dest.getLastPathComponent();
        WebTree tree = (WebTree)support.getComponent();
        WebTreeModel model = (WebTreeModel)tree.getModel();
        return this.prepareDropOperation(support, nodes, dropIndex, parent, tree, model);
    }

    protected abstract boolean prepareDropOperation(TransferHandler.TransferSupport var1, List<N> var2, int var3, N var4, T var5, M var6);

    protected abstract boolean performDropOperation(List<N> var1, N var2, T var3, M var4, int var5);

    protected int getAdjustedDropIndex(int dropIndex, int dropAction, N parent) {
        int adjustedDropIndex;
        int n = adjustedDropIndex = dropIndex == -1 ? ((DefaultMutableTreeNode)parent).getChildCount() : dropIndex;
        if (this.isMoveAction(dropAction) && this.draggedNodeIndices != null && this.draggedNodeIndices.containsKey(((UniqueNode)parent).getId())) {
            int initialIndex = adjustedDropIndex;
            for (Integer index : this.draggedNodeIndices.get(((UniqueNode)parent).getId())) {
                if (index >= initialIndex) continue;
                --adjustedDropIndex;
            }
        }
        return adjustedDropIndex;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (this.isMoveAction(action)) {
            WebTree tree = (WebTree)source;
            this.removeTreeNodes(tree, this.draggedNodes);
            this.draggedNodes = null;
        }
    }

    protected boolean isMoveAction(int action) {
        return (action & 2) == 2;
    }

    protected abstract boolean canBeDragged(List<N> var1);

    protected boolean canDropTo(N dropLocation) {
        return dropLocation != null;
    }

    protected abstract boolean canBeDropped(List<N> var1, N var2, int var3);

    protected abstract N copy(N var1);

    protected abstract void removeTreeNodes(T var1, List<N> var2);

    public abstract void nodesDropped(List<N> var1, N var2, T var3, M var4, int var5);

    protected <O> List<O> collect(List<N> nodes) {
        ArrayList<Object> objects = new ArrayList<Object>(nodes.size());
        for (UniqueNode node : nodes) {
            objects.add(node.getUserObject());
        }
        return objects;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public class NodesTransferable
    implements Transferable,
    Serializable {
        protected final List<N> nodes;

        public NodesTransferable(List<N> nodes) {
            this.nodes = nodes;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.nodes;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return AbstractTreeTransferHandler.this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return AbstractTreeTransferHandler.this.nodesFlavor.equals(flavor);
        }
    }
}

