/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.utils.FileUtils;
import java.io.File;

public class FileTreeNode
extends AsyncUniqueNode {
    protected File file;
    protected String name = null;

    public FileTreeNode(File file) {
        this.file = file;
    }

    public FileTreeNode(File file, String name) {
        this.file = file;
        this.name = name;
    }

    @Override
    public String getId() {
        return this.file != null ? this.file.getAbsolutePath() : "File.tree.root";
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public FileTreeNode getParent() {
        return (FileTreeNode)super.getParent();
    }

    @Override
    public FileTreeNode getChildAt(int index) {
        return (FileTreeNode)super.getChildAt(index);
    }

    public int indexOfFileChild(File file) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!FileUtils.equals(this.getChildAt(i).getFile(), file)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        return this.name != null ? this.name : (this.file != null ? this.file.getName() : "root");
    }
}

