/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree.sample;

import com.alee.extended.tree.WebAsyncTreeCellRenderer;
import com.alee.extended.tree.sample.SampleNode;
import com.alee.laf.tree.WebTreeElement;
import com.alee.laf.tree.WebTreeUI;
import javax.swing.ImageIcon;
import javax.swing.JTree;

public class SampleTreeCellRenderer
extends WebAsyncTreeCellRenderer {
    @Override
    public WebTreeElement getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        if (value instanceof SampleNode) {
            SampleNode node = (SampleNode)value;
            if (!node.isLoading()) {
                ImageIcon icon;
                switch (node.getType()) {
                    case root: {
                        icon = WebTreeUI.ROOT_ICON;
                        break;
                    }
                    case folder: {
                        icon = expanded ? WebTreeUI.OPEN_ICON : WebTreeUI.CLOSED_ICON;
                        break;
                    }
                    case leaf: {
                        icon = WebTreeUI.LEAF_ICON;
                        break;
                    }
                    default: {
                        icon = null;
                    }
                }
                this.setIcon(node.isFailed() ? SampleTreeCellRenderer.getFailedStateIcon(icon) : icon);
            }
            this.setText(node.getName());
        }
        return this;
    }
}

