/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.laf.menu.WebPopupMenuSeparatorStyle;
import com.alee.utils.GraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuSeparatorUI;

public class WebPopupMenuSeparatorUI
extends BasicPopupMenuSeparatorUI {
    protected Color color = WebPopupMenuSeparatorStyle.color;
    protected Stroke stroke = WebPopupMenuSeparatorStyle.stroke;
    protected int spacing = WebPopupMenuSeparatorStyle.spacing;
    protected int sideSpacing = WebPopupMenuSeparatorStyle.sideSpacing;

    public static ComponentUI createUI(JComponent c) {
        return new WebPopupMenuSeparatorUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        LookAndFeel.installProperty(c, "opaque", Boolean.FALSE);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int getSideSpacing() {
        return this.sideSpacing;
    }

    public void setSideSpacing(int sideSpacing) {
        this.sideSpacing = sideSpacing;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias(g2d);
        Stroke stroke = GraphicsUtils.setupStroke(g2d, this.stroke);
        g.setColor(this.color);
        g.drawLine(this.sideSpacing, c.getHeight() / 2, c.getWidth() - this.sideSpacing - 1, c.getHeight() / 2);
        GraphicsUtils.restoreStroke(g2d, stroke);
        GraphicsUtils.restoreAntialias(g2d, aa);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(0, this.spacing * 2 + 1);
    }
}

