/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.slider;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.global.StyleConstants;
import com.alee.laf.label.WebLabelStyle;
import com.alee.laf.slider.WebSliderStyle;
import com.alee.utils.ColorUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.BorderMethods;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class WebSliderUI
extends BasicSliderUI
implements BorderMethods {
    public static final int MAX_DARKNESS = 5;
    protected Color trackBgTop = WebSliderStyle.trackBgTop;
    protected Color trackBgBottom = WebSliderStyle.trackBgBottom;
    protected int trackHeight = WebSliderStyle.trackHeight;
    protected int trackRound = WebSliderStyle.trackRound;
    protected int trackShadeWidth = WebSliderStyle.trackShadeWidth;
    protected boolean drawProgress = WebSliderStyle.drawProgress;
    protected Color progressTrackBgTop = WebSliderStyle.progressTrackBgTop;
    protected Color progressTrackBgBottom = WebSliderStyle.progressTrackBgBottom;
    protected Color progressBorderColor = WebSliderStyle.progressBorderColor;
    protected int progressRound = WebSliderStyle.progressRound;
    protected int progressShadeWidth = WebSliderStyle.progressShadeWidth;
    protected boolean drawThumb = WebSliderStyle.drawThumb;
    protected Color thumbBgTop = WebSliderStyle.thumbBgTop;
    protected Color thumbBgBottom = WebSliderStyle.thumbBgBottom;
    protected int thumbWidth = WebSliderStyle.thumbWidth;
    protected int thumbHeight = WebSliderStyle.thumbHeight;
    protected int thumbRound = WebSliderStyle.thumbRound;
    protected int thumbShadeWidth = WebSliderStyle.thumbShadeWidth;
    protected boolean angledThumb = WebSliderStyle.angledThumb;
    protected boolean sharpThumbAngle = WebSliderStyle.sharpThumbAngle;
    protected int thumbAngleLength = WebSliderStyle.thumbAngleLength;
    protected boolean animated = WebSliderStyle.animated;
    protected boolean rolloverDarkBorderOnly = WebSliderStyle.rolloverDarkBorderOnly;
    protected Insets margin = WebLabelStyle.margin;
    protected Painter painter = WebLabelStyle.painter;
    protected boolean invertMouseWheelDirection = WebSliderStyle.invertMouseWheelDirection;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseWheelListener mouseWheelListener;
    protected ChangeListener changeListener;
    protected MouseAdapter mouseAdapter;
    protected boolean rollover = false;
    protected int rolloverDarkness = 0;
    protected WebTimer rolloverTimer;

    public WebSliderUI(JSlider b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WebSliderUI((JSlider)c);
    }

    @Override
    public void installUI(final JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.slider);
        LookAndFeel.installProperty(this.slider, "opaque", Boolean.FALSE);
        this.slider.setForeground(StyleConstants.textColor);
        PainterSupport.installPainter(this.slider, this.painter);
        this.updateBorder();
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebSliderUI.this.updateBorder();
            }
        };
        this.slider.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
        this.mouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int v = WebSliderUI.this.slider.getValue() - e.getWheelRotation();
                WebSliderUI.this.slider.setValue(Math.min(Math.max(WebSliderUI.this.slider.getMinimum(), v), WebSliderUI.this.slider.getMaximum()));
            }
        };
        this.slider.addMouseWheelListener(this.mouseWheelListener);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WebSliderUI.this.slider.repaint();
            }
        };
        this.slider.addChangeListener(this.changeListener);
        this.rolloverTimer = new WebTimer("WebProgressBarUI.animator", 40L, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebSliderUI.this.rollover && WebSliderUI.this.rolloverDarkness < 5) {
                    ++WebSliderUI.this.rolloverDarkness;
                    WebSliderUI.this.slider.repaint();
                } else if (!WebSliderUI.this.rollover && WebSliderUI.this.rolloverDarkness > 0) {
                    --WebSliderUI.this.rolloverDarkness;
                    WebSliderUI.this.slider.repaint();
                } else {
                    WebSliderUI.this.rolloverTimer.stop();
                }
            }
        });
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                WebSliderUI.this.slider.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                WebSliderUI.this.slider.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                WebSliderUI.this.slider.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                WebSliderUI.this.rollover = true;
                if (WebSliderUI.this.isAnimated() && c.isEnabled()) {
                    WebSliderUI.this.rolloverTimer.start();
                } else {
                    WebSliderUI.this.rolloverDarkness = 5;
                    WebSliderUI.this.slider.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WebSliderUI.this.rollover = false;
                if (WebSliderUI.this.isAnimated() && c.isEnabled()) {
                    WebSliderUI.this.rolloverTimer.start();
                } else {
                    WebSliderUI.this.rolloverDarkness = 0;
                    WebSliderUI.this.slider.repaint();
                }
            }
        };
        this.slider.addMouseListener(this.mouseAdapter);
        this.slider.addMouseMotionListener(this.mouseAdapter);
    }

    @Override
    public void uninstallUI(JComponent c) {
        PainterSupport.uninstallPainter(this.slider, this.painter);
        this.slider.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        this.slider.removeMouseWheelListener(this.mouseWheelListener);
        this.slider.removeChangeListener(this.changeListener);
        this.slider.removeMouseListener(this.mouseAdapter);
        this.slider.removeMouseMotionListener(this.mouseAdapter);
        super.uninstallUI(c);
    }

    @Override
    public void updateBorder() {
        if (this.slider != null) {
            if (SwingUtils.isPreserveBorders(this.slider)) {
                return;
            }
            boolean ltr = this.slider.getComponentOrientation().isLeftToRight();
            Insets m = new Insets(this.margin.top, ltr ? this.margin.left : this.margin.right, this.margin.bottom, ltr ? this.margin.right : this.margin.left);
            if (this.painter != null) {
                Insets pi = this.painter.getMargin(this.slider);
                m.top += pi.top;
                m.bottom += pi.bottom;
                m.left = m.left + (ltr ? pi.left : pi.right);
                m.right = m.right + (ltr ? pi.right : pi.left);
            }
            this.slider.setBorder(LafUtils.createWebBorder(m));
        }
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean isRolloverDarkBorderOnly() {
        return this.rolloverDarkBorderOnly;
    }

    public void setRolloverDarkBorderOnly(boolean rolloverDarkBorderOnly) {
        this.rolloverDarkBorderOnly = rolloverDarkBorderOnly;
    }

    public boolean isInvertMouseWheelDirection() {
        return this.invertMouseWheelDirection;
    }

    public void setInvertMouseWheelDirection(boolean invert) {
        this.invertMouseWheelDirection = invert;
    }

    public Color getTrackBgTop() {
        return this.trackBgTop;
    }

    public void setTrackBgTop(Color trackBgTop) {
        this.trackBgTop = trackBgTop;
    }

    public Color getTrackBgBottom() {
        return this.trackBgBottom;
    }

    public void setTrackBgBottom(Color trackBgBottom) {
        this.trackBgBottom = trackBgBottom;
    }

    public int getTrackHeight() {
        return this.trackHeight;
    }

    public void setTrackHeight(int trackHeight) {
        this.trackHeight = trackHeight;
    }

    public int getTrackRound() {
        return this.trackRound;
    }

    public void setTrackRound(int trackRound) {
        this.trackRound = trackRound;
    }

    public int getTrackShadeWidth() {
        return this.trackShadeWidth;
    }

    public void setTrackShadeWidth(int trackShadeWidth) {
        this.trackShadeWidth = trackShadeWidth;
    }

    public boolean isDrawProgress() {
        return this.drawProgress;
    }

    public void setDrawProgress(boolean drawProgress) {
        this.drawProgress = drawProgress;
    }

    public Color getProgressTrackBgTop() {
        return this.progressTrackBgTop;
    }

    public void setProgressTrackBgTop(Color progressTrackBgTop) {
        this.progressTrackBgTop = progressTrackBgTop;
    }

    public Color getProgressTrackBgBottom() {
        return this.progressTrackBgBottom;
    }

    public void setProgressTrackBgBottom(Color progressTrackBgBottom) {
        this.progressTrackBgBottom = progressTrackBgBottom;
    }

    public Color getProgressBorderColor() {
        return this.progressBorderColor;
    }

    public void setProgressBorderColor(Color progressBorderColor) {
        this.progressBorderColor = progressBorderColor;
    }

    public int getProgressRound() {
        return this.progressRound;
    }

    public void setProgressRound(int progressRound) {
        this.progressRound = progressRound;
    }

    public int getProgressShadeWidth() {
        return this.progressShadeWidth;
    }

    public void setProgressShadeWidth(int progressShadeWidth) {
        this.progressShadeWidth = progressShadeWidth;
    }

    public boolean isDrawThumb() {
        return this.drawThumb;
    }

    public void setDrawThumb(boolean drawThumb) {
        this.drawThumb = drawThumb;
    }

    public Color getThumbBgTop() {
        return this.thumbBgTop;
    }

    public void setThumbBgTop(Color thumbBgTop) {
        this.thumbBgTop = thumbBgTop;
    }

    public Color getThumbBgBottom() {
        return this.thumbBgBottom;
    }

    public void setThumbBgBottom(Color thumbBgBottom) {
        this.thumbBgBottom = thumbBgBottom;
    }

    public int getThumbWidth() {
        return this.thumbWidth;
    }

    public void setThumbWidth(int thumbWidth) {
        this.thumbWidth = thumbWidth;
    }

    public int getThumbHeight() {
        return this.thumbHeight;
    }

    public void setThumbHeight(int thumbHeight) {
        this.thumbHeight = thumbHeight;
    }

    public int getThumbRound() {
        return this.thumbRound;
    }

    public void setThumbRound(int thumbRound) {
        this.thumbRound = thumbRound;
    }

    public int getThumbShadeWidth() {
        return this.thumbShadeWidth;
    }

    public void setThumbShadeWidth(int thumbShadeWidth) {
        this.thumbShadeWidth = thumbShadeWidth;
    }

    public boolean isAngledThumb() {
        return this.angledThumb;
    }

    public void setAngledThumb(boolean angledThumb) {
        this.angledThumb = angledThumb;
    }

    public boolean isSharpThumbAngle() {
        return this.sharpThumbAngle;
    }

    public void setSharpThumbAngle(boolean sharpThumbAngle) {
        this.sharpThumbAngle = sharpThumbAngle;
    }

    public int getThumbAngleLength() {
        return this.thumbAngleLength;
    }

    public void setThumbAngleLength(int thumbAngleLength) {
        this.thumbAngleLength = thumbAngleLength;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        PainterSupport.uninstallPainter(this.slider, this.painter);
        this.painter = painter;
        PainterSupport.installPainter(this.slider, this.painter);
        this.updateBorder();
    }

    @Override
    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 0) {
            return new Dimension(this.thumbWidth, this.thumbHeight);
        }
        return new Dimension(this.thumbHeight, this.thumbWidth);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, SwingUtils.size(c), c);
        }
        super.paint(g, c);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    public void paintThumb(Graphics g) {
        if (this.drawThumb) {
            Graphics2D g2d = (Graphics2D)g;
            Object aa = GraphicsUtils.setupAntialias(g2d);
            Shape ts = this.getThumbShape();
            if (this.slider.getOrientation() == 0) {
                g2d.setPaint(new GradientPaint(0.0f, this.thumbRect.y, this.thumbBgTop, 0.0f, this.thumbRect.y + this.thumbRect.height, this.thumbBgBottom));
            } else {
                g2d.setPaint(new GradientPaint(this.thumbRect.x, 0.0f, this.thumbBgTop, this.thumbRect.x + this.thumbRect.width, 0.0f, this.thumbBgBottom));
            }
            g2d.fill(ts);
            g2d.setPaint(this.slider.isEnabled() ? StyleConstants.darkBorderColor : StyleConstants.disabledBorderColor);
            g2d.draw(ts);
            GraphicsUtils.restoreAntialias(g2d, aa);
        }
    }

    protected Color getBorderColor() {
        return ColorUtils.getIntermediateColor(StyleConstants.borderColor, StyleConstants.darkBorderColor, this.getProgress());
    }

    protected float getProgress() {
        return (float)this.rolloverDarkness / 5.0f;
    }

    protected Shape getThumbShape() {
        if (this.angledThumb && (this.slider.getPaintLabels() || this.slider.getPaintTicks())) {
            if (this.slider.getOrientation() == 0) {
                GeneralPath gp = new GeneralPath(0);
                gp.moveTo(this.thumbRect.x, this.thumbRect.y + this.thumbRound);
                gp.quadTo(this.thumbRect.x, this.thumbRect.y, this.thumbRect.x + this.thumbRound, this.thumbRect.y);
                gp.lineTo(this.thumbRect.x + this.thumbRect.width - this.thumbRound, this.thumbRect.y);
                gp.quadTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y, this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRound);
                gp.lineTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength);
                if (this.sharpThumbAngle) {
                    gp.lineTo(this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height);
                    gp.lineTo(this.thumbRect.x, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength);
                } else {
                    gp.quadTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength / 2, this.thumbRect.x + this.thumbRect.width / 2, this.thumbRect.y + this.thumbRect.height);
                    gp.quadTo(this.thumbRect.x, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength / 2, this.thumbRect.x, this.thumbRect.y + this.thumbRect.height - this.thumbAngleLength);
                }
                gp.closePath();
                return gp;
            }
            GeneralPath gp = new GeneralPath(0);
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                gp.moveTo(this.thumbRect.x, this.thumbRect.y + this.thumbRound);
                gp.quadTo(this.thumbRect.x, this.thumbRect.y, this.thumbRect.x + this.thumbRound, this.thumbRect.y);
                gp.lineTo(this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength, this.thumbRect.y);
                if (this.sharpThumbAngle) {
                    gp.lineTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height / 2);
                    gp.lineTo(this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength, this.thumbRect.y + this.thumbRect.height);
                } else {
                    gp.quadTo(this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength / 2, this.thumbRect.y, this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height / 2);
                    gp.quadTo(this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength / 2, this.thumbRect.y + this.thumbRect.height, this.thumbRect.x + this.thumbRect.width - this.thumbAngleLength, this.thumbRect.y + this.thumbRect.height);
                }
                gp.lineTo(this.thumbRect.x + this.thumbRound, this.thumbRect.y + this.thumbRect.height);
                gp.quadTo(this.thumbRect.x, this.thumbRect.y + this.thumbRect.height, this.thumbRect.x, this.thumbRect.y + this.thumbRect.height - this.thumbRound);
            } else {
                gp.moveTo(this.thumbRect.x + this.thumbRect.width - this.thumbRound, this.thumbRect.y);
                gp.quadTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y, this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRound);
                gp.lineTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height - this.thumbRound);
                gp.quadTo(this.thumbRect.x + this.thumbRect.width, this.thumbRect.y + this.thumbRect.height, this.thumbRect.x + this.thumbRect.width - this.thumbRound, this.thumbRect.y + this.thumbRect.height);
                gp.lineTo(this.thumbRect.x + this.thumbAngleLength, this.thumbRect.y + this.thumbRect.height);
                if (this.sharpThumbAngle) {
                    gp.lineTo(this.thumbRect.x, this.thumbRect.y + this.thumbRect.height / 2);
                    gp.lineTo(this.thumbRect.x + this.thumbAngleLength, this.thumbRect.y);
                } else {
                    gp.quadTo(this.thumbRect.x + this.thumbAngleLength / 2, this.thumbRect.y + this.thumbRect.height, this.thumbRect.x, this.thumbRect.y + this.thumbRect.height / 2);
                    gp.quadTo(this.thumbRect.x + this.thumbAngleLength / 2, this.thumbRect.y, this.thumbRect.x + this.thumbAngleLength, this.thumbRect.y);
                }
            }
            gp.closePath();
            return gp;
        }
        return new RoundRectangle2D.Double(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, this.thumbRound * 2, this.thumbRound * 2);
    }

    @Override
    public void paintTrack(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias(g2d);
        Shape ss = this.getTrackShape();
        if (this.slider.isEnabled()) {
            GraphicsUtils.drawShade(g2d, ss, this.slider.isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, this.trackShadeWidth);
        }
        if (this.slider.getOrientation() == 0) {
            g2d.setPaint(new GradientPaint(0.0f, this.trackRect.y, this.trackBgTop, 0.0f, this.trackRect.y + this.trackRect.height, this.trackBgBottom));
        } else {
            g2d.setPaint(new GradientPaint(this.trackRect.x, 0.0f, this.trackBgTop, this.trackRect.x + this.trackRect.width, 0.0f, this.trackBgBottom));
        }
        g2d.fill(ss);
        if (this.drawProgress) {
            Shape ps = this.getProgressShape();
            if (this.slider.isEnabled()) {
                GraphicsUtils.drawShade(g2d, ps, StyleConstants.shadeColor, this.progressShadeWidth);
            }
            Rectangle bounds = ss.getBounds();
            if (this.slider.getOrientation() == 0) {
                g2d.setPaint(new GradientPaint(0.0f, bounds.y + this.progressShadeWidth, this.progressTrackBgTop, 0.0f, bounds.y + bounds.height - this.progressShadeWidth, this.progressTrackBgBottom));
            } else {
                g2d.setPaint(new GradientPaint(bounds.x + this.progressShadeWidth, 0.0f, this.progressTrackBgTop, bounds.x + bounds.width - this.progressShadeWidth, 0.0f, this.progressTrackBgBottom));
            }
            g2d.fill(ps);
            g2d.setPaint(this.slider.isEnabled() ? this.progressBorderColor : StyleConstants.disabledBorderColor);
            g2d.draw(ps);
        }
        g2d.setPaint(this.slider.isEnabled() ? (this.rolloverDarkBorderOnly && !this.isDragging() ? this.getBorderColor() : StyleConstants.darkBorderColor) : StyleConstants.disabledBorderColor);
        g2d.draw(ss);
        GraphicsUtils.restoreAntialias(g2d, aa);
    }

    protected Shape getTrackShape() {
        if (this.trackRound > 0) {
            if (this.slider.getOrientation() == 0) {
                return new RoundRectangle2D.Double(this.trackRect.x - this.trackRound, this.trackRect.y + this.trackRect.height / 2 - this.trackHeight / 2, this.trackRect.width + this.trackRound * 2 - 1, this.trackHeight, this.trackRound * 2, this.trackRound * 2);
            }
            return new RoundRectangle2D.Double(this.trackRect.x + this.trackRect.width / 2 - this.trackHeight / 2, this.trackRect.y - this.trackRound, this.trackHeight, this.trackRect.height + this.trackRound * 2 - 1, this.trackRound * 2, this.trackRound * 2);
        }
        if (this.slider.getOrientation() == 0) {
            return new Rectangle2D.Double(this.trackRect.x, this.trackRect.y + this.trackRect.height / 2 - this.trackHeight / 2, this.trackRect.width - 1, this.trackHeight);
        }
        return new Rectangle2D.Double(this.trackRect.x + this.trackRect.width / 2 - this.trackHeight / 2, this.trackRect.y, this.trackHeight, this.trackRect.height - 1);
    }

    protected Shape getProgressShape() {
        if (this.trackRound > 0) {
            if (this.slider.getOrientation() == 0) {
                int w;
                int x;
                if (this.slider.getComponentOrientation().isLeftToRight()) {
                    x = this.trackRect.x - this.trackRound + this.progressShadeWidth;
                    w = this.thumbRect.x + this.thumbRect.width / 2 + this.progressRound - x;
                } else {
                    x = this.thumbRect.x + this.thumbRect.width / 2 - this.progressRound;
                    w = this.trackRect.x + this.trackRect.width + this.trackRound - this.progressShadeWidth - 1 - x;
                }
                return new RoundRectangle2D.Double(x, this.trackRect.y + this.trackRect.height / 2 - this.trackHeight / 2 + this.progressShadeWidth, w, this.trackHeight - this.progressShadeWidth * 2, this.progressRound * 2, this.progressRound * 2);
            }
            int y = this.thumbRect.y + this.thumbRect.height / 2;
            int h = this.trackRect.y + this.trackRect.height + this.trackRound - this.progressShadeWidth - y - 1;
            return new RoundRectangle2D.Double(this.trackRect.x + this.progressShadeWidth + this.trackRect.width / 2 - this.trackHeight / 2, y, this.trackHeight - this.progressShadeWidth * 2, h, this.progressRound * 2, this.progressRound * 2);
        }
        if (this.slider.getOrientation() == 0) {
            int w;
            int x;
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                x = this.trackRect.x + this.progressShadeWidth;
                w = this.thumbRect.x + this.thumbRect.width / 2 - x;
            } else {
                x = this.thumbRect.x + this.thumbRect.width / 2;
                w = this.trackRect.x + this.trackRect.width - this.progressShadeWidth - 1 - x;
            }
            return new Rectangle2D.Double(x, this.trackRect.y + this.trackRect.height / 2 - this.trackHeight / 2 + this.progressShadeWidth, w, this.trackHeight - this.progressShadeWidth * 2);
        }
        int y = this.trackRect.y + this.progressShadeWidth;
        int h = this.thumbRect.y + this.thumbRect.height / 2 - y;
        return new Rectangle2D.Double(this.trackRect.x + this.progressShadeWidth + this.trackRect.width / 2 - this.trackHeight / 2, y, this.trackHeight - this.progressShadeWidth * 2, h);
    }
}

