/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.laf.tree.WebTreeUI;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreePath;

public class TreeRolloverSelectionAdapter
implements MouseMotionListener {
    private final JTree tree;

    public TreeRolloverSelectionAdapter(JTree tree) {
        this.tree = tree;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.tree.isEnabled()) {
            TreeUI treeUI = this.tree.getUI();
            if (treeUI instanceof WebTreeUI) {
                int row = ((WebTreeUI)treeUI).getRowForPoint(e.getPoint());
                if (row != -1) {
                    this.tree.setSelectionRow(row);
                } else {
                    this.tree.clearSelection();
                }
            } else {
                TreePath treePath = this.tree.getPathForLocation(e.getX(), e.getY());
                if (treePath != null) {
                    this.tree.setSelectionPath(treePath);
                } else {
                    this.tree.clearSelection();
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public static TreeRolloverSelectionAdapter install(JTree tree) {
        TreeRolloverSelectionAdapter.uninstall(tree);
        TreeRolloverSelectionAdapter adapter = new TreeRolloverSelectionAdapter(tree);
        tree.addMouseMotionListener(adapter);
        return adapter;
    }

    public static void uninstall(JTree tree) {
        for (MouseMotionListener listener : tree.getMouseMotionListeners()) {
            if (!(listener instanceof TreeRolloverSelectionAdapter)) continue;
            tree.removeMouseMotionListener(listener);
        }
    }

    public static boolean isInstalled(JTree tree) {
        for (MouseMotionListener listener : tree.getMouseMotionListeners()) {
            if (!(listener instanceof TreeRolloverSelectionAdapter)) continue;
            return true;
        }
        return false;
    }
}

