/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.drag;

import com.alee.managers.drag.DragViewHandler;
import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.managers.log.Log;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class DragManager {
    protected static Map<DataFlavor, DragViewHandler> viewHandlers;
    protected static WebGlassPane glassPane;
    protected static Object data;
    protected static BufferedImage view;
    protected static Component dropLocation;
    protected static DragViewHandler dragViewHandler;
    protected static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            viewHandlers = new HashMap<DataFlavor, DragViewHandler>();
            DragSourceAdapter dsa = new DragSourceAdapter(){

                @Override
                public void dragEnter(DragSourceDragEvent dsde) {
                    this.actualDragEnter(dsde);
                }

                protected void actualDragEnter(DragSourceDragEvent dsde) {
                    DataFlavor[] flavors;
                    DragSourceContext dsc = dsde.getDragSourceContext();
                    dropLocation = dsc.getComponent();
                    Transferable transferable = dsc.getTransferable();
                    for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
                        if (!viewHandlers.containsKey(flavor)) continue;
                        try {
                            data = transferable.getTransferData(flavor);
                            dragViewHandler = viewHandlers.get(flavor);
                            view = dragViewHandler.getView(data, dsde);
                            glassPane = GlassPaneManager.getGlassPane(dsc.getComponent());
                            glassPane.setPaintedImage(view, this.getLocation(glassPane, dsde));
                            break;
                        }
                        catch (Throwable e) {
                            Log.error(DragManager.class, e);
                        }
                    }
                }

                @Override
                public void dragMouseMoved(DragSourceDragEvent dsde) {
                    DragSourceContext dsc = dsde.getDragSourceContext();
                    if (dsc.getComponent() != dropLocation) {
                        this.actualDragEnter(dsde);
                    }
                    if (view != null) {
                        WebGlassPane gp = GlassPaneManager.getGlassPane(dsde.getDragSourceContext().getComponent());
                        if (gp != glassPane) {
                            glassPane.clearPaintedImage();
                            glassPane = gp;
                        }
                        glassPane.setPaintedImage(view, this.getLocation(glassPane, dsde));
                    }
                }

                public Point getLocation(WebGlassPane gp, DragSourceDragEvent dsde) {
                    Point mp = SwingUtils.getMousePoint(gp);
                    Point vp = dragViewHandler.getViewRelativeLocation(data, dsde);
                    return new Point(mp.x + vp.x, mp.y + vp.y);
                }

                @Override
                public void dragDropEnd(DragSourceDropEvent dsde) {
                    dropLocation = null;
                    if (view != null) {
                        dragViewHandler.dragEnded(data, dsde);
                        glassPane.clearPaintedImage();
                        glassPane = null;
                        data = null;
                        view = null;
                        dragViewHandler = null;
                    }
                }
            };
            DragSource.getDefaultDragSource().addDragSourceListener(dsa);
            DragSource.getDefaultDragSource().addDragSourceMotionListener(dsa);
        }
    }

    public static void registerViewHandler(DragViewHandler dragViewHandler) {
        viewHandlers.put(dragViewHandler.getObjectFlavor(), dragViewHandler);
    }

    public static void unregisterViewHandler(DragViewHandler dragViewHandler) {
        viewHandlers.remove(dragViewHandler.getObjectFlavor());
    }

    static {
        initialized = false;
    }
}

