/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.managers.language.LanguageConstants;
import com.alee.managers.language.LanguageKeyListener;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageUpdaterComparator;
import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.SwingTooltipLanguageSupport;
import com.alee.managers.language.TooltipLanguageSupport;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.LanguageInfo;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.TooltipType;
import com.alee.managers.language.data.TooltipWay;
import com.alee.managers.language.data.Value;
import com.alee.managers.language.updaters.AbstractButtonLU;
import com.alee.managers.language.updaters.JFileChooserLU;
import com.alee.managers.language.updaters.JInternalFrameLU;
import com.alee.managers.language.updaters.JLabelLU;
import com.alee.managers.language.updaters.JProgressBarLU;
import com.alee.managers.language.updaters.JRootPaneLU;
import com.alee.managers.language.updaters.JTabbedPaneLU;
import com.alee.managers.language.updaters.JTextComponentLU;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.MapUtils;
import com.alee.utils.NetUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.DataProvider;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class LanguageManager
implements LanguageConstants {
    public static final ImageIcon other = new ImageIcon(LanguageManager.class.getResource("icons/lang/other.png"));
    public static final String COMPONENT_UPDATER_KEY = "language.updater";
    public static final String COMPONENT_LANGUAGE_LISTENER_KEY = "language.listener";
    protected static final Object supportedLanguagesLock = new Object();
    protected static final List<String> supportedLanguages = CollectionUtils.copy("en", "ru", "pl", "ar", "es", "fr", "pt", "de", "it", "tr");
    protected static String DEFAULT;
    protected static String language;
    protected static TooltipType defaultTooltipType;
    protected static final Object languageListenersLock;
    protected static final List<LanguageListener> languageListeners;
    protected static final Map<JComponent, WeakReference<LanguageListener>> componentLanguageListeners;
    protected static final Object languageKeyListenersLock;
    protected static final Map<String, List<LanguageKeyListener>> languageKeyListeners;
    protected static Dictionary globalDictionary;
    protected static final Map<String, Value> globalCache;
    protected static final List<Dictionary> dictionaries;
    protected static final Map<String, Dictionary> dictionariesCache;
    protected static final Object componentsLock;
    protected static final Map<JComponent, String> components;
    protected static final Map<JComponent, Object[]> componentsData;
    protected static final Map<Component, String> componentKeysCache;
    protected static final Map<Component, AncestorListener> componentsListeners;
    protected static final Object languageContainersLock;
    protected static final Map<Container, String> languageContainers;
    protected static final Object updatersLock;
    protected static final LanguageUpdaterComparator languageUpdaterComparator;
    protected static final List<LanguageUpdater> updaters;
    protected static final Map<JComponent, WeakReference<LanguageUpdater>> customUpdaters;
    protected static final Map<Class, LanguageUpdater> updatersCache;
    protected static final Map<String, ImageIcon> languageIcons;
    protected static TooltipLanguageSupport tooltipLanguageSupport;
    protected static boolean checkComponentsTextForTranslations;
    protected static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            language = supportedLanguages.contains(DEFAULT) ? DEFAULT : "en";
            LanguageManager.updateLocale();
            globalDictionary = new Dictionary();
            XmlUtils.processAnnotations(Dictionary.class);
            XmlUtils.processAnnotations(LanguageInfo.class);
            XmlUtils.processAnnotations(Record.class);
            XmlUtils.processAnnotations(Value.class);
            XmlUtils.processAnnotations(Text.class);
            XmlUtils.processAnnotations(Tooltip.class);
            XmlUtils.processAnnotations(TooltipType.class);
            XmlUtils.processAnnotations(TooltipWay.class);
            LanguageManager.registerLanguageUpdater(new JLabelLU());
            LanguageManager.registerLanguageUpdater(new AbstractButtonLU());
            LanguageManager.registerLanguageUpdater(new JTextComponentLU());
            LanguageManager.registerLanguageUpdater(new JTabbedPaneLU());
            LanguageManager.registerLanguageUpdater(new JProgressBarLU());
            LanguageManager.registerLanguageUpdater(new JFileChooserLU());
            LanguageManager.registerLanguageUpdater(new JRootPaneLU());
            LanguageManager.registerLanguageUpdater(new JInternalFrameLU());
            LanguageManager.setTooltipLanguageSupport(new SwingTooltipLanguageSupport());
            LanguageManager.addLanguageListener(new LanguageListener(){

                @Override
                public void languageChanged(String oldLang, String newLang) {
                    this.updateAll();
                }

                @Override
                public void dictionaryAdded(Dictionary dictionary) {
                    this.updateSmart(dictionary);
                }

                @Override
                public void dictionaryRemoved(Dictionary dictionary) {
                    this.updateSmart(dictionary);
                }

                @Override
                public void dictionariesCleared() {
                    this.updateAll();
                }

                private void updateAll() {
                    if (languageKeyListeners.size() > 0) {
                        LanguageManager.fireAllLanguageKeysUpdated();
                    }
                    LanguageManager.updateComponents();
                }

                private void updateSmart(Dictionary dictionary) {
                    List<String> relevantKeys = LanguageUtils.gatherKeys(dictionary);
                    if (languageKeyListeners.size() > 0) {
                        for (String key : relevantKeys) {
                            LanguageManager.fireLanguageKeyUpdated(key);
                        }
                    }
                    LanguageManager.updateComponents(relevantKeys);
                }
            });
            LanguageManager.loadDefaultDictionary();
        }
    }

    public static void loadDefaultDictionary() {
        LanguageManager.addDictionary(LanguageManager.class, "resources/language.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSupportedLanguages() {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            return CollectionUtils.copy(supportedLanguages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSupportedLanguages(Collection<String> supportedLanguages) {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            LanguageManager.supportedLanguages.clear();
            LanguageManager.supportedLanguages.addAll(supportedLanguages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSupportedLanguages(String ... supportedLanguages) {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            LanguageManager.supportedLanguages.clear();
            Collections.addAll(LanguageManager.supportedLanguages, supportedLanguages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSupportedLanguage(String language) {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            supportedLanguages.add(language);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSupportedLanguage(String language, Dictionary dictionary) {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            supportedLanguages.add(language);
            LanguageManager.addDictionary(dictionary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSupportedLanguage(String language) {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            supportedLanguages.remove(language);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSupportedLanguages() {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            supportedLanguages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerComponent(JComponent component, String key, Object ... data) {
        LanguageManager.unregisterComponent(component);
        if (data != null && data.length == 0) {
            data = null;
        }
        Object object = componentsLock;
        synchronized (object) {
            components.put(component, key);
            if (data != null) {
                componentsData.put(component, data);
            }
        }
        LanguageManager.updateComponent(component, key, new Object[0]);
        object = componentsLock;
        synchronized (object) {
            final WeakReference<JComponent> ref = new WeakReference<JComponent>(component);
            AncestorAdapter listener = new AncestorAdapter(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    LanguageManager.updateComponentKey((JComponent)ref.get());
                }
            };
            component.addAncestorListener(listener);
            componentsListeners.put(component, listener);
        }
    }

    public static void updateComponentsTree(JComponent component) {
        LanguageManager.updateComponentKey(component);
        if (component instanceof Container) {
            for (Component child : component.getComponents()) {
                if (!(child instanceof JComponent)) continue;
                LanguageManager.updateComponentsTree((JComponent)child);
            }
        }
    }

    protected static void updateComponentKey(JComponent component) {
        String key = LanguageManager.getComponentKey(component);
        if (key != null) {
            String oldKey = componentKeysCache.get(component);
            String newKey = LanguageManager.combineWithContainerKeysImpl(component, key);
            if (oldKey == null || !CompareUtils.equals(oldKey, newKey)) {
                LanguageManager.updateComponent(component, key, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterComponent(JComponent component) {
        Object object = componentsLock;
        synchronized (object) {
            if (components.containsKey(component)) {
                components.remove(component);
                componentsData.remove(component);
                componentKeysCache.remove(component);
                AncestorListener listener = componentsListeners.get(component);
                component.removeAncestorListener(listener);
                componentsListeners.remove(component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRegisteredComponent(JComponent component) {
        Object object = componentsLock;
        synchronized (object) {
            return components.containsKey(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getComponentKey(JComponent component) {
        Object object = componentsLock;
        synchronized (object) {
            return components.get(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLanguageUpdater(LanguageUpdater updater) {
        Object object = updatersLock;
        synchronized (object) {
            Iterator<LanguageUpdater> iterator = updaters.iterator();
            while (iterator.hasNext()) {
                if (updater.getComponentClass() != iterator.next().getComponentClass()) continue;
                iterator.remove();
            }
            updaters.add(updater);
            updatersCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLanguageUpdater(LanguageUpdater updater) {
        Object object = updatersLock;
        synchronized (object) {
            updaters.remove(updater);
            updatersCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLanguageUpdater(JComponent component, LanguageUpdater updater) {
        Object object = updatersLock;
        synchronized (object) {
            component.putClientProperty(COMPONENT_UPDATER_KEY, updater);
            customUpdaters.put(component, new WeakReference<LanguageUpdater>(updater));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLanguageUpdater(JComponent component) {
        Object object = updatersLock;
        synchronized (object) {
            component.putClientProperty(COMPONENT_UPDATER_KEY, null);
            customUpdaters.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LanguageUpdater getLanguageUpdater(JComponent component) {
        Object object = updatersLock;
        synchronized (object) {
            LanguageUpdater customUpdater;
            WeakReference<LanguageUpdater> updaterReference = customUpdaters.get(component);
            LanguageUpdater languageUpdater = customUpdater = updaterReference != null ? (LanguageUpdater)updaterReference.get() : null;
            if (customUpdater != null) {
                return customUpdater;
            }
            LanguageUpdater updater = updatersCache.get(component.getClass());
            if (updater != null) {
                return updater;
            }
            ArrayList<LanguageUpdater> foundUpdaters = new ArrayList<LanguageUpdater>();
            for (LanguageUpdater lu : updaters) {
                if (!lu.getComponentClass().isInstance(component)) continue;
                foundUpdaters.add(lu);
            }
            if (foundUpdaters.size() == 1) {
                updater = (LanguageUpdater)foundUpdaters.get(0);
            } else if (foundUpdaters.size() > 1) {
                Collections.sort(foundUpdaters, languageUpdaterComparator);
                updater = (LanguageUpdater)foundUpdaters.get(0);
            } else {
                throw new RuntimeException("Unable to find LanguageUpdater for component: " + component);
            }
            updatersCache.put(component.getClass(), updater);
            return updater;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateComponents() {
        Object object = componentsLock;
        synchronized (object) {
            for (Map.Entry<JComponent, String> entry : components.entrySet()) {
                LanguageManager.updateComponent(entry.getKey(), entry.getValue(), new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateComponents(List<String> keys) {
        Object object = componentsLock;
        synchronized (object) {
            for (Map.Entry<JComponent, String> entry : components.entrySet()) {
                if (!keys.contains(entry.getValue())) continue;
                LanguageManager.updateComponent(entry.getKey(), entry.getValue(), new Object[0]);
            }
        }
    }

    public static void updateComponent(JComponent component, Object ... data) {
        String key = components.get(component);
        if (key != null) {
            LanguageManager.updateComponent(component, key, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateComponent(JComponent component, String key, Object ... data) {
        Object[] actualData;
        if (data != null && data.length == 0) {
            data = null;
        }
        Value value = LanguageManager.getNotNullValue(component, key);
        Object object = componentsLock;
        synchronized (object) {
            if (data != null) {
                componentsData.put(component, data);
                actualData = data;
            } else {
                actualData = componentsData.get(component);
            }
        }
        LanguageUpdater updater = LanguageManager.getLanguageUpdater(component);
        if (updater != null) {
            updater.update(component, key, value, LanguageManager.parseData(actualData));
        }
        if (tooltipLanguageSupport != null) {
            tooltipLanguageSupport.setupTooltip(component, value);
        }
    }

    public static Object[] parseData(Object ... data) {
        if (data != null) {
            Object[] finalData = new Object[data.length];
            for (int i = 0; i < data.length; ++i) {
                Object object = data[i];
                finalData[i] = object != null && object instanceof DataProvider ? ((DataProvider)object).provide() : object;
            }
            return finalData;
        }
        return null;
    }

    public static ImageIcon getLanguageIcon(String language) {
        ImageIcon icon;
        if (languageIcons.containsKey(language)) {
            return languageIcons.get(language);
        }
        try {
            URL res = LanguageManager.class.getResource("icons/lang/" + language + ".png");
            icon = new ImageIcon(res);
        }
        catch (Throwable e) {
            icon = other;
        }
        languageIcons.put(language, icon);
        return icon;
    }

    public static ImageIcon setLanguageIcon(String language, ImageIcon icon) {
        return languageIcons.put(language, icon);
    }

    public static String getLanguageTitle(String language) {
        LanguageInfo info = globalDictionary.getLanguageInfo(language);
        return info != null ? info.getTitle() : null;
    }

    public static TooltipLanguageSupport getTooltipLanguageSupport() {
        return tooltipLanguageSupport;
    }

    public static void setTooltipLanguageSupport(TooltipLanguageSupport support) {
        tooltipLanguageSupport = support;
    }

    public static TooltipType getDefaultTooltipType() {
        return defaultTooltipType;
    }

    public static void setDefaultTooltipType(TooltipType defaultTooltipType) {
        LanguageManager.defaultTooltipType = defaultTooltipType;
    }

    public static String getDefaultLanguage() {
        return DEFAULT;
    }

    public static void setDefaultLanguage(String lang) {
        DEFAULT = lang;
    }

    public static String getLanguage() {
        return language;
    }

    public static boolean isCurrentLanguage(String language) {
        return LanguageManager.language.equals(language);
    }

    public static void setLanguage(String language) {
        if (initialized) {
            if (language == null || LanguageManager.isCurrentLanguage(language)) {
                return;
            }
            String oldLanguage = LanguageManager.language;
            LanguageManager.language = language;
            LanguageManager.updateLocale();
            LanguageManager.rebuildCache();
            LanguageManager.fireLanguageChanged(oldLanguage, language);
        } else {
            DEFAULT = language;
        }
    }

    public static void switchLanguage() {
        if (supportedLanguages.size() > 0) {
            int current = supportedLanguages.indexOf(LanguageManager.getLanguage());
            LanguageManager.setLanguage(supportedLanguages.get(current == -1 || current == supportedLanguages.size() - 1 ? 0 : current + 1));
        }
    }

    protected static void updateLocale() {
        Locale.setDefault(LanguageManager.getLocale(language));
    }

    public static Locale getLocale(String language) {
        Locale detected = null;
        for (Locale locale : Locale.getAvailableLocales()) {
            if (!locale.getLanguage().equals(language)) continue;
            detected = locale;
        }
        return detected != null ? detected : new Locale(language);
    }

    public static Dictionary getGlobalDictionary() {
        return globalDictionary;
    }

    public static List<Dictionary> getDictionaries() {
        return CollectionUtils.copy(dictionaries);
    }

    public static Dictionary addDictionary(Class nearClass, String resource) {
        String cacheKey = LanguageManager.getDictionaryCacheKey(nearClass, resource);
        if (dictionariesCache.containsKey(cacheKey)) {
            return dictionariesCache.get(cacheKey);
        }
        return LanguageManager.addDictionary(cacheKey, LanguageManager.loadDictionary(nearClass, resource));
    }

    public static String getDictionaryCacheKey(Class nearClass, String resource) {
        return NetUtils.getAddress(nearClass.getResource(resource));
    }

    public static Dictionary loadDictionary(Class nearClass, String resource) {
        return LanguageManager.loadDictionary(nearClass.getResource(resource));
    }

    public static Dictionary addDictionary(URL url) {
        String cacheKey = LanguageManager.getDictionaryCacheKey(url);
        if (dictionariesCache.containsKey(cacheKey)) {
            return dictionariesCache.get(cacheKey);
        }
        return LanguageManager.addDictionary(cacheKey, LanguageManager.loadDictionary(url));
    }

    public static String getDictionaryCacheKey(URL url) {
        return NetUtils.getAddress(url);
    }

    public static Dictionary loadDictionary(URL url) {
        return (Dictionary)XmlUtils.fromXML(url);
    }

    public static Dictionary addDictionary(String path) {
        String cacheKey = LanguageManager.getDictionaryCacheKey(path);
        if (dictionariesCache.containsKey(cacheKey)) {
            return dictionariesCache.get(cacheKey);
        }
        return LanguageManager.addDictionary(cacheKey, LanguageManager.loadDictionary(path));
    }

    public static String getDictionaryCacheKey(String path) {
        return path;
    }

    public static Dictionary loadDictionary(String path) {
        return LanguageManager.loadDictionary(new File(path));
    }

    public static Dictionary addDictionary(File file) {
        String cacheKey = LanguageManager.getDictionaryCacheKey(file);
        if (dictionariesCache.containsKey(cacheKey)) {
            return dictionariesCache.get(cacheKey);
        }
        return LanguageManager.addDictionary(cacheKey, LanguageManager.loadDictionary(file));
    }

    public static String getDictionaryCacheKey(File file) {
        return file.getAbsolutePath();
    }

    public static Dictionary loadDictionary(File file) {
        return (Dictionary)XmlUtils.fromXML(file);
    }

    public static Dictionary addDictionary(Dictionary dictionary) {
        return LanguageManager.addDictionary(null, dictionary);
    }

    public static Dictionary addDictionary(String cacheKey, Dictionary dictionary) {
        if (dictionariesCache.containsKey(cacheKey)) {
            return dictionariesCache.get(cacheKey);
        }
        if (LanguageManager.isDictionaryAdded(dictionary)) {
            LanguageManager.removeDictionary(dictionary);
        }
        dictionaries.add(dictionary);
        LanguageUtils.mergeDictionary(dictionary, globalDictionary);
        LanguageManager.updateCache(dictionary);
        if (cacheKey != null) {
            dictionariesCache.put(cacheKey, dictionary);
        }
        LanguageManager.fireDictionaryAdded(dictionary);
        return dictionary;
    }

    public static Dictionary removeDictionary(String id) {
        return LanguageManager.removeDictionary(LanguageManager.getDictionary(id));
    }

    public static Dictionary removeDictionary(Dictionary dictionary) {
        if (dictionary != null && LanguageManager.isDictionaryAdded(dictionary)) {
            globalDictionary.clear();
            dictionaries.remove(dictionary);
            MapUtils.removeAllValues(dictionariesCache, dictionary);
            for (Dictionary d : dictionaries) {
                LanguageUtils.mergeDictionary(d, globalDictionary);
            }
            LanguageManager.rebuildCache();
            LanguageManager.fireDictionaryRemoved(dictionary);
            return dictionary;
        }
        return null;
    }

    public static boolean isDictionaryAdded(Dictionary dictionary) {
        return LanguageManager.isDictionaryAdded(dictionary.getId());
    }

    public static boolean isDictionaryAdded(String id) {
        for (Dictionary dictionary : dictionaries) {
            if (!dictionary.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static Dictionary getDictionary(String id) {
        for (Dictionary dictionary : dictionaries) {
            if (!dictionary.getId().equals(id)) continue;
            return dictionary;
        }
        return null;
    }

    public static void clearDictionaries() {
        globalDictionary.clear();
        dictionaries.clear();
        LanguageManager.clearCache();
        LanguageManager.fireDictionariesCleared();
    }

    public static List<String> getSupportedLanguages(String dictionaryId) {
        return LanguageManager.getSupportedLanguages(LanguageManager.getDictionary(dictionaryId));
    }

    public static List<String> getSupportedLanguages(Dictionary dictionary) {
        return dictionary == null ? Collections.EMPTY_LIST : dictionary.getSupportedLanguages();
    }

    public static String get(String key) {
        Value value = LanguageManager.getValue(key);
        return value != null ? value.getText() : key;
    }

    public static String get(String key, Object ... data) {
        String text = LanguageManager.get(key);
        Object[] actualData = LanguageManager.parseData(data);
        return String.format(text, actualData);
    }

    public static Character getMnemonic(String key) {
        Value value = LanguageManager.getValue(key);
        return value != null ? value.getMnemonic() : null;
    }

    public static Value getValue(String key) {
        return globalCache != null ? globalCache.get(key) : null;
    }

    public static Value getNotNullValue(String key) {
        Value value = LanguageManager.getValue(key);
        if (value != null) {
            return value;
        }
        Value tmpValue = new Value(LanguageManager.getLanguage(), key);
        globalCache.put(key, tmpValue);
        return tmpValue;
    }

    public static boolean contains(String key) {
        return globalCache.containsKey(key);
    }

    public static String get(JComponent component, String key) {
        return LanguageManager.get(LanguageManager.combineWithContainerKeys(component, key));
    }

    public static Character getMnemonic(JComponent component, String key) {
        return LanguageManager.getMnemonic(LanguageManager.combineWithContainerKeys(component, key));
    }

    public static Value getValue(JComponent component, String key) {
        return LanguageManager.getValue(LanguageManager.combineWithContainerKeys(component, key));
    }

    public static Value getNotNullValue(JComponent component, String key) {
        return LanguageManager.getNotNullValue(LanguageManager.combineWithContainerKeys(component, key));
    }

    public static Value getValue(JComponent component, String key, String additionalKey) {
        return LanguageManager.getValue(LanguageManager.combineWithContainerKeys(component, key) + "." + additionalKey);
    }

    public static Value getNotNullValue(JComponent component, String key, String additionalKey) {
        return LanguageManager.getNotNullValue(LanguageManager.combineWithContainerKeys(component, key) + "." + additionalKey);
    }

    public static String combineWithContainerKeys(JComponent component, String key) {
        String cachedKey = componentKeysCache.get(component);
        return cachedKey != null ? cachedKey : LanguageManager.combineWithContainerKeysImpl(component, key);
    }

    protected static String combineWithContainerKeysImpl(JComponent component, String key) {
        StringBuilder sb = new StringBuilder(key);
        if (component != null) {
            for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
                String containerKey = LanguageManager.getLanguageContainerKey(parent);
                if (containerKey == null) continue;
                sb.insert(0, containerKey + ".");
            }
        }
        String cachedKey = sb.toString();
        componentKeysCache.put(component, cachedKey);
        return cachedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLanguageContainer(Container container, String key) {
        Object object = languageContainersLock;
        synchronized (object) {
            languageContainers.put(container, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLanguageContainer(Container container) {
        Object object = languageContainersLock;
        synchronized (object) {
            languageContainers.remove(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLanguageContainerKey(Container container) {
        Object object = languageContainersLock;
        synchronized (object) {
            return languageContainers.get(container);
        }
    }

    protected static void rebuildCache() {
        LanguageManager.clearCache();
        LanguageManager.updateCache(globalDictionary);
    }

    protected static void clearCache() {
        globalCache.clear();
    }

    protected static void updateCache(Dictionary dictionary) {
        LanguageManager.updateCache(dictionary.getPrefix(), dictionary);
    }

    protected static void updateCache(String prefix, Dictionary dictionary) {
        String string = prefix = prefix != null && !prefix.equals("") ? prefix + "." : "";
        if (dictionary.getRecords() != null) {
            for (Record record : dictionary.getRecords()) {
                Value value = record.getValue(language);
                if (value != null && value.getHotkey() == null && record.getHotkey() != null) {
                    value.setHotkey(record.getHotkey());
                }
                globalCache.put(prefix + record.getKey(), value);
            }
        }
        if (dictionary.getSubdictionaries() != null) {
            for (Dictionary subDictionary : dictionary.getSubdictionaries()) {
                String sp = subDictionary.getPrefix();
                String subPrefix = prefix + (sp != null && !sp.equals("") ? sp : "");
                LanguageManager.updateCache(subPrefix, subDictionary);
            }
        }
    }

    public static boolean isCheckComponentsTextForTranslations() {
        return checkComponentsTextForTranslations;
    }

    public static void setCheckComponentsTextForTranslations(boolean check) {
        checkComponentsTextForTranslations = check;
    }

    public static String getDefaultLanguageKey() {
        String systemLang = LanguageManager.getSystemLanguageKey();
        return supportedLanguages.contains(systemLang) ? systemLang : "en";
    }

    public static String getSystemLanguageKey() {
        return System.getProperty("user.language");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LanguageListener> getLanguageListeners() {
        Object object = languageListenersLock;
        synchronized (object) {
            return CollectionUtils.copy(languageListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLanguageListener(LanguageListener listener) {
        Object object = languageListenersLock;
        synchronized (object) {
            languageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLanguageListener(LanguageListener listener) {
        Object object = languageListenersLock;
        synchronized (object) {
            languageListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Component, LanguageListener> getComponentLanguageListeners() {
        Object object = languageListenersLock;
        synchronized (object) {
            HashMap<Component, LanguageListener> listeners = new HashMap<Component, LanguageListener>(componentLanguageListeners.size());
            for (Map.Entry<JComponent, WeakReference<LanguageListener>> entry : componentLanguageListeners.entrySet()) {
                WeakReference<LanguageListener> listenerReference;
                LanguageListener listener;
                JComponent component = entry.getKey();
                if (component == null || (listener = (listenerReference = entry.getValue()) != null ? (LanguageListener)listenerReference.get() : null) == null) continue;
                listeners.put(component, listener);
            }
            return listeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLanguageListener(JComponent component, LanguageListener listener) {
        Object object = languageListenersLock;
        synchronized (object) {
            component.putClientProperty(COMPONENT_LANGUAGE_LISTENER_KEY, listener);
            componentLanguageListeners.put(component, new WeakReference<LanguageListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLanguageListener(JComponent component) {
        Object object = languageListenersLock;
        synchronized (object) {
            component.putClientProperty(COMPONENT_LANGUAGE_LISTENER_KEY, null);
            componentLanguageListeners.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireLanguageChanged(String oldLang, String newLang) {
        Object object = languageListenersLock;
        synchronized (object) {
            for (LanguageListener languageListener : languageListeners) {
                languageListener.languageChanged(oldLang, newLang);
            }
            for (Map.Entry entry : componentLanguageListeners.entrySet()) {
                WeakReference listenerReference;
                LanguageListener listener;
                JComponent key = (JComponent)entry.getKey();
                if (key == null || (listener = (listenerReference = (WeakReference)entry.getValue()) != null ? (LanguageListener)listenerReference.get() : null) == null) continue;
                listener.languageChanged(oldLang, newLang);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireDictionaryAdded(Dictionary dictionary) {
        Object object = languageListenersLock;
        synchronized (object) {
            for (LanguageListener languageListener : languageListeners) {
                languageListener.dictionaryAdded(dictionary);
            }
            for (Map.Entry entry : componentLanguageListeners.entrySet()) {
                WeakReference listenerReference;
                LanguageListener listener;
                JComponent key = (JComponent)entry.getKey();
                if (key == null || (listener = (listenerReference = (WeakReference)entry.getValue()) != null ? (LanguageListener)listenerReference.get() : null) == null) continue;
                listener.dictionaryAdded(dictionary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireDictionaryRemoved(Dictionary dictionary) {
        Object object = languageListenersLock;
        synchronized (object) {
            for (LanguageListener languageListener : languageListeners) {
                languageListener.dictionaryRemoved(dictionary);
            }
            for (Map.Entry entry : componentLanguageListeners.entrySet()) {
                WeakReference listenerReference;
                LanguageListener listener;
                JComponent key = (JComponent)entry.getKey();
                if (key == null || (listener = (listenerReference = (WeakReference)entry.getValue()) != null ? (LanguageListener)listenerReference.get() : null) == null) continue;
                listener.dictionaryRemoved(dictionary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireDictionariesCleared() {
        Object object = languageListenersLock;
        synchronized (object) {
            for (LanguageListener languageListener : languageListeners) {
                languageListener.dictionariesCleared();
            }
            for (Map.Entry entry : componentLanguageListeners.entrySet()) {
                WeakReference listenerReference;
                LanguageListener listener;
                JComponent key = (JComponent)entry.getKey();
                if (key == null || (listener = (listenerReference = (WeakReference)entry.getValue()) != null ? (LanguageListener)listenerReference.get() : null) == null) continue;
                listener.dictionariesCleared();
            }
        }
    }

    public static Map<String, List<LanguageKeyListener>> getLanguageKeyListeners() {
        return languageKeyListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLanguageKeyListener(String key, LanguageKeyListener listener) {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            List<LanguageKeyListener> listeners = languageKeyListeners.get(key);
            if (listeners == null) {
                listeners = new ArrayList<LanguageKeyListener>();
                languageKeyListeners.put(key, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLanguageKeyListener(LanguageKeyListener listener) {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            for (Map.Entry<String, List<LanguageKeyListener>> entry : languageKeyListeners.entrySet()) {
                entry.getValue().remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLanguageKeyListeners(String key) {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            languageKeyListeners.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireLanguageKeyUpdated(String key) {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            List<LanguageKeyListener> listeners = languageKeyListeners.get(key);
            if (listeners != null) {
                Value value = LanguageManager.getValue(key);
                for (LanguageKeyListener listener : CollectionUtils.copy(listeners)) {
                    listener.languageKeyUpdated(key, value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireAllLanguageKeysUpdated() {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            for (Map.Entry<String, List<LanguageKeyListener>> entry : languageKeyListeners.entrySet()) {
                Value value = LanguageManager.getValue(entry.getKey());
                for (LanguageKeyListener listener : CollectionUtils.copy((Collection)entry.getValue())) {
                    listener.languageKeyUpdated(entry.getKey(), value);
                }
            }
        }
    }

    static {
        language = DEFAULT = LanguageManager.getDefaultLanguageKey();
        defaultTooltipType = TooltipType.weblaf;
        languageListenersLock = new Object();
        languageListeners = new ArrayList<LanguageListener>();
        componentLanguageListeners = new WeakHashMap<JComponent, WeakReference<LanguageListener>>();
        languageKeyListenersLock = new Object();
        languageKeyListeners = new HashMap<String, List<LanguageKeyListener>>();
        globalCache = new HashMap<String, Value>();
        dictionaries = new ArrayList<Dictionary>();
        dictionariesCache = new HashMap<String, Dictionary>();
        componentsLock = new Object();
        components = new WeakHashMap<JComponent, String>();
        componentsData = new WeakHashMap<JComponent, Object[]>();
        componentKeysCache = new WeakHashMap<Component, String>();
        componentsListeners = new WeakHashMap<Component, AncestorListener>();
        languageContainersLock = new Object();
        languageContainers = new WeakHashMap<Container, String>();
        updatersLock = new Object();
        languageUpdaterComparator = new LanguageUpdaterComparator();
        updaters = new ArrayList<LanguageUpdater>();
        customUpdaters = new WeakHashMap<JComponent, WeakReference<LanguageUpdater>>();
        updatersCache = new HashMap<Class, LanguageUpdater>();
        languageIcons = new HashMap<String, ImageIcon>();
        checkComponentsTextForTranslations = true;
        initialized = false;
    }
}

