/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.plugin.data;

import com.alee.managers.plugin.data.PluginDependency;
import com.alee.managers.plugin.data.PluginLibrary;
import com.alee.managers.plugin.data.PluginVersion;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.List;

@XStreamAlias(value="PluginInformation")
public class PluginInformation
implements Serializable {
    private String id;
    private String type;
    private String types;
    private boolean disableable;
    private String mainClass;
    private String title;
    private String description;
    private PluginVersion version;
    @XStreamImplicit
    private List<PluginLibrary> libraries;
    @XStreamImplicit
    private List<PluginDependency> dependencies;

    public PluginInformation() {
    }

    public PluginInformation(String id, boolean disableable, String mainClass, String title, String description) {
        this(id, null, null, disableable, mainClass, title, description, PluginVersion.DEFAULT, null, null);
    }

    public PluginInformation(String id, boolean disableable, String mainClass, String title, String description, PluginVersion version) {
        this(id, null, null, disableable, mainClass, title, description, version, null, null);
    }

    public PluginInformation(String id, String type, String types, boolean disableable, String mainClass, String title, String description, PluginVersion version, List<PluginLibrary> libraries) {
        this(id, type, types, disableable, mainClass, title, description, version, libraries, null);
    }

    public PluginInformation(String id, String type, String types, boolean disableable, String mainClass, String title, String description, PluginVersion version, List<PluginLibrary> libraries, List<PluginDependency> dependencies) {
        this.id = id;
        this.type = type;
        this.types = types;
        this.disableable = disableable;
        this.mainClass = mainClass;
        this.title = title;
        this.description = description;
        this.version = version;
        this.libraries = libraries;
        this.dependencies = dependencies;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypes() {
        return this.types;
    }

    public List<String> getTypesList() {
        return TextUtils.stringToList(this.types, ",");
    }

    public void setTypes(String types) {
        this.types = types;
    }

    public void setTypes(List<String> types) {
        this.types = TextUtils.listToString(types, ",");
    }

    public boolean isDisableable() {
        return this.disableable;
    }

    public void setDisableable(boolean disableable) {
        this.disableable = disableable;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PluginVersion getVersion() {
        return this.version;
    }

    public void setVersion(PluginVersion version) {
        this.version = version;
    }

    public List<PluginLibrary> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<PluginLibrary> libraries) {
        this.libraries = libraries;
    }

    public boolean hasLibraries() {
        return this.libraries != null && this.libraries.size() > 0;
    }

    public int getLibrariesCount() {
        return this.libraries != null && this.libraries.size() > 0 ? this.libraries.size() : 0;
    }

    public List<PluginDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<PluginDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public boolean hasDependencies() {
        return this.dependencies != null && this.dependencies.size() > 0;
    }

    public int getDependencieCount() {
        return this.dependencies != null && this.dependencies.size() > 0 ? this.dependencies.size() : 0;
    }

    public String toString() {
        return this.title + " " + this.version;
    }
}

