/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import com.alee.managers.settings.processors.AbstractButtonSettingsProcessor;
import com.alee.managers.settings.processors.JComboBoxSettingsProcessor;
import com.alee.managers.settings.processors.JPasswordFieldSettingsProcessor;
import com.alee.managers.settings.processors.JRootPaneSettingsProcessor;
import com.alee.managers.settings.processors.JScrollBarSettingsProcessor;
import com.alee.managers.settings.processors.JSliderSettingsProcessor;
import com.alee.managers.settings.processors.JTabbedPaneSettingsProcessor;
import com.alee.managers.settings.processors.JTextComponentSettingsProcessor;
import com.alee.utils.ReflectUtils;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.text.JTextComponent;

public class ComponentSettingsManager {
    public static final String COMPONENT_SETTINGS_PROCESSOR_KEY = "settings.processor";
    protected static final Map<Class, Class> settingsProcessorClasses = new LinkedHashMap<Class, Class>();
    protected static final Map<JComponent, WeakReference<SettingsProcessor>> settingsProcessors = new WeakHashMap<JComponent, WeakReference<SettingsProcessor>>();
    protected static boolean throwExceptions = true;
    protected static boolean initialized = false;

    public static void initializeManager() {
        if (!initialized) {
            initialized = true;
            ComponentSettingsManager.registerSettingsProcessor(AbstractButton.class, AbstractButtonSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JComboBox.class, JComboBoxSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JSlider.class, JSliderSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JPasswordField.class, JPasswordFieldSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JTextComponent.class, JTextComponentSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JScrollBar.class, JScrollBarSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JTabbedPane.class, JTabbedPaneSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JRootPane.class, JRootPaneSettingsProcessor.class);
        }
    }

    public static boolean isThrowExceptions() {
        return throwExceptions;
    }

    public static void setThrowExceptions(boolean throwExceptions) {
        ComponentSettingsManager.throwExceptions = throwExceptions;
    }

    public static boolean isComponentSupported(JComponent component) {
        return ComponentSettingsManager.isComponentSupported(component.getClass());
    }

    public static boolean isComponentSupported(Class<? extends JComponent> componentType) {
        return ComponentSettingsManager.findSuitableSettingsProcessor(componentType) != null;
    }

    public static <T extends SettingsProcessor> void registerSettingsProcessor(Class<? extends JComponent> componentType, Class<T> settingsProcessor) {
        settingsProcessorClasses.put(componentType, settingsProcessor);
    }

    protected static Class findSuitableSettingsProcessor(Class componentType) {
        for (Class type : settingsProcessorClasses.keySet()) {
            if (!ReflectUtils.isAssignable(type, componentType)) continue;
            return settingsProcessorClasses.get(type);
        }
        return null;
    }

    protected static SettingsProcessor createSettingsProcessor(SettingsProcessorData data) {
        Class settingsProcessorClass = ComponentSettingsManager.findSuitableSettingsProcessor(data.getComponent().getClass());
        if (settingsProcessorClass != null) {
            try {
                return (SettingsProcessor)ReflectUtils.createInstance(settingsProcessorClass, data);
            }
            catch (Throwable e) {
                if (throwExceptions) {
                    throw new RuntimeException("Cannot instantiate SettingsProcessor class: " + settingsProcessorClass.getCanonicalName() + ".", e);
                }
                return null;
            }
        }
        return null;
    }

    public static void registerComponent(SettingsProcessorData data) {
        SettingsProcessor settingsProcessor = ComponentSettingsManager.createSettingsProcessor(data);
        if (settingsProcessor != null) {
            ComponentSettingsManager.registerComponent(data.getComponent(), settingsProcessor);
        } else if (throwExceptions) {
            throw new RuntimeException("Component type " + data.getComponent().getClass().getCanonicalName() + " is not supported.");
        }
    }

    public static void registerComponent(JComponent component, SettingsProcessor settingsProcessor) {
        ComponentSettingsManager.unregisterComponent(component);
        component.putClientProperty(COMPONENT_SETTINGS_PROCESSOR_KEY, settingsProcessor);
        settingsProcessors.put(component, new WeakReference<SettingsProcessor>(settingsProcessor));
    }

    public static void loadSettings(JComponent component) {
        SettingsProcessor settingsProcessor;
        WeakReference<SettingsProcessor> reference = settingsProcessors.get(component);
        SettingsProcessor settingsProcessor2 = settingsProcessor = reference != null ? (SettingsProcessor)reference.get() : null;
        if (settingsProcessor != null) {
            settingsProcessor.load();
        } else if (throwExceptions) {
            throw new RuntimeException("Component " + component + " was not registered.");
        }
    }

    public static void saveSettings() {
        for (Map.Entry<JComponent, WeakReference<SettingsProcessor>> entry : settingsProcessors.entrySet()) {
            ComponentSettingsManager.saveSettings(entry.getKey());
        }
    }

    public static void saveSettings(JComponent component) {
        SettingsProcessor settingsProcessor;
        WeakReference<SettingsProcessor> reference = settingsProcessors.get(component);
        SettingsProcessor settingsProcessor2 = settingsProcessor = reference != null ? (SettingsProcessor)reference.get() : null;
        if (settingsProcessor != null) {
            settingsProcessor.save(false);
        } else if (throwExceptions) {
            throw new RuntimeException("Component " + component + " was not registered.");
        }
    }

    public static void unregisterComponent(JComponent component) {
        SettingsProcessor settingsProcessor;
        WeakReference<SettingsProcessor> reference = settingsProcessors.get(component);
        SettingsProcessor settingsProcessor2 = settingsProcessor = reference != null ? (SettingsProcessor)reference.get() : null;
        if (settingsProcessor != null) {
            settingsProcessor.destroy();
            component.putClientProperty(COMPONENT_SETTINGS_PROCESSOR_KEY, null);
            settingsProcessors.remove(component);
        }
    }
}

