/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.skin;

import com.alee.extended.painter.Painter;
import com.alee.managers.log.Log;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.SupportedComponent;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.IgnoredValue;
import com.alee.managers.style.data.PainterStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SystemUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public abstract class WebLafSkin {
    public static final String ALL_SYSTEMS_SUPPORTED = "all";

    public abstract String getId();

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getAuthor();

    public abstract List<String> getSupportedSystems();

    public boolean isSupported() {
        List<String> systems = this.getSupportedSystems();
        boolean supportsAny = systems != null && systems.size() > 0;
        return supportsAny && (systems.contains(ALL_SYSTEMS_SUPPORTED) || systems.contains(SystemUtils.getShortOsName()));
    }

    public abstract String getSkinClass();

    public abstract ComponentStyle getComponentStyle(JComponent var1, SupportedComponent var2);

    protected SupportedComponent getSupportedComponentTypeImpl(JComponent component) {
        SupportedComponent type = SupportedComponent.getComponentTypeByUIClassID(component.getUIClassID());
        if (type == null) {
            throw new StyleException("Unknown component UI class ID: " + component.getUIClassID());
        }
        return type;
    }

    protected ComponentStyle getComponentStyleImpl(JComponent component) {
        return this.getComponentStyleImpl(component, this.getSupportedComponentTypeImpl(component));
    }

    protected ComponentStyle getComponentStyleImpl(JComponent component, SupportedComponent type) {
        ComponentStyle style = this.getComponentStyle(component, type);
        if (style == null) {
            throw new StyleException("Skin doesn't contain style for UI class ID: " + component.getUIClassID());
        }
        return style;
    }

    protected ComponentUI getComponentUIImpl(JComponent component) {
        Object ui = LafUtils.getUI(component);
        if (ui == null) {
            throw new StyleException("Unable to retrieve UI from component: " + component);
        }
        return ui;
    }

    public boolean applySkin(JComponent component) {
        return this.applySkin(component, StyleManager.getCustomPainterProperties(component), StyleManager.getCustomPainters(component));
    }

    public boolean applySkin(JComponent component, Map<String, Map<String, Object>> customPainterProperties, Map<String, Painter> customPainters) {
        try {
            SupportedComponent type = this.getSupportedComponentTypeImpl(component);
            ComponentStyle style = this.getComponentStyleImpl(component, type);
            ComponentUI ui = this.getComponentUIImpl(component);
            for (PainterStyle painterStyle : style.getPainters()) {
                Painter painter;
                String painterId = painterStyle.getId();
                if (customPainters != null && customPainters.containsKey(painterId)) {
                    painter = customPainters.get(painterId);
                } else {
                    painter = (Painter)ReflectUtils.createInstanceSafely(painterStyle.getPainterClass(), new Object[0]);
                    if (painter == null) {
                        throw new StyleException("Unable to create painter \"" + painterStyle.getPainterClass() + "\" for component: " + component);
                    }
                    Map<String, Object> cpp = this.getCustomPainterProperties(customPainterProperties, painterStyle, painterId);
                    this.applyProperties(painter, painterStyle.getProperties(), cpp);
                }
                String setterMethod = ReflectUtils.getSetterMethodName(painterId);
                ReflectUtils.callMethod(ui, setterMethod, painter);
            }
            this.applyProperties(ui, style.getUIProperties(), null);
            this.applyProperties(component, style.getComponentProperties(), null);
            return true;
        }
        catch (Throwable e) {
            Log.error((Object)this, e);
            return false;
        }
    }

    protected Map<String, Object> getCustomPainterProperties(Map<String, Map<String, Object>> customPainterProperties, PainterStyle painterStyle, String painterId) {
        return customPainterProperties != null ? customPainterProperties.get(painterStyle.isBase() ? null : painterId) : null;
    }

    public boolean removeSkin(JComponent component) {
        try {
            ComponentStyle style = this.getComponentStyleImpl(component);
            ComponentUI ui = this.getComponentUIImpl(component);
            for (PainterStyle painterStyle : style.getPainters()) {
                String setterMethod = ReflectUtils.getSetterMethodName(painterStyle.getId());
                ReflectUtils.callMethod(ui, setterMethod, new Object[]{null});
            }
            return true;
        }
        catch (Throwable e) {
            Log.error((Object)this, e);
            return false;
        }
    }

    public <T> T getPainterPropertyValue(JComponent component, String key) {
        return this.getPainterPropertyValue(component, null, key);
    }

    public <T> T getPainterPropertyValue(JComponent component, String painterId, String key) {
        T painter = this.getPainter(component, painterId);
        if (painter != null) {
            return WebLafSkin.getFieldValue(painter, key);
        }
        if (!StyleManager.isStrictStyleChecks()) {
            return null;
        }
        throw new StyleException("Painter with ID \"" + painterId + "\" was not found for component: " + component);
    }

    public boolean setCustomPainterProperty(JComponent component, String key, Object value) {
        return this.setCustomPainterProperty(component, null, key, value);
    }

    public boolean setCustomPainterProperty(JComponent component, String painterId, String key, Object value) {
        Object painter = this.getPainter(component, painterId);
        if (painter != null) {
            return WebLafSkin.setFieldValue(painter, key, value);
        }
        if (!StyleManager.isStrictStyleChecks()) {
            return false;
        }
        throw new StyleException("Painter with ID \"" + painterId + "\" was not found for component: " + component);
    }

    protected void applyProperties(Object object, Map<String, Object> skinProperties, Map<String, Object> customProperties) {
        Map<String, Object> mergedProperties;
        if (customProperties != null && customProperties.size() > 0) {
            if (skinProperties != null && skinProperties.size() > 0) {
                mergedProperties = new HashMap<String, Object>(Math.max(skinProperties.size(), customProperties.size()));
                mergedProperties.putAll(skinProperties);
                mergedProperties.putAll(customProperties);
            } else {
                mergedProperties = customProperties;
            }
        } else {
            mergedProperties = skinProperties;
        }
        if (mergedProperties != null && mergedProperties.size() > 0) {
            for (Map.Entry<String, Object> entry : mergedProperties.entrySet()) {
                WebLafSkin.setFieldValue(object, entry.getKey(), entry.getValue());
            }
        }
    }

    public static boolean setFieldValue(Object object, String field, Object value) {
        if (value == IgnoredValue.VALUE) {
            return false;
        }
        try {
            String setterMethod = ReflectUtils.getSetterMethodName(field);
            ReflectUtils.callMethod(object, setterMethod, value);
            return true;
        }
        catch (NoSuchMethodException e) {
            Log.error(WebLafSkin.class, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.error(WebLafSkin.class, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.error(WebLafSkin.class, (Throwable)e);
        }
        try {
            Field actualField = ReflectUtils.getField(object.getClass(), field);
            actualField.setAccessible(true);
            actualField.set(object, value);
            return true;
        }
        catch (NoSuchFieldException e) {
            Log.error(WebLafSkin.class, (Throwable)e);
            return false;
        }
        catch (IllegalAccessException e) {
            Log.error(WebLafSkin.class, (Throwable)e);
            return false;
        }
    }

    public static <T> T getFieldValue(Object object, String field) {
        Class<?> objectClass = object.getClass();
        try {
            Method getter = ReflectUtils.getFieldGetter(object, field);
            return (T)getter.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Log.error(WebLafSkin.class, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.error(WebLafSkin.class, (Throwable)e);
        }
        try {
            Field actualField = ReflectUtils.getField(objectClass, field);
            actualField.setAccessible(true);
            return (T)actualField.get(object);
        }
        catch (NoSuchFieldException e) {
            Log.error(WebLafSkin.class, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            Log.error(WebLafSkin.class, (Throwable)e);
            return null;
        }
    }

    public <T extends Painter> T getPainter(JComponent component, String painterId) {
        String pid = painterId != null ? painterId : this.getComponentStyleImpl(component).getBasePainter().getId();
        ComponentUI ui = this.getComponentUIImpl(component);
        return (T)((Painter)WebLafSkin.getFieldValue(ui, pid));
    }

    public String toString() {
        return this.getName();
    }
}

