/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.ReflectUtils;
import com.alee.utils.collection.IndexedSupplier;
import com.alee.utils.compare.Filter;
import com.alee.utils.text.TextProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CollectionUtils {
    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> List<T> limit(List<T> list, int limit) {
        return list.size() <= limit ? list : CollectionUtils.copySubList(list, 0, limit);
    }

    public static <T> ArrayList<T> copySubList(List<T> list, int fromIndex, int toIndex) {
        return new ArrayList<T>(list.subList(fromIndex, toIndex));
    }

    public static <T extends Cloneable> ArrayList<T> cloneSubList(List<T> list, int fromIndex, int toIndex) {
        ArrayList<Cloneable> clone = new ArrayList<Cloneable>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            clone.add(ReflectUtils.cloneSafely((Cloneable)list.get(i)));
        }
        return clone;
    }

    public static <T> ArrayList<T> asList(T ... data) {
        ArrayList list = new ArrayList(data.length);
        Collections.addAll(list, data);
        return list;
    }

    public static <T> ArrayList<T> asList(Iterator<T> data) {
        ArrayList<T> list = new ArrayList<T>();
        while (data.hasNext()) {
            list.add(data.next());
        }
        return list;
    }

    public static <T> boolean addAll(Collection<T> collection, T ... objects) {
        boolean result = false;
        for (T object : objects) {
            if (collection.contains(object)) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static <T> boolean addAllNonNull(Collection<T> collection, T ... objects) {
        boolean result = false;
        for (T object : objects) {
            if (collection.contains(object) || object == null) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static <T> boolean addAll(Collection<T> collection, Collection<T> objects) {
        boolean result = false;
        for (T object : objects) {
            if (collection.contains(object)) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static <T> boolean addAllNonNull(Collection<T> collection, Collection<T> objects) {
        boolean result = false;
        for (T object : objects) {
            if (collection.contains(object) || object == null) continue;
            result |= collection.add(object);
        }
        return result;
    }

    public static <T> boolean removeAll(Collection<T> collection, T ... objects) {
        boolean result = false;
        for (T object : objects) {
            result |= collection.remove(object);
        }
        return result;
    }

    public static <T> ArrayList<T> copy(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return new ArrayList<T>(collection);
    }

    public static <T extends Cloneable> ArrayList<T> clone(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<Cloneable> cloned = new ArrayList<Cloneable>(collection.size());
        for (Cloneable value : collection) {
            cloned.add(ReflectUtils.cloneSafely(value));
        }
        return cloned;
    }

    public static <T> ArrayList<T> copy(T ... data) {
        ArrayList list = new ArrayList(data.length);
        Collections.addAll(list, data);
        return list;
    }

    public static <T> ArrayList<T> cloneOrCopy(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<Cloneable> cloned = new ArrayList<Cloneable>(collection.size());
        for (T value : collection) {
            if (value instanceof Collection) {
                cloned.add(CollectionUtils.cloneOrCopy((Collection)value));
                continue;
            }
            if (value instanceof Cloneable) {
                cloned.add(ReflectUtils.cloneSafely((Cloneable)value));
                continue;
            }
            cloned.add((Cloneable)value);
        }
        return cloned;
    }

    public static <T> List<T> removeNulls(List<T> list) {
        if (list == null) {
            return null;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if (list.get(i) != null) continue;
            list.remove(i);
        }
        return list;
    }

    public static boolean areEqual(List list1, List list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if ((list1 == null || list2 == null) && list1 != list2) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (Object object : list1) {
            if (list2.contains(object)) continue;
            return false;
        }
        return true;
    }

    public static <T> ArrayList<String> toStringList(List<T> list, TextProvider<T> textProvider) {
        ArrayList<String> stringList = new ArrayList<String>(list.size());
        for (T element : list) {
            stringList.add(textProvider.provide(element));
        }
        return stringList;
    }

    public static int[] toArray(List<Integer> list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer integer = list.get(i);
            array[i] = integer != null ? integer : 0;
        }
        return array;
    }

    public static <T> ArrayList<T> toList(T[] array) {
        ArrayList list = new ArrayList(array.length);
        Collections.addAll(list, array);
        return list;
    }

    public static <T> ArrayList<T> toList(Deque<T> deque) {
        return new ArrayList<T>(deque);
    }

    public static <T> ArrayList<T> filter(Collection<T> collection, Filter<T> filter) {
        ArrayList<T> filtered = new ArrayList<T>(collection.size());
        for (T element : collection) {
            if (!filter.accept(element)) continue;
            filtered.add(element);
        }
        return filtered;
    }

    public static <K, V> ArrayList<K> keysList(Map<K, V> map) {
        return new ArrayList<K>(map.keySet());
    }

    public static <K, V> ArrayList<V> valuesList(Map<K, V> map) {
        return new ArrayList<V>(map.values());
    }

    public static <K, V> ArrayList<V> valuesSummaryList(Map<K, List<V>> map) {
        ArrayList<V> summary = new ArrayList<V>(0);
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            List<V> list = entry.getValue();
            summary.ensureCapacity(summary.size() + list.size());
            for (V value : list) {
                if (summary.contains(value)) continue;
                summary.add(value);
            }
        }
        return summary;
    }

    public static <T> List<T> fillList(int amount, IndexedSupplier<T> supplier) {
        ArrayList<T> list = new ArrayList<T>(amount);
        for (int i = 0; i < amount; ++i) {
            list.add(supplier.get(i));
        }
        return list;
    }
}

