/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.CompareUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.collection.DoubleMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MapUtils {
    public static <K, V> HashMap<K, V> copyMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> HashMap<K, V> copyHashMap(HashMap<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> LinkedHashMap<K, V> copyLinkedHashMap(LinkedHashMap<K, V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> DoubleMap<K, V> copyDoubleMap(DoubleMap<K, V> map) {
        return new DoubleMap<K, V>(map);
    }

    public static <K, V extends Cloneable> HashMap<K, V> cloneMap(Map<K, V> map) {
        HashMap<K, Cloneable> clone = new HashMap<K, Cloneable>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            clone.put(entry.getKey(), ReflectUtils.cloneSafely((Cloneable)entry.getValue()));
        }
        return clone;
    }

    public static <K, V extends Cloneable> HashMap<K, V> cloneHashMap(HashMap<K, V> map) {
        HashMap<K, Cloneable> clone = new HashMap<K, Cloneable>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            clone.put(entry.getKey(), ReflectUtils.cloneSafely((Cloneable)entry.getValue()));
        }
        return clone;
    }

    public static <K, V extends Cloneable> LinkedHashMap<K, V> cloneLinkedHashMap(LinkedHashMap<K, V> map) {
        LinkedHashMap<K, Cloneable> clone = new LinkedHashMap<K, Cloneable>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            clone.put(entry.getKey(), ReflectUtils.cloneSafely((Cloneable)entry.getValue()));
        }
        return clone;
    }

    public static <K, V extends Cloneable> DoubleMap<K, V> cloneLinkedHashMap(DoubleMap<K, V> map) {
        DoubleMap<K, Cloneable> clone = new DoubleMap<K, Cloneable>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            clone.put(entry.getKey(), ReflectUtils.cloneSafely((Cloneable)entry.getValue()));
        }
        return clone;
    }

    public static <K, V> HashMap<K, V> newHashMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>(1);
        map.put(key, value);
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap(Object ... objects) {
        if (objects != null && objects.length > 0) {
            if (objects.length % 2 == 0) {
                HashMap<Object, Object> map = new HashMap<Object, Object>(1);
                for (int i = 0; i < objects.length; i += 2) {
                    map.put(objects[i], objects[i + 1]);
                }
                return map;
            }
            throw new RuntimeException("Amount of key-value objects must be even");
        }
        return new HashMap(0);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(K key, V value) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(1);
        map.put(key, value);
        return map;
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Object ... objects) {
        if (objects != null && objects.length > 0) {
            if (objects.length % 2 == 0) {
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(1);
                for (int i = 0; i < objects.length; i += 2) {
                    map.put(objects[i], objects[i + 1]);
                }
                return map;
            }
            throw new RuntimeException("Amount of key-value objects must be even");
        }
        return new LinkedHashMap(0);
    }

    public static <K, V> void removeAllValues(Map<K, V> map, V value) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            if (!CompareUtils.equals(entry.getValue(), value)) continue;
            iterator.remove();
        }
    }

    public static <K, V> HashMap<K, V> merge(Map<K, V> ... maps) {
        int size = 0;
        for (Map<K, V> map : maps) {
            if (map == null) continue;
            size += map.size();
        }
        HashMap<K, V> merged = new HashMap<K, V>(size);
        for (Map<K, V> map : maps) {
            if (map == null) continue;
            merged.putAll(map);
        }
        return merged;
    }
}

