/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.swing.DataProvider;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class ShapeCache {
    private static final String settingsSeparator = ";";
    private static final Map<Component, Map<String, CachedShape>> shapeCache = new WeakHashMap<Component, Map<String, CachedShape>>();

    public static <T extends Shape> T getShape(Component component, String shapeId, DataProvider<T> shapeProvider, Object ... settings) {
        String settingsKey = ShapeCache.combineSettingsKey(settings);
        Map<String, CachedShape> cacheById = shapeCache.get(component);
        if (cacheById == null) {
            Shape shape = (Shape)shapeProvider.provide();
            cacheById = new HashMap<String, CachedShape>(1);
            cacheById.put(shapeId, new CachedShape(settingsKey, shape));
            shapeCache.put(component, cacheById);
            return (T)shape;
        }
        CachedShape cachedShape = cacheById.get(shapeId);
        if (cachedShape == null || !cachedShape.getKey().equals(settingsKey)) {
            Shape shape = (Shape)shapeProvider.provide();
            cacheById.put(shapeId, new CachedShape(settingsKey, shape));
            return (T)shape;
        }
        return (T)cachedShape.getShape();
    }

    private static String combineSettingsKey(Object ... settings) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : settings) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(settingsSeparator);
            }
            stringBuilder.append(ShapeCache.getSettingKey(object));
        }
        return stringBuilder.toString();
    }

    private static String getSettingKey(Object setting) {
        if (setting instanceof Insets) {
            Insets i = (Insets)setting;
            return i.top + "," + i.left + "," + i.bottom + "," + i.right;
        }
        if (setting instanceof Rectangle) {
            Rectangle r = (Rectangle)setting;
            return r.x + "," + r.y + "," + r.width + "," + r.height;
        }
        if (setting instanceof Point) {
            Point p = (Point)setting;
            return p.x + "," + p.y;
        }
        return setting.toString();
    }

    private static class CachedShape {
        private final String key;
        private final Shape shape;

        public CachedShape(String key, Shape shape) {
            this.key = key;
            this.shape = shape;
        }

        private String getKey() {
            return this.key;
        }

        private Shape getShape() {
            return this.shape;
        }
    }
}

