/*
 * Decompiled with CFR 0.152.
 */
package ui;

import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebFrame;
import com.alee.laf.slider.WebSlider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import prog.app;
import prog.controller;
import prog.service;
import ui.uiWebLafSetting;

public class attitudeIndicator
extends WebFrame
implements Runnable {
    private static final long serialVersionUID = 4231053498040646357L;
    int isDragging;
    int xx;
    int yy;
    WebPanel topPanel;
    controller xc;
    service xs;
    WebSlider slider;
    WebLabel label_1;
    WebLabel label_3;
    WebLabel label_6;
    String NumFont;
    long AoA;
    long AoS;
    Boolean showDirection;
    Boolean showAoALimits;
    long bomb_dy;
    long AoALimitU;
    long AoALimitD;
    long AoAFLimitU;
    long AoAFLimitD;
    long compassX;
    long compassY;
    long Pitch;
    long Roll;
    Polygon groundLevel;
    Point[] pS;
    Point pC;
    Point[] pT;
    int[] pX;
    int[] pY;
    Color transParentWhite = app.colorUnit;
    Color warning = app.colorWarning;
    public static final int tickLine = 2;
    public static final int MaxAoA = 30;
    public static final int MaxAoS = 15;
    public int xWidth = 100;
    public int xHeight = 200;
    public boolean doit = true;
    private Container root;
    public static long freqMili = 40L;
    long freqCheckMili;

    public void rotateXY(int[] nArray, int[] nArray2, int n, double d) {
        double d2 = d * Math.PI / 180.0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)Math.round((double)nArray[i] * Math.cos(d2) - (double)nArray2[i] * Math.sin(d2));
            nArray2[i] = (int)Math.round((double)nArray[i] * Math.sin(d2) + (double)nArray2[i] * Math.cos(d2));
        }
    }

    public void moveXY(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = nArray[i] + n2;
            nArray2[i] = nArray2[i] + n3;
        }
    }

    public void setFrameOpaque() {
        this.getWebRootPaneUI().setMiddleBg(new Color(0, 0, 0, 0));
        this.getWebRootPaneUI().setTopBg(new Color(0, 0, 0, 0));
        this.getWebRootPaneUI().setBorderColor(new Color(0, 0, 0, 0));
        this.getWebRootPaneUI().setInnerBorderColor(new Color(0, 0, 0, 0));
        this.setShadeWidth(0);
    }

    public void initpreview(controller controller2) {
        this.init(controller2, null);
        this.setVisible(false);
        this.getWebRootPaneUI().setTopBg(app.previewColor);
        this.getWebRootPaneUI().setMiddleBg(app.previewColor);
        final attitudeIndicator attitudeIndicator2 = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                attitudeIndicator2.xWidth = attitudeIndicator2.getWidth() - 4;
                attitudeIndicator2.xHeight = attitudeIndicator2.getHeight() - 4;
                attitudeIndicator2.repaint();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                attitudeIndicator.this.isDragging = 1;
                attitudeIndicator.this.xx = mouseEvent.getX();
                attitudeIndicator.this.yy = mouseEvent.getY();
                attitudeIndicator2.xWidth = attitudeIndicator2.getWidth() - 4;
                attitudeIndicator2.xHeight = attitudeIndicator2.getHeight() - 4;
                attitudeIndicator2.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (attitudeIndicator.this.isDragging == 1) {
                    attitudeIndicator.this.isDragging = 0;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (attitudeIndicator.this.isDragging == 1) {
                    int n = attitudeIndicator.this.getLocation().x;
                    int n2 = attitudeIndicator.this.getLocation().y;
                    attitudeIndicator.this.setLocation(n + mouseEvent.getX() - attitudeIndicator.this.xx, n2 + mouseEvent.getY() - attitudeIndicator.this.yy);
                    attitudeIndicator.this.setVisible(true);
                    attitudeIndicator.this.repaint();
                }
            }
        });
        this.setShowResizeCorner(true);
        this.setCursor(null);
        this.setVisible(true);
    }

    public void locater(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(app.colorShadeShape);
        graphics2D.drawLine(0, 0, 0, n2);
        graphics2D.drawLine(0, 0, n, 0);
        graphics2D.drawLine(0, n2 - 1, n - 1, n2 - 1);
        graphics2D.drawLine(n - 1, 0, n - 1, n2 - 1);
        for (int i = 0; i < 4; ++i) {
            graphics2D.drawLine(this.pT[4 + 2 * i].x, this.pT[4 + 2 * i].y, this.pT[4 + 2 * i + 1].x, this.pT[4 + 2 * i + 1].y);
        }
        graphics2D.setColor(app.colorUnit);
        graphics2D.fillPolygon(this.pX, this.pY, 4);
        if (this.showDirection.booleanValue()) {
            graphics2D.drawLine(n / 2, n2 / 2, (int)((long)(n / 2) + this.compassX), (int)((long)(n2 / 2) + this.compassY));
        }
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.setColor(app.colorNum);
        graphics2D.drawLine(n / 2 - n6 / 2 - n / 8 - 1, n2 / 2 - 1, n / 2 - n6 / 2 - 1, n2 / 2 - 1);
        graphics2D.drawLine(n / 2 + n6 / 2, n2 / 2 - 1, n / 2 + n6 / 2 + n / 8 - 1, n2 / 2 - 1);
        graphics2D.drawLine(0, n2 / 2 - 1, n / 8 - 1, n2 / 2 - 1);
        graphics2D.drawLine(n - n / 8 + 1, n2 / 2 - 1, n, n2 / 2 - 1);
        graphics2D.drawArc(n / 2 - n6 / 2 - 1, n2 / 2 - n6 / 2 - 1, n6, n6, -180, 180);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.drawLine(n3 - n7 / 2 - 1, n4 - 1, n3 + n7 / 2 - 1, n4 - 1);
        graphics2D.drawLine(n3 - 1, n4 - n7 / 2 - 1, n3 - 1, n4 + n7 / 2 - 1);
        graphics2D.setColor(app.colorWarning);
        graphics2D.drawLine(0, (int)this.AoAFLimitU, n - 1, (int)this.AoAFLimitU);
        graphics2D.drawLine(0, (int)this.AoAFLimitD, n - 1, (int)this.AoAFLimitD);
        graphics2D.setColor(app.colorLabel);
        graphics2D.drawLine(0, (int)this.AoALimitU, n - 1, (int)this.AoALimitU);
        graphics2D.drawLine(0, (int)this.AoALimitD, n - 1, (int)this.AoALimitD);
        if (this.showDirection.booleanValue()) {
            graphics2D.drawLine(n / 2, n2 / 2, (int)((long)(n / 2) + this.compassX), (int)((long)(n2 / 2) + this.compassY));
            graphics2D.setColor(app.colorUnit);
            graphics2D.drawLine(n / 2, n2 / 2, (int)((long)(n / 2) - this.compassX), (int)((long)(n2 / 2) - this.compassY));
        }
    }

    public void initslider(WebSlider webSlider) {
        int n;
        webSlider.setMinimum(-100);
        webSlider.setMaximum(100);
        webSlider.setValue(0);
        webSlider.setDrawProgress(true);
        webSlider.setMinorTickSpacing(25);
        webSlider.setMajorTickSpacing(50);
        webSlider.setPaintTicks(true);
        webSlider.setPaintLabels(true);
        webSlider.setProgressShadeWidth(0);
        webSlider.setTrackShadeWidth(1);
        webSlider.setThumbShadeWidth(2);
        webSlider.setThumbBgBottom(Color.white);
        webSlider.setThumbBgTop(Color.white);
        webSlider.setTrackBgBottom(new Color(0, 0, 0, 0));
        webSlider.setTrackBgTop(new Color(0, 0, 0, 0));
        webSlider.setProgressBorderColor(new Color(0, 0, 0, 0));
        webSlider.setProgressTrackBgBottom(new Color(0, 0, 0, 0));
        webSlider.setProgressTrackBgTop(new Color(0, 0, 0, 0));
        webSlider.setFocusable(false);
        MouseListener[] mouseListenerArray = webSlider.getMouseListeners();
        MouseMotionListener[] mouseMotionListenerArray = webSlider.getMouseMotionListeners();
        for (n = 0; n < mouseListenerArray.length; ++n) {
            webSlider.removeMouseListener(mouseListenerArray[n]);
        }
        for (n = 0; n < mouseMotionListenerArray.length; ++n) {
            webSlider.removeMouseMotionListener(mouseMotionListenerArray[n]);
        }
    }

    public WebLabel createWebLabel(String string) {
        WebLabel webLabel = new WebLabel(string);
        webLabel.setShadeColor(new Color(0, 0, 0));
        webLabel.setDrawShade(true);
        return webLabel;
    }

    public void initpanel(WebPanel webPanel) {
        webPanel.setLayout(null);
        WebPanel webPanel2 = new WebPanel(){
            private static final long serialVersionUID = -9061280572815010060L;

            @Override
            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaintMode();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, app.graphAASetting);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, app.textAASetting);
                graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                attitudeIndicator.this.locater(graphics2D, attitudeIndicator.this.xWidth, attitudeIndicator.this.xHeight, (int)attitudeIndicator.this.AoS, (int)attitudeIndicator.this.AoA, (int)attitudeIndicator.this.Pitch, 12, 6);
                graphics.dispose();
            }
        };
        webPanel2.setBounds(0, 0, this.xWidth, this.xHeight);
        webPanel.add((Component)webPanel2);
    }

    public void init(controller controller2, service service2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        this.xc = controller2;
        this.xs = service2;
        this.NumFont = this.xc.getconfig("GlobalNumFont") != "" ? this.xc.getconfig("GlobalNumFont") : app.defaultNumfontName;
        n2 = this.xc.getconfig("attitudeIndicatorX") != "" ? Integer.parseInt(this.xc.getconfig("attitudeIndicatorX")) : 0;
        n3 = this.xc.getconfig("attitudeIndicatorY") != "" ? Integer.parseInt(this.xc.getconfig("attitudeIndicatorY")) : 0;
        this.xWidth = this.xc.getconfig("attitudeIndicatorWidth") != "" ? Integer.parseInt(this.xc.getconfig("attitudeIndicatorWidth")) : 150;
        this.xHeight = this.xc.getconfig("attitudeIndicatorHeight") != "" ? Integer.parseInt(this.xc.getconfig("attitudeIndicatorHeight")) : 300;
        freqMili = this.xc.getconfig("attitudeIndicatorFreqMs") != "" ? (long)Integer.parseInt(this.xc.getconfig("attitudeIndicatorFreqMs")) : 40L;
        if (this.xc.getconfig("attitudeIndicatorUseNumColor") != "" && Boolean.parseBoolean(this.xc.getconfig("attitudeIndicatorUseNumColor"))) {
            this.transParentWhite = app.colorNum;
        }
        this.showDirection = false;
        if (this.xc.getconfig("attitudeIndicatorDisplayDirection") != "" && Boolean.parseBoolean(this.xc.getconfig("attitudeIndicatorDisplayDirection"))) {
            this.showDirection = true;
        }
        this.showAoALimits = true;
        if (this.xc.getconfig("attitudeIndicatorDisplayAoALimits") != "") {
            this.showAoALimits = Boolean.parseBoolean(this.xc.getconfig("attitudeIndicatorDisplayDirection"));
        }
        this.setFrameOpaque();
        this.pX = new int[4];
        this.pY = new int[4];
        this.pS = new Point[12];
        this.pS[0] = new Point(-10, 10);
        this.pS[1] = new Point(10, 10);
        this.pS[2] = new Point(10, -10);
        this.pS[3] = new Point(-10, -10);
        for (n = 4; n < 12; ++n) {
            this.pS[n] = new Point(0, 0);
        }
        this.pC = new Point(this.xWidth / 2, this.xHeight / 2);
        this.pT = new Point[12];
        for (n = 0; n < 12; ++n) {
            this.pT[n] = new Point(0, 0);
        }
        this.setBounds(n2, n3, this.xWidth + 4, this.xHeight + 4);
        this.topPanel = new WebPanel(){
            private static final long serialVersionUID = -9061280572815010060L;

            @Override
            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaintMode();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                attitudeIndicator.this.locater(graphics2D, attitudeIndicator.this.xWidth, attitudeIndicator.this.xHeight, (int)attitudeIndicator.this.AoS, (int)attitudeIndicator.this.AoA, (int)attitudeIndicator.this.Pitch, 12, 6);
                graphics.dispose();
            }
        };
        this.initpanel(this.topPanel);
        this.add(this.topPanel);
        this.root = this.getContentPane();
        this.setTitle("attitude");
        uiWebLafSetting.setWindowOpaque(this);
        if (this.xc.getconfig("enableAttituteIndicatorEdge").equals("true")) {
            this.setShadeWidth(10);
        }
    }

    public void rotatePointMatrix(Point[] pointArray, double d, Point point, Point[] pointArray2, int n) {
        AffineTransform.getRotateInstance(Math.toRadians(d), point.x, point.y).transform(pointArray, 0, pointArray2, 0, n);
    }

    public void drawTick() {
        int n;
        double d;
        this.AoA = Math.round((-this.xs.sState.AoA + 30.0) * (double)this.xHeight / 60.0);
        this.AoS = Math.round((this.xs.sState.AoS + 15.0) * (double)this.xWidth / 30.0);
        this.Pitch = Math.round((-this.xs.sIndic.aviahorizon_pitch + 30.0) * (double)this.xHeight / 60.0);
        if (this.showDirection.booleanValue()) {
            d = Math.toRadians(this.xs.sIndic.compass);
            this.compassX = (int)((double)(this.xWidth / 4) * Math.sin(d));
            this.compassY = (int)((double)(this.xWidth / 4) * Math.cos(d));
        }
        if (this.xc.blkx.valid) {
            if (this.showAoALimits.booleanValue()) {
                if (this.xs.sState.AoA >= 0.0) {
                    this.AoALimitU = Math.round((-(this.xc.blkx.NoFlapsWing.AoACritHigh - this.xs.sState.AoA) + 30.0) * (double)this.xHeight / 60.0);
                    this.AoAFLimitU = Math.round((-(this.xc.blkx.aoaFuselageHigh - this.xs.sState.AoA) + 30.0) * (double)this.xHeight / 60.0);
                    this.AoALimitD = -10L;
                    this.AoAFLimitD = -10L;
                } else {
                    this.AoALimitD = Math.round((-(this.xc.blkx.NoFlapsWing.AoACritLow - this.xs.sState.AoA) + 30.0) * (double)this.xHeight / 60.0);
                    this.AoAFLimitD = Math.round((-(this.xc.blkx.aoaFuselageLow - this.xs.sState.AoA) + 30.0) * (double)this.xHeight / 60.0);
                    this.AoALimitU = -10L;
                    this.AoAFLimitU = -10L;
                }
            } else {
                this.AoALimitU = (double)0.3f * this.xc.blkx.aoaHigh <= this.xs.sState.AoA ? Math.round((-(this.xc.blkx.aoaHigh - this.xs.sState.AoA) + 30.0) * (double)this.xHeight / 60.0) : -10L;
                this.AoALimitD = (double)0.3f * this.xc.blkx.aoaLow >= this.xs.sState.AoA ? Math.round((-(this.xc.blkx.aoaLow - this.xs.sState.AoA) + 30.0) * (double)this.xHeight / 60.0) : -10L;
            }
        }
        this.pS[0].x = -2 * this.xWidth;
        this.pS[0].y = 0;
        this.pS[1].x = 2 * this.xWidth;
        this.pS[1].y = 0;
        this.pS[2].x = 2 * this.xWidth;
        this.pS[2].y = 6 * this.xHeight;
        this.pS[3].x = -2 * this.xWidth;
        this.pS[3].y = 6 * this.xHeight;
        d = -90.0;
        double d2 = 30.0;
        for (n = 0; n < 2; ++n) {
            this.pS[4 + 4 * n].x = -this.xWidth;
            this.pS[4 + 4 * n].y = (int)Math.round((d + d2 * (double)(n + 1)) / 60.0 * (double)this.xHeight);
            this.pS[4 + 4 * n + 1].x = this.xWidth;
            this.pS[4 + 4 * n + 1].y = (int)Math.round((d + d2 * (double)(n + 1)) / 60.0 * (double)this.xHeight);
            this.pS[4 + 4 * n + 2].x = -this.xWidth;
            this.pS[4 + 4 * n + 2].y = (int)Math.round((-d - d2 * (double)(n + 1)) / 60.0 * (double)this.xHeight);
            this.pS[4 + 4 * n + 3].x = this.xWidth;
            this.pS[4 + 4 * n + 3].y = (int)Math.round((-d - d2 * (double)(n + 1)) / 60.0 * (double)this.xHeight);
        }
        for (n = 0; n < this.pS.length; ++n) {
            this.pS[n].x += this.xWidth / 2;
            this.pS[n].y = (int)((long)this.pS[n].y + this.Pitch);
        }
        this.rotatePointMatrix(this.pS, this.xs.sIndic.aviahorizon_roll, this.pC, this.pT, this.pS.length);
        for (n = 0; n < 4; ++n) {
            this.pX[n] = this.pT[n].x;
            this.pY[n] = this.pT[n].y;
        }
        this.root.repaint();
    }

    @Override
    public void run() {
        while (this.doit) {
            try {
                Thread.sleep(app.threadSleepTime);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (this.xs.SystemTime - this.freqCheckMili <= freqMili) continue;
            this.freqCheckMili = this.xs.SystemTime;
            if (this.xs.sState == null || this.xs.sIndic == null) continue;
            this.drawTick();
        }
    }
}

