﻿/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

using Newtonsoft.Json;
using Newtonsoft.Json.Converters;

namespace QuantConnect.Algorithm.Framework.Alphas
{
    /// <summary>
    /// Specifies the predicted direction for a insight (price/volatility)
    /// </summary>
    [JsonConverter(typeof(StringEnumConverter), true)]
    public enum InsightDirection
    {
        /// <summary>
        /// The value will go down (-1)
        /// </summary>
        Down = -1,

        /// <summary>
        /// The value will stay flat (0)
        /// </summary>
        Flat = 0,

        /// <summary>
        /// The value will go up (1)
        /// </summary>
        Up = 1
    }
}