/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

namespace QuantConnect
{
    /// <summary>
    /// The Country class contains all countries normalized for your convenience.
    /// It maps the country name to its ISO 3166-1 alpha-3 code, see https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3
    /// </summary>
    public static class Country
    {
        /// <summary>
        /// Afghanistan
        /// </summary>
        public const string Afghanistan = "AFG";

        /// <summary>
        /// Aland Islands
        /// </summary>
        public const string AlandIslands = "ALA";

        /// <summary>
        /// Albania
        /// </summary>
        public const string Albania = "ALB";

        /// <summary>
        /// Algeria
        /// </summary>
        public const string Algeria = "DZA";

        /// <summary>
        /// American Samoa
        /// </summary>
        public const string AmericanSamoa = "ASM";

        /// <summary>
        /// Andorra
        /// </summary>
        public const string Andorra = "AND";

        /// <summary>
        /// Angola
        /// </summary>
        public const string Angola = "AGO";

        /// <summary>
        /// Anguilla
        /// </summary>
        public const string Anguilla = "AIA";

        /// <summary>
        /// Antarctica
        /// </summary>
        public const string Antarctica = "ATA";

        /// <summary>
        /// Antigua and Barbuda
        /// </summary>
        public const string AntiguaAndBarbuda = "ATG";

        /// <summary>
        /// Argentina
        /// </summary>
        public const string Argentina = "ARG";

        /// <summary>
        /// Armenia
        /// </summary>
        public const string Armenia = "ARM";

        /// <summary>
        /// Aruba
        /// </summary>
        public const string Aruba = "ABW";

        /// <summary>
        /// Australia
        /// </summary>
        public const string Australia = "AUS";

        /// <summary>
        /// Austria
        /// </summary>
        public const string Austria = "AUT";

        /// <summary>
        /// Azerbaijan
        /// </summary>
        public const string Azerbaijan = "AZE";

        /// <summary>
        /// Bahamas
        /// </summary>
        public const string Bahamas = "BHS";

        /// <summary>
        /// Bahrain
        /// </summary>
        public const string Bahrain = "BHR";

        /// <summary>
        /// Bangladesh
        /// </summary>
        public const string Bangladesh = "BGD";

        /// <summary>
        /// Barbados
        /// </summary>
        public const string Barbados = "BRB";

        /// <summary>
        /// Belarus
        /// </summary>
        public const string Belarus = "BLR";

        /// <summary>
        /// Belgium
        /// </summary>
        public const string Belgium = "BEL";

        /// <summary>
        /// Belize
        /// </summary>
        public const string Belize = "BLZ";

        /// <summary>
        /// Benin
        /// </summary>
        public const string Benin = "BEN";

        /// <summary>
        /// Bermuda
        /// </summary>
        public const string Bermuda = "BMU";

        /// <summary>
        /// Bhutan
        /// </summary>
        public const string Bhutan = "BTN";

        /// <summary>
        /// Bolivia
        /// </summary>
        public const string Bolivia = "BOL";

        /// <summary>
        /// Bonaire
        /// </summary>
        public const string Bonaire = "BES";

        /// <summary>
        /// Bosnia and Herzegovina
        /// </summary>
        public const string BosniaAndHerzegovina = "BIH";

        /// <summary>
        /// Botswana
        /// </summary>
        public const string Botswana = "BWA";

        /// <summary>
        /// Bouvet Island
        /// </summary>
        public const string BouvetIsland = "BVT";

        /// <summary>
        /// Brazil
        /// </summary>
        public const string Brazil = "BRA";

        /// <summary>
        /// British Indian Ocean Territory
        /// </summary>
        public const string BritishIndianOceanTerritory = "IOT";

        /// <summary>
        /// Brunei Darussalam
        /// </summary>
        public const string BruneiDarussalam = "BRN";

        /// <summary>
        /// Bulgaria
        /// </summary>
        public const string Bulgaria = "BGR";

        /// <summary>
        /// Burkina Faso
        /// </summary>
        public const string BurkinaFaso = "BFA";

        /// <summary>
        /// Burundi
        /// </summary>
        public const string Burundi = "BDI";

        /// <summary>
        /// Cabo Verde
        /// </summary>
        public const string CaboVerde = "CPV";

        /// <summary>
        /// Cambodia
        /// </summary>
        public const string Cambodia = "KHM";

        /// <summary>
        /// Cameroon
        /// </summary>
        public const string Cameroon = "CMR";

        /// <summary>
        /// Canada
        /// </summary>
        public const string Canada = "CAN";

        /// <summary>
        /// Cayman Islands
        /// </summary>
        public const string CaymanIslands = "CYM";

        /// <summary>
        /// Central African Republic
        /// </summary>
        public const string CentralAfricanRepublic = "CAF";

        /// <summary>
        /// Chad
        /// </summary>
        public const string Chad = "TCD";

        /// <summary>
        /// Chile
        /// </summary>
        public const string Chile = "CHL";

        /// <summary>
        /// China
        /// </summary>
        public const string China = "CHN";

        /// <summary>
        /// Christmas Island
        /// </summary>
        public const string ChristmasIsland = "CXR";

        /// <summary>
        /// Cocos Keeling Islands
        /// </summary>
        public const string CocosKeelingIslands = "CCK";

        /// <summary>
        /// Colombia
        /// </summary>
        public const string Colombia = "COL";

        /// <summary>
        /// Comoros
        /// </summary>
        public const string Comoros = "COM";

        /// <summary>
        /// Democratic Republic of Congo
        /// </summary>
        public const string DemocraticRepublicOfCongo = "COD";

        /// <summary>
        /// Congo
        /// </summary>
        public const string Congo = "COG";

        /// <summary>
        /// Cook Islands
        /// </summary>
        public const string CookIslands = "COK";

        /// <summary>
        /// Costa Rica
        /// </summary>
        public const string CostaRica = "CRI";

        /// <summary>
        /// Ivory Coast
        /// </summary>
        public const string IvoryCoast = "CIV";

        /// <summary>
        /// Croatia
        /// </summary>
        public const string Croatia = "HRV";

        /// <summary>
        /// Cuba
        /// </summary>
        public const string Cuba = "CUB";

        /// <summary>
        /// Curaçao
        /// </summary>
        public const string Curaçao = "CUW";

        /// <summary>
        /// Cyprus
        /// </summary>
        public const string Cyprus = "CYP";

        /// <summary>
        /// Czechia
        /// </summary>
        public const string Czechia = "CZE";

        /// <summary>
        /// Denmark
        /// </summary>
        public const string Denmark = "DNK";

        /// <summary>
        /// Djibouti
        /// </summary>
        public const string Djibouti = "DJI";

        /// <summary>
        /// Dominica
        /// </summary>
        public const string Dominica = "DMA";

        /// <summary>
        /// Dominican Republic
        /// </summary>
        public const string DominicanRepublic = "DOM";

        /// <summary>
        /// Ecuador
        /// </summary>
        public const string Ecuador = "ECU";

        /// <summary>
        /// Egypt
        /// </summary>
        public const string Egypt = "EGY";

        /// <summary>
        /// El Salvador
        /// </summary>
        public const string ElSalvador = "SLV";

        /// <summary>
        /// Equatorial Guinea
        /// </summary>
        public const string EquatorialGuinea = "GNQ";

        /// <summary>
        /// Eritrea
        /// </summary>
        public const string Eritrea = "ERI";

        /// <summary>
        /// Estonia
        /// </summary>
        public const string Estonia = "EST";

        /// <summary>
        /// Eswatini
        /// </summary>
        public const string Eswatini = "SWZ";

        /// <summary>
        /// Ethiopia
        /// </summary>
        public const string Ethiopia = "ETH";

        /// <summary>
        /// Falkland Islands
        /// </summary>
        public const string FalklandIslands = "FLK";

        /// <summary>
        /// Faroe Islands
        /// </summary>
        public const string FaroeIslands = "FRO";

        /// <summary>
        /// Fiji
        /// </summary>
        public const string Fiji = "FJI";

        /// <summary>
        /// Finland
        /// </summary>
        public const string Finland = "FIN";

        /// <summary>
        /// France
        /// </summary>
        public const string France = "FRA";

        /// <summary>
        /// French Guiana
        /// </summary>
        public const string FrenchGuiana = "GUF";

        /// <summary>
        /// French Polynesia
        /// </summary>
        public const string FrenchPolynesia = "PYF";

        /// <summary>
        /// French Southern Territories
        /// </summary>
        public const string FrenchSouthernTerritories = "ATF";

        /// <summary>
        /// Gabon
        /// </summary>
        public const string Gabon = "GAB";

        /// <summary>
        /// Gambia
        /// </summary>
        public const string Gambia = "GMB";

        /// <summary>
        /// Georgia
        /// </summary>
        public const string Georgia = "GEO";

        /// <summary>
        /// Germany
        /// </summary>
        public const string Germany = "DEU";

        /// <summary>
        /// Ghana
        /// </summary>
        public const string Ghana = "GHA";

        /// <summary>
        /// Gibraltar
        /// </summary>
        public const string Gibraltar = "GIB";

        /// <summary>
        /// Greece
        /// </summary>
        public const string Greece = "GRC";

        /// <summary>
        /// Greenland
        /// </summary>
        public const string Greenland = "GRL";

        /// <summary>
        /// Grenada
        /// </summary>
        public const string Grenada = "GRD";

        /// <summary>
        /// Guadeloupe
        /// </summary>
        public const string Guadeloupe = "GLP";

        /// <summary>
        /// Guam
        /// </summary>
        public const string Guam = "GUM";

        /// <summary>
        /// Guatemala
        /// </summary>
        public const string Guatemala = "GTM";

        /// <summary>
        /// Guernsey
        /// </summary>
        public const string Guernsey = "GGY";

        /// <summary>
        /// Guinea
        /// </summary>
        public const string Guinea = "GIN";

        /// <summary>
        /// Guinea-Bissau
        /// </summary>
        public const string GuineaBissau = "GNB";

        /// <summary>
        /// Guyana
        /// </summary>
        public const string Guyana = "GUY";

        /// <summary>
        /// Haiti
        /// </summary>
        public const string Haiti = "HTI";

        /// <summary>
        /// Heard Island and McDonald Islands
        /// </summary>
        public const string HeardIslandAndMcdonaldIslands = "HMD";

        /// <summary>
        /// Holy See
        /// </summary>
        public const string HolySee = "VAT";

        /// <summary>
        /// Honduras
        /// </summary>
        public const string Honduras = "HND";

        /// <summary>
        /// Hong Kong
        /// </summary>
        public const string HongKong = "HKG";

        /// <summary>
        /// Hungary
        /// </summary>
        public const string Hungary = "HUN";

        /// <summary>
        /// Iceland
        /// </summary>
        public const string Iceland = "ISL";

        /// <summary>
        /// India
        /// </summary>
        public const string India = "IND";

        /// <summary>
        /// Indonesia
        /// </summary>
        public const string Indonesia = "IDN";

        /// <summary>
        /// Iran
        /// </summary>
        public const string Iran = "IRN";

        /// <summary>
        /// Iraq
        /// </summary>
        public const string Iraq = "IRQ";

        /// <summary>
        /// Ireland
        /// </summary>
        public const string Ireland = "IRL";

        /// <summary>
        /// Isle of Man
        /// </summary>
        public const string IsleOfMan = "IMN";

        /// <summary>
        /// Israel
        /// </summary>
        public const string Israel = "ISR";

        /// <summary>
        /// Italy
        /// </summary>
        public const string Italy = "ITA";

        /// <summary>
        /// Jamaica
        /// </summary>
        public const string Jamaica = "JAM";

        /// <summary>
        /// Japan
        /// </summary>
        public const string Japan = "JPN";

        /// <summary>
        /// Jersey
        /// </summary>
        public const string Jersey = "JEY";

        /// <summary>
        /// Jordan
        /// </summary>
        public const string Jordan = "JOR";

        /// <summary>
        /// Kazakhstan
        /// </summary>
        public const string Kazakhstan = "KAZ";

        /// <summary>
        /// Kenya
        /// </summary>
        public const string Kenya = "KEN";

        /// <summary>
        /// Kiribati
        /// </summary>
        public const string Kiribati = "KIR";

        /// <summary>
        /// North Korea
        /// </summary>
        public const string NorthKorea = "PRK";

        /// <summary>
        /// Korea
        /// </summary>
        public const string Korea = "KOR";

        /// <summary>
        /// Kuwait
        /// </summary>
        public const string Kuwait = "KWT";

        /// <summary>
        /// Kyrgyzstan
        /// </summary>
        public const string Kyrgyzstan = "KGZ";

        /// <summary>
        /// Laos
        /// </summary>
        public const string Laos = "LAO";

        /// <summary>
        /// Latvia
        /// </summary>
        public const string Latvia = "LVA";

        /// <summary>
        /// Lebanon
        /// </summary>
        public const string Lebanon = "LBN";

        /// <summary>
        /// Lesotho
        /// </summary>
        public const string Lesotho = "LSO";

        /// <summary>
        /// Liberia
        /// </summary>
        public const string Liberia = "LBR";

        /// <summary>
        /// Libya
        /// </summary>
        public const string Libya = "LBY";

        /// <summary>
        /// Liechtenstein
        /// </summary>
        public const string Liechtenstein = "LIE";

        /// <summary>
        /// Lithuania
        /// </summary>
        public const string Lithuania = "LTU";

        /// <summary>
        /// Luxembourg
        /// </summary>
        public const string Luxembourg = "LUX";

        /// <summary>
        /// Macao
        /// </summary>
        public const string Macao = "MAC";

        /// <summary>
        /// Madagascar
        /// </summary>
        public const string Madagascar = "MDG";

        /// <summary>
        /// Malawi
        /// </summary>
        public const string Malawi = "MWI";

        /// <summary>
        /// Malaysia
        /// </summary>
        public const string Malaysia = "MYS";

        /// <summary>
        /// Maldives
        /// </summary>
        public const string Maldives = "MDV";

        /// <summary>
        /// Mali
        /// </summary>
        public const string Mali = "MLI";

        /// <summary>
        /// Malta
        /// </summary>
        public const string Malta = "MLT";

        /// <summary>
        /// Marshall Islands
        /// </summary>
        public const string MarshallIslands = "MHL";

        /// <summary>
        /// Martinique
        /// </summary>
        public const string Martinique = "MTQ";

        /// <summary>
        /// Mauritania
        /// </summary>
        public const string Mauritania = "MRT";

        /// <summary>
        /// Mauritius
        /// </summary>
        public const string Mauritius = "MUS";

        /// <summary>
        /// Mayotte
        /// </summary>
        public const string Mayotte = "MYT";

        /// <summary>
        /// Mexico
        /// </summary>
        public const string Mexico = "MEX";

        /// <summary>
        /// Micronesia
        /// </summary>
        public const string Micronesia = "FSM";

        /// <summary>
        /// Moldova
        /// </summary>
        public const string Moldova = "MDA";

        /// <summary>
        /// Monaco
        /// </summary>
        public const string Monaco = "MCO";

        /// <summary>
        /// Mongolia
        /// </summary>
        public const string Mongolia = "MNG";

        /// <summary>
        /// Montenegro
        /// </summary>
        public const string Montenegro = "MNE";

        /// <summary>
        /// Montserrat
        /// </summary>
        public const string Montserrat = "MSR";

        /// <summary>
        /// Morocco
        /// </summary>
        public const string Morocco = "MAR";

        /// <summary>
        /// Mozambique
        /// </summary>
        public const string Mozambique = "MOZ";

        /// <summary>
        /// Myanmar
        /// </summary>
        public const string Myanmar = "MMR";

        /// <summary>
        /// Namibia
        /// </summary>
        public const string Namibia = "NAM";

        /// <summary>
        /// Nauru
        /// </summary>
        public const string Nauru = "NRU";

        /// <summary>
        /// Nepal
        /// </summary>
        public const string Nepal = "NPL";

        /// <summary>
        /// Netherlands
        /// </summary>
        public const string Netherlands = "NLD";

        /// <summary>
        /// New Caledonia
        /// </summary>
        public const string NewCaledonia = "NCL";

        /// <summary>
        /// New Zealand
        /// </summary>
        public const string NewZealand = "NZL";

        /// <summary>
        /// Nicaragua
        /// </summary>
        public const string Nicaragua = "NIC";

        /// <summary>
        /// Niger
        /// </summary>
        public const string Niger = "NER";

        /// <summary>
        /// Nigeria
        /// </summary>
        public const string Nigeria = "NGA";

        /// <summary>
        /// Niue
        /// </summary>
        public const string Niue = "NIU";

        /// <summary>
        /// Norfolk Island
        /// </summary>
        public const string NorfolkIsland = "NFK";

        /// <summary>
        /// North Macedonia
        /// </summary>
        public const string NorthMacedonia = "MKD";

        /// <summary>
        /// Northern Mariana Islands
        /// </summary>
        public const string NorthernMarianaIslands = "MNP";

        /// <summary>
        /// Norway
        /// </summary>
        public const string Norway = "NOR";

        /// <summary>
        /// Oman
        /// </summary>
        public const string Oman = "OMN";

        /// <summary>
        /// Pakistan
        /// </summary>
        public const string Pakistan = "PAK";

        /// <summary>
        /// Palau
        /// </summary>
        public const string Palau = "PLW";

        /// <summary>
        /// Palestine
        /// </summary>
        public const string Palestine = "PSE";

        /// <summary>
        /// Panama
        /// </summary>
        public const string Panama = "PAN";

        /// <summary>
        /// Papua New Guinea
        /// </summary>
        public const string PapuaNewGuinea = "PNG";

        /// <summary>
        /// Paraguay
        /// </summary>
        public const string Paraguay = "PRY";

        /// <summary>
        /// Peru
        /// </summary>
        public const string Peru = "PER";

        /// <summary>
        /// Philippines
        /// </summary>
        public const string Philippines = "PHL";

        /// <summary>
        /// Pitcairn
        /// </summary>
        public const string Pitcairn = "PCN";

        /// <summary>
        /// Poland
        /// </summary>
        public const string Poland = "POL";

        /// <summary>
        /// Portugal
        /// </summary>
        public const string Portugal = "PRT";

        /// <summary>
        /// Puerto Rico
        /// </summary>
        public const string PuertoRico = "PRI";

        /// <summary>
        /// Qatar
        /// </summary>
        public const string Qatar = "QAT";

        /// <summary>
        /// Reunion
        /// </summary>
        public const string Reunion = "REU";

        /// <summary>
        /// Romania
        /// </summary>
        public const string Romania = "ROU";

        /// <summary>
        /// Russia
        /// </summary>
        public const string Russia = "RUS";

        /// <summary>
        /// Rwanda
        /// </summary>
        public const string Rwanda = "RWA";

        /// <summary>
        /// Saint Barthélemy
        /// </summary>
        public const string SaintBarthélemy = "BLM";

        /// <summary>
        /// Saint Helena
        /// </summary>
        public const string SaintHelena = "SHN";

        /// <summary>
        /// Saint Kitts and Nevis
        /// </summary>
        public const string SaintKittsAndNevis = "KNA";

        /// <summary>
        /// Saint Lucia
        /// </summary>
        public const string SaintLucia = "LCA";

        /// <summary>
        /// Saint Martin French part
        /// </summary>
        public const string SaintMartinFrenchPart = "MAF";

        /// <summary>
        /// Saint Pierre and Miquelon
        /// </summary>
        public const string SaintPierreAndMiquelon = "SPM";

        /// <summary>
        /// Saint Vincent and the Grenadines
        /// </summary>
        public const string SaintVincentAndTheGrenadines = "VCT";

        /// <summary>
        /// Samoa
        /// </summary>
        public const string Samoa = "WSM";

        /// <summary>
        /// San Marino
        /// </summary>
        public const string SanMarino = "SMR";

        /// <summary>
        /// Sao Tome and Principe
        /// </summary>
        public const string SaoTomeAndPrincipe = "STP";

        /// <summary>
        /// Saudi Arabia
        /// </summary>
        public const string SaudiArabia = "SAU";

        /// <summary>
        /// Senegal
        /// </summary>
        public const string Senegal = "SEN";

        /// <summary>
        /// Serbia
        /// </summary>
        public const string Serbia = "SRB";

        /// <summary>
        /// Seychelles
        /// </summary>
        public const string Seychelles = "SYC";

        /// <summary>
        /// Sierra Leone
        /// </summary>
        public const string SierraLeone = "SLE";

        /// <summary>
        /// Singapore
        /// </summary>
        public const string Singapore = "SGP";

        /// <summary>
        /// Sint Maarten Dutch part
        /// </summary>
        public const string SintMaartenDutchPart = "SXM";

        /// <summary>
        /// Slovakia
        /// </summary>
        public const string Slovakia = "SVK";

        /// <summary>
        /// Slovenia
        /// </summary>
        public const string Slovenia = "SVN";

        /// <summary>
        /// Solomon Islands
        /// </summary>
        public const string SolomonIslands = "SLB";

        /// <summary>
        /// Somalia
        /// </summary>
        public const string Somalia = "SOM";

        /// <summary>
        /// South Africa
        /// </summary>
        public const string SouthAfrica = "ZAF";

        /// <summary>
        /// South Georgia and the South Sandwich Islands
        /// </summary>
        public const string SouthGeorgiaAndTheSouthSandwichIslands = "SGS";

        /// <summary>
        /// South Sudan
        /// </summary>
        public const string SouthSudan = "SSD";

        /// <summary>
        /// Spain
        /// </summary>
        public const string Spain = "ESP";

        /// <summary>
        /// Sri Lanka
        /// </summary>
        public const string SriLanka = "LKA";

        /// <summary>
        /// Sudan
        /// </summary>
        public const string Sudan = "SDN";

        /// <summary>
        /// Suriname
        /// </summary>
        public const string Suriname = "SUR";

        /// <summary>
        /// Svalbard
        /// </summary>
        public const string Svalbard = "SJM";

        /// <summary>
        /// Sweden
        /// </summary>
        public const string Sweden = "SWE";

        /// <summary>
        /// Switzerland
        /// </summary>
        public const string Switzerland = "CHE";

        /// <summary>
        /// Syria
        /// </summary>
        public const string Syria = "SYR";

        /// <summary>
        /// Taiwan
        /// </summary>
        public const string Taiwan = "TWN";

        /// <summary>
        /// Tajikistan
        /// </summary>
        public const string Tajikistan = "TJK";

        /// <summary>
        /// Tanzania
        /// </summary>
        public const string Tanzania = "TZA";

        /// <summary>
        /// Thailand
        /// </summary>
        public const string Thailand = "THA";

        /// <summary>
        /// Timor-Leste
        /// </summary>
        public const string TimorLeste = "TLS";

        /// <summary>
        /// Togo
        /// </summary>
        public const string Togo = "TGO";

        /// <summary>
        /// Tokelau
        /// </summary>
        public const string Tokelau = "TKL";

        /// <summary>
        /// Tonga
        /// </summary>
        public const string Tonga = "TON";

        /// <summary>
        /// Trinidad and Tobago
        /// </summary>
        public const string TrinidadAndTobago = "TTO";

        /// <summary>
        /// Tunisia
        /// </summary>
        public const string Tunisia = "TUN";

        /// <summary>
        /// Turkey
        /// </summary>
        public const string Turkey = "TUR";

        /// <summary>
        /// Turkmenistan
        /// </summary>
        public const string Turkmenistan = "TKM";

        /// <summary>
        /// Turks and Caicos Islands
        /// </summary>
        public const string TurksAndCaicosIslands = "TCA";

        /// <summary>
        /// Tuvalu
        /// </summary>
        public const string Tuvalu = "TUV";

        /// <summary>
        /// Uganda
        /// </summary>
        public const string Uganda = "UGA";

        /// <summary>
        /// Ukraine
        /// </summary>
        public const string Ukraine = "UKR";

        /// <summary>
        /// United Arab Emirates
        /// </summary>
        public const string UnitedArabEmirates = "ARE";

        /// <summary>
        /// United Kingdom
        /// </summary>
        public const string UnitedKingdom = "GBR";

        /// <summary>
        /// United States Minor Outlying Islands
        /// </summary>
        public const string UnitedStatesMinorOutlyingIslands = "UMI";

        /// <summary>
        /// United States
        /// </summary>
        public const string UnitedStates = "USA";

        /// <summary>
        /// European Union
        /// </summary>
        public const string EuropeanUnion = "EUR";

        /// <summary>
        /// Uruguay
        /// </summary>
        public const string Uruguay = "URY";

        /// <summary>
        /// Uzbekistan
        /// </summary>
        public const string Uzbekistan = "UZB";

        /// <summary>
        /// Vanuatu
        /// </summary>
        public const string Vanuatu = "VUT";

        /// <summary>
        /// Venezuela
        /// </summary>
        public const string Venezuela = "VEN";

        /// <summary>
        /// Vietnam
        /// </summary>
        public const string Vietnam = "VNM";

        /// <summary>
        /// Virgin Islands British
        /// </summary>
        public const string VirginIslandsBritish = "VGB";

        /// <summary>
        /// Virgin Islands US
        /// </summary>
        public const string VirginIslandsUs = "VIR";

        /// <summary>
        /// Wallis and Futuna
        /// </summary>
        public const string WallisAndFutuna = "WLF";

        /// <summary>
        /// Western Sahara
        /// </summary>
        public const string WesternSahara = "ESH";

        /// <summary>
        /// Yemen
        /// </summary>
        public const string Yemen = "YEM";

        /// <summary>
        /// Zambia
        /// </summary>
        public const string Zambia = "ZMB";

        /// <summary>
        /// Zimbabwe
        /// </summary>
        public const string Zimbabwe = "ZWE";
    }
}
