/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

using System.Collections.Generic;

namespace QuantConnect.Interfaces
{
    /// <summary>
    /// Defines a C# algorithm as a regression algorithm to be run as part of the test suite.
    /// This interface also allows the algorithm to declare that it has versions in other languages
    /// that should yield identical results.
    /// </summary>
    public interface IRegressionAlgorithmDefinition
    {
        /// <summary>
        /// Final status of the algorithm
        /// </summary>
        AlgorithmStatus AlgorithmStatus { get; }

        /// <summary>
        /// This is used by the regression test system to indicate if the open source Lean repository has the required data to run this algorithm.
        /// </summary>
        bool CanRunLocally { get; }

        /// <summary>
        /// This is used by the regression test system to indicate which languages this algorithm is written in.
        /// </summary>
        List<Language> Languages { get; }

        /// <summary>
        /// Data Points count of all timeslices of algorithm
        /// </summary>
        long DataPoints { get; }

        /// <summary>
        /// Data Points count of the algorithm history
        /// </summary>
        int AlgorithmHistoryDataPoints { get; }

        /// <summary>
        /// This is used by the regression test system to indicate what the expected statistics are from running the algorithm
        /// </summary>
        Dictionary<string, string> ExpectedStatistics { get; }
    }
}
