/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

namespace QuantConnect.Orders
{
    /// <summary>
    /// Wolverine order properties
    /// </summary>
    public class WolverineOrderProperties : OrderProperties
    {
        /// <summary>
        /// The exchange post fix to apply if any
        /// </summary>
        public string ExchangePostFix { get; set; }

        /// <summary>
        /// Identifies the broker source for borrowed stock
        /// </summary>
        public string LocateBroker { get; set; }

        /// <summary>
        /// Can optionally specify the position side in the order direction (buy-to-open, sell-to-close, etc.) instead of the default handling
        /// </summary>
        public OrderPosition? PositionSide { get; set; }
    }
}
