﻿/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

namespace QuantConnect.Securities.Option.StrategyMatcher
{
    /// <summary>
    /// Specifies the type of value being compared against in a <see cref="OptionStrategyLegPredicate"/>.
    /// These values define the limits of what can be filtered and must match available slice methods in
    /// <see cref="OptionPositionCollection"/>
    /// </summary>
    public enum PredicateTargetValue
    {
        /// <summary>
        /// Predicate matches on <see cref="OptionPosition.Right"/> (0)
        /// </summary>
        Right,

        /// <summary>
        /// Predicate match on <see cref="OptionPosition.Quantity"/> (1)
        /// </summary>
        Quantity,

        /// <summary>
        /// Predicate matches on <see cref="OptionPosition.Strike"/> (2)
        /// </summary>
        Strike,

        /// <summary>
        /// Predicate matches on <see cref="OptionPosition.Expiration"/> (3)
        /// </summary>
        Expiration
    }
}