/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

namespace QuantConnect.Securities.Positions
{
    /// <summary>
    /// Defines the result for <see cref="IPositionGroupBuyingPowerModel.GetPositionGroupBuyingPower"/>
    /// </summary>
    public class PositionGroupBuyingPower
    {
        /// <summary>
        /// Gets the buying power
        /// </summary>
        public decimal Value { get; }

        /// <summary>
        /// Initializes a new instance of the <see cref="PositionGroupBuyingPower"/> class
        /// </summary>
        /// <param name="buyingPower">The buying power</param>
        public PositionGroupBuyingPower(decimal buyingPower)
        {
            Value = buyingPower;
        }

        /// <summary>
        /// Implicit operator from decimal
        /// </summary>
        public static implicit operator PositionGroupBuyingPower(decimal result)
        {
            return new PositionGroupBuyingPower(result);
        }

        /// <summary>
        /// Implicit operator to decimal
        /// </summary>
        public static implicit operator decimal(PositionGroupBuyingPower result)
        {
            return result.Value;
        }
    }
}
